package com.ozacc.blog.trackback.impl;

import java.net.URL;

import junit.framework.TestCase;

import org.apache.log4j.BasicConfigurator;

import com.ozacc.blog.trackback.ConnectionException;
import com.ozacc.blog.trackback.TrackBackAutoDiscovery;

/**
 * TrackBackAutoDiscoveryのテストケース。
 * 
 * @author Tomohiro Otsuka
 * @version $Id: TrackBackAutoDiscoveryTest.java 180 2005-07-22 09:26:25Z otsuka $
 */
public class TrackBackAutoDiscoveryTest extends TestCase {

	private TrackBackAutoDiscovery autoDiscovery;

	/*
	 * @see TestCase#setUp()
	 */
	protected void setUp() throws Exception {
		super.setUp();
		BasicConfigurator.configure();
		autoDiscovery = new TrackBackAutoDiscoveryImpl();
	}

	/**
	 * @see junit.framework.TestCase#tearDown()
	 */
	protected void tearDown() throws Exception {
		BasicConfigurator.resetConfiguration();
	}

	/**
	 * MovableType
	 * 
	 * @throws Exception
	 */
	public final void testDiscoverTrackBackUrlsMT() throws Exception {
		URL url = new URL("http://spring-ext.sourceforge.jp/blog/archives/2004/08/trackback.html");
		URL[] expected = new URL[] { new URL("http://spring-ext.sourceforge.jp/cgi-bin/mt-tb.cgi/2") };

		URL[] result = autoDiscovery.discoverTrackBackUrls(url);
		assertEquals(1, result.length);
		assertEquals(expected[0].toString(), result[0].toString());
	}

	/**
	 * はてな
	 * 
	 * @throws Exception
	 */
	public final void testDiscoverTrackBackUrlsHatena() throws Exception {
		URL url = new URL("http://d.hatena.ne.jp/koseki/20040825");
		URL[] expected = new URL[] { new URL("http://d.hatena.ne.jp/koseki/20040825"),
				new URL("http://d.hatena.ne.jp/koseki/20040825") };

		URL[] result = autoDiscovery.discoverTrackBackUrls(url);

		assertEquals(expected.length, result.length);
		assertEquals(expected[0].toString(), result[0].toString());
		assertEquals(expected[1].toString(), result[1].toString());
	}

	/**
	 * Excite Blog
	 * 
	 * @throws Exception
	 */
	public final void testDiscoverTrackBackUrlsExcite() throws Exception {
		URL url = new URL("http://dezain.exblog.jp/900284/");
		URL[] expected = new URL[] { new URL("http://dezain.exblog.jp/tb/900284"), };

		URL[] result = autoDiscovery.discoverTrackBackUrls(url);

		assertEquals(expected.length, result.length);
		assertEquals(expected[0].toString(), result[0].toString());
	}

	/**
	 * Livedoor Blog
	 * 
	 * @throws Exception
	 */
/*	public final void testDiscoverTrackBackUrlsLivedoor() throws Exception {
		URL url = new URL("http://blog.livedoor.jp/takapon_ceo/archives/50010771.html");
		URL[] expected = new URL[] { new URL(
				"http://app.blog.livedoor.jp/takapon_ceo/tb.cgi/50010771"), };

		URL[] result = autoDiscovery.discoverTrackBackUrls(url);

		assertEquals(expected.length, result.length);
		assertEquals(expected[0].toString(), result[0].toString());
	}
*/
	/**
	 * Auto-Discovery失敗。
	 * 
	 * @throws Exception
	 */
	public final void testDiscoverTrackBackUrlsNotFound() throws Exception {
		URL url = new URL("http://www.gooooooooooooooooooogle.jp/");
		try {
			autoDiscovery.discoverTrackBackUrls(url);
			fail("This should never be called.");
		} catch (ConnectionException expected) {
			// success
			expected.printStackTrace();
		}
	}

	public final void testDiscoverTrackBackUrlsReturnZero() throws Exception {
		URL url = new URL("http://www.google.com/");
		URL[] result = autoDiscovery.discoverTrackBackUrls(url);
		assertEquals(0, result.length);
	}

}