/*
 * Decompiled with CFR 0.152.
 */
package com.ozacc.blog.ping.impl;

import com.ozacc.blog.ping.AsyncUpdatePingClient;
import com.ozacc.blog.ping.UpdatePing;
import com.ozacc.blog.ping.UpdatePingCallbackHandler;
import com.ozacc.blog.ping.UpdatePingException;
import com.ozacc.blog.ping.impl.XmlRpcUpdatePingClient;
import java.net.URL;
import org.apache.xmlrpc.AsyncCallback;
import org.apache.xmlrpc.XmlRpcClient;

public class AsyncXmlRpcUpdatePingClient
extends XmlRpcUpdatePingClient
implements AsyncUpdatePingClient {
    public void ping(String pingUrl, UpdatePing ping, UpdatePingCallbackHandler handler) {
        XmlRpcClient client;
        AsyncCallback asyncCallback = this.createAsyncCallbackInstance(handler);
        try {
            client = this.getRpcClient(pingUrl);
        }
        catch (UpdatePingException e) {
            handler.handleError(e, pingUrl);
            return;
        }
        client.executeAsync(PING_METHOD_NAME, ping.getParameters(), asyncCallback);
    }

    public void ping(String pingUrl, String blogName, String blogUrl, UpdatePingCallbackHandler handler) {
        UpdatePing ping = new UpdatePing(blogName, blogUrl);
        this.ping(pingUrl, ping, handler);
    }

    private AsyncCallback createAsyncCallbackInstance(final UpdatePingCallbackHandler handler) {
        return new AsyncCallback(){

            public void handleResult(Object result, URL url, String method) {
                try {
                    String message = AsyncXmlRpcUpdatePingClient.this.processResult(result);
                    handler.handleResult(message, url.toExternalForm());
                }
                catch (UpdatePingException ex) {
                    handler.handleError(ex, url.toExternalForm());
                }
            }

            public void handleError(Exception ex, URL url, String method) {
                handler.handleError(new UpdatePingException(ex.getMessage(), ex), url.toExternalForm());
            }
        };
    }

    public void ping(String[] pingUrls, UpdatePing ping, UpdatePingCallbackHandler handler) {
        int i = 0;
        while (i < pingUrls.length) {
            String url = pingUrls[i];
            this.ping(url, ping, handler);
            ++i;
        }
    }
}

