package com.ozacc.mail.mock;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.ozacc.mail.MailException;
import com.ozacc.mail.fetch.FetchMail;
import com.ozacc.mail.fetch.ReceivedMail;

/**
 * FetchMailImpl饹Mock<br>
 * <code>setupGetMails()</code>᥽åɤ<code>ReceivedMail</code>󥹥󥹤򥻥åȤȡ<code>getMails()</code>᥽åɤΥ󥹥󥹤֤ޤ
 * 
 * @since 1.2
 * @author Tomohiro Otsuka
 * @version $Id: MockFetchMail.java,v 1.1.2.3 2005/02/05 09:25:25 otsuka Exp $
 */
public class MockFetchMail implements FetchMail {

	private static Log log = LogFactory.getLog(MockFetchMail.class);

	/** ǥեȤSMTPСlocalhost */
	public static final String DEFAULT_HOST = "localhost";

	/** ǥեȤΥץȥ롣pop3 */
	public static final String DEFAULT_PROTOCOL = "pop3";

	/**
	 * ǥեȤΥݡȡ-1<br>
	 * -1ϥץȥ˱ŬڤʥݡȤꤹ̤͡
	 */
	public static final int DEFAULT_PORT = -1;

	private static final String INBOX_NAME = "INBOX";

	private String host = DEFAULT_HOST;

	private String protocol = DEFAULT_PROTOCOL;

	private int port = DEFAULT_PORT;

	private String username;

	private String password;

	private List receivedMails;

	/**
	 * 󥹥ȥ饯
	 */
	public MockFetchMail() {
		super();
		receivedMails = new ArrayList();
	}

	/**
	 * <code>MockFetchMail</code><code>getMails()</code>᥽åɤ֤
	 * <code>ReceivedMail</code>󥹥󥹤򥻥åȤޤ
	 * 
	 * @param mail <code>getMails()</code>᥽åɤ֤<code>ReceivedMail</code>󥹥
	 */
	public void setupGetMails(ReceivedMail mail) {
		receivedMails.add(mail);
	}

	/**
	 * <code>MockFetchMail</code><code>getMails()</code>᥽åɤ֤
	 * <code>ReceivedMail</code>󥹥󥹤򥻥åȤޤ
	 * 
	 * @param mails <code>getMails()</code>᥽åɤ֤<code>ReceivedMail</code>󥹥
	 */
	public void setupGetMails(ReceivedMail[] mails) {
		for (int i = 0; i < mails.length; i++) {
			ReceivedMail mail = mails[i];
			setupGetMails(mail);
		}
	}

	/**
	 * @see com.ozacc.mail.fetch.FetchMail#getMails()
	 */
	public ReceivedMail[] getMails() throws MailException {
		log.debug(protocol.toUpperCase() + "[" + host + "]³եꡣ");
		log.debug(protocol.toUpperCase() + "[" + host + "]³եꡣ");

		if (receivedMails.size() > 0) {
			log.debug(receivedMails.size() + "̤Υ᡼եꡣ");
		} else {
			log.debug("ե򤹤᡼Ϥޤ");
		}
		try {
			return (ReceivedMail[])receivedMails.toArray(new ReceivedMail[receivedMails.size()]);
		} finally {
			log.debug(protocol.toUpperCase() + "[" + host + "]Ȥ³Ǥեꡣ");
			log.debug(protocol.toUpperCase() + "[" + host + "]Ȥ³Ǥեꡣ");
		}
	}

	/**
	 * @see com.ozacc.mail.fetch.FetchMail#getMails(boolean)
	 */
	public ReceivedMail[] getMails(boolean delete) throws MailException {
		ReceivedMail[] result = getMails();
		if (delete) {
			receivedMails.clear();
		}
		return result;
	}

	/**
	 * @return Returns the host.
	 */
	public String getHost() {
		return host;
	}

	/**
	 * @param host The host to set.
	 */
	public void setHost(String host) {
		this.host = host;
	}

	/**
	 * @return Returns the password.
	 */
	public String getPassword() {
		return password;
	}

	/**
	 * @param password The password to set.
	 */
	public void setPassword(String password) {
		this.password = password;
	}

	/**
	 * @return Returns the port.
	 */
	public int getPort() {
		return port;
	}

	/**
	 * @param port The port to set.
	 */
	public void setPort(int port) {
		this.port = port;
	}

	/**
	 * @return Returns the protocol.
	 */
	public String getProtocol() {
		return protocol;
	}

	/**
	 * @param protocol The protocol to set.
	 */
	public void setProtocol(String protocol) {
		this.protocol = protocol;
	}

	/**
	 * @return Returns the username.
	 */
	public String getUsername() {
		return username;
	}

	/**
	 * @param username The username to set.
	 */
	public void setUsername(String username) {
		this.username = username;
	}
}