/*
 * Decompiled with CFR 0.152.
 */
package com.ozacc.mail.fetch.impl.sk_jp;

import com.ozacc.mail.fetch.impl.sk_jp.JISDataSource;
import com.ozacc.mail.fetch.impl.sk_jp.io.CharCodeConverter;
import com.ozacc.mail.fetch.impl.sk_jp.io.UnicodeCorrector;
import com.ozacc.mail.fetch.impl.sk_jp.text.EntityRefEncoder;
import com.ozacc.mail.fetch.impl.sk_jp.util.StringValues;
import com.sun.mail.util.ASCIIUtility;
import com.sun.mail.util.BASE64DecoderStream;
import com.sun.mail.util.BASE64EncoderStream;
import com.sun.mail.util.QDecoderStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.internet.AddressException;
import javax.mail.internet.ContentDisposition;
import javax.mail.internet.ContentType;
import javax.mail.internet.HeaderTokenizer;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MailDateFormat;
import javax.mail.internet.MimeUtility;
import javax.mail.internet.ParseException;

public class MailUtility {
    private static MailDateFormat mailDateFormat = new MailDateFormat();

    public static String getPersonal(InternetAddress a) {
        if (a.getPersonal() != null) {
            return a.getPersonal();
        }
        return a.toString();
    }

    public static String getMailAddresses(InternetAddress[] addresses) {
        if (addresses == null) {
            return null;
        }
        StringValues buf = new StringValues();
        int i = 0;
        while (i < addresses.length) {
            buf.add(addresses[i].getAddress());
            ++i;
        }
        return buf.getString();
    }

    public static String getPersonalNames(InternetAddress[] addresses) {
        if (addresses == null) {
            return null;
        }
        StringValues buf = new StringValues();
        int i = 0;
        while (i < addresses.length) {
            String name = MailUtility.decodeText(MailUtility.unfold(addresses[i].getPersonal()));
            if (name == null) {
                name = addresses[i].toString();
            }
            buf.add(name);
            ++i;
        }
        return buf.getString();
    }

    public static String getAddressesHTML(InternetAddress[] addresses) {
        if (addresses == null) {
            return null;
        }
        StringValues buf = new StringValues();
        StringBuffer href = new StringBuffer();
        int i = 0;
        while (i < addresses.length) {
            href.append("<a href=\"mailto:");
            href.append(addresses[i].getAddress());
            href.append("\">");
            String name = addresses[i].getPersonal();
            if (name != null) {
                name = MailUtility.decodeText(name);
            }
            if (name == null) {
                name = addresses[i].toString();
            }
            href.append(EntityRefEncoder.encode(name));
            href.append("</a>");
            buf.add(new String(href));
            href.setLength(0);
            ++i;
        }
        return buf.getString();
    }

    public static String getTransferEncoding(byte[] b) {
        int nonAscii = 0;
        int i = 0;
        while (i < b.length) {
            if (b[i] < 0) {
                ++nonAscii;
            }
            ++i;
        }
        if (nonAscii == 0) {
            return "7bit";
        }
        if (nonAscii < b.length - nonAscii) {
            return "quoted-printable";
        }
        return "base64";
    }

    public static Message getParentMessage(Part part) {
        Part current = part;
        while (!(current instanceof Message)) {
            Multipart mp = ((BodyPart)current).getParent();
            if (mp == null) {
                return null;
            }
            current = mp.getParent();
            if (current != null) continue;
            return null;
        }
        return (Message)current;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date parseDate(String rfc822DateString) {
        if (rfc822DateString == null) {
            return null;
        }
        try {
            if (rfc822DateString.indexOf(" JST") == -1 || rfc822DateString.indexOf(43) >= 0) {
                MailDateFormat mailDateFormat = MailUtility.mailDateFormat;
                synchronized (mailDateFormat) {
                    return MailUtility.mailDateFormat.parse(rfc822DateString);
                }
            }
            StringBuffer buf = new StringBuffer(rfc822DateString.substring(0, rfc822DateString.indexOf("JST")));
            buf.append("+0900");
            MailDateFormat mailDateFormat = MailUtility.mailDateFormat;
            synchronized (mailDateFormat) {
                return MailUtility.mailDateFormat.parse(new String(buf));
            }
        }
        catch (java.text.ParseException e) {
            return null;
        }
    }

    public static String createReplySubject(String src) {
        if (src == null || src.length() == 0) {
            return "Re: (no subject)";
        }
        String work = src;
        if (work.charAt(0) == '[' && work.indexOf(93) > 0) {
            int afterBracket = MailUtility.indexOfNonLWSP(work, work.indexOf(93) + 1, false);
            work = afterBracket < 0 ? "" : work.substring(afterBracket);
        }
        if (work.length() > 3 && "Re:".equalsIgnoreCase(work.substring(0, 3))) {
            int afterRe = MailUtility.indexOfNonLWSP(work, 3, false);
            work = afterRe < 0 ? "" : work.substring(afterRe);
        }
        return "Re: " + work;
    }

    public static InternetAddress[] parseAddresses(String addressesString) throws AddressException {
        return MailUtility.parseAddresses(addressesString, true);
    }

    public static InternetAddress[] parseAddresses(String addressesString, boolean strict) throws AddressException {
        if (addressesString == null) {
            return null;
        }
        try {
            InternetAddress[] addresses = InternetAddress.parse((String)addressesString, (boolean)strict);
            int i = 0;
            while (i < addresses.length) {
                addresses[i].setPersonal(addresses[i].getPersonal(), "ISO-2022-JP");
                ++i;
            }
            return addresses;
        }
        catch (UnsupportedEncodingException e) {
            throw new InternalError(e.toString());
        }
    }

    public static String unfold(String source) {
        if (source == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        boolean skip = false;
        int i = 0;
        while (i < source.length()) {
            block8: {
                char c;
                block7: {
                    c = source.charAt(i);
                    if (!skip) break block7;
                    if (MailUtility.isLWSP(c)) break block8;
                    skip = false;
                }
                if (c != '\r' && c != '\n') {
                    buf.append(c);
                } else {
                    buf.append(' ');
                    skip = true;
                }
            }
            ++i;
        }
        return new String(buf);
    }

    public static String fold(String source, int used) {
        if (source == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        String work = source;
        while (work.length() > 76) {
            int lineBreakIndex = work.lastIndexOf(32, 76);
            if (lineBreakIndex == -1) break;
            buf.append(work.substring(0, lineBreakIndex));
            buf.append("\r\n");
            work = work.substring(lineBreakIndex);
        }
        buf.append(work);
        return new String(buf);
    }

    public static void setTextContent(Part p, String s) throws MessagingException {
        p.setDataHandler(new DataHandler((DataSource)new JISDataSource(s)));
        p.setHeader("Content-Transfer-Encoding", "7bit");
    }

    public static String encodeWordJIS(String s) {
        try {
            return "=?ISO-2022-JP?B?" + new String(BASE64EncoderStream.encode((byte[])CharCodeConverter.sjisToJis(UnicodeCorrector.getInstance("Windows-31J").correct(s).getBytes("Windows-31J")))) + "?=";
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("CANT HAPPEN");
        }
    }

    public static String decodeText(String source) {
        if (source == null) {
            return null;
        }
        if (source.indexOf(27) >= 0) {
            try {
                return new String(source.getBytes("ISO-8859-1"), "ISO-2022-JP");
            }
            catch (UnsupportedEncodingException e) {
                throw new InternalError();
            }
        }
        String decodedText = new RFC2047Decoder(source).get();
        if (decodedText.indexOf(27) >= 0) {
            try {
                return new String(decodedText.getBytes("ISO-8859-1"), "ISO-2022-JP");
            }
            catch (UnsupportedEncodingException e) {
                throw new InternalError();
            }
        }
        return decodedText;
    }

    private static byte[] decodeByTES(String s, String tes) {
        int i;
        while ((i = MailUtility.indexOfLWSP(s, 0, false, '\u0000')) >= 0) {
            s = String.valueOf(s.substring(0, i)) + s.substring(i + 1);
        }
        if (tes.equalsIgnoreCase("B") && s.length() % 4 != 0) {
            switch (4 - s.length() % 4) {
                case 1: {
                    s = String.valueOf(s) + '=';
                    break;
                }
                case 2: {
                    s = String.valueOf(s) + "==";
                    break;
                }
                case 3: {
                    s = s.charAt(s.length() - 1) != '=' ? String.valueOf(s) + "===" : s.substring(0, s.length() - 1);
                }
            }
        }
        try {
            BASE64DecoderStream is;
            ByteArrayInputStream bis = new ByteArrayInputStream(ASCIIUtility.getBytes((String)s));
            if (tes.equalsIgnoreCase("B")) {
                is = new BASE64DecoderStream((InputStream)bis);
            } else if (tes.equalsIgnoreCase("Q")) {
                is = new QDecoderStream((InputStream)bis);
            } else {
                throw new UnsupportedEncodingException(tes);
            }
            int count = bis.available();
            byte[] bytes = new byte[count];
            count = is.read(bytes, 0, count);
            if (count != bytes.length) {
                byte[] w = new byte[count];
                System.arraycopy(bytes, 0, w, 0, count);
                bytes = w;
            }
            return bytes;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException("CANT HAPPEN");
        }
    }

    public static String encodeText(String source, String charset, String encoding) throws UnsupportedEncodingException {
        if (source == null) {
            return null;
        }
        int endIndex = 0;
        StringBuffer buf = new StringBuffer();
        while (true) {
            int boundaryIndex;
            if ((boundaryIndex = MailUtility.indexOfNonAscii(source, endIndex)) == -1) {
                buf.append(source.substring(endIndex));
                return new String(buf);
            }
            int lastLWSPIndex = MailUtility.indexOfLWSP(source, boundaryIndex, true, '(');
            int startIndex = MailUtility.indexOfNonLWSP(source, lastLWSPIndex, true) + 1;
            int n = startIndex = endIndex > startIndex ? endIndex : startIndex;
            if (startIndex > endIndex) {
                buf.append(source.substring(endIndex, startIndex));
                if (MailUtility.isLWSP(source.charAt(startIndex))) {
                    buf.append("\r\n ");
                    ++startIndex;
                }
            }
            endIndex = MailUtility.indexOfNonLWSP(source, boundaryIndex, false);
            while ((endIndex = MailUtility.indexOfLWSP(source, endIndex, false, ')')) != -1) {
                int nextBoundary = MailUtility.indexOfLWSP(source, endIndex = MailUtility.indexOfNonLWSP(source, endIndex, false), false, '\u0000');
                if (nextBoundary == -1) {
                    if (MailUtility.indexOfNonAscii(source, endIndex) == -1) break;
                    endIndex = -1;
                    break;
                }
                int nonAscii = MailUtility.indexOfNonAscii(source, endIndex);
                if (nonAscii == -1 || nonAscii >= nextBoundary) break;
                endIndex = nextBoundary;
            }
            boolean needFolding = false;
            if (endIndex < 0) {
                endIndex = source.length();
            } else if (MailUtility.isLWSP(source.charAt(endIndex - 1))) {
                --endIndex;
                needFolding = true;
            }
            String encodeTargetText = source.substring(startIndex, endIndex);
            buf.append(MimeUtility.encodeWord((String)encodeTargetText, (String)charset, (String)encoding));
            if (!needFolding) continue;
            ++endIndex;
            buf.append("\r\n ");
        }
    }

    public static int indexOfNonAscii(String source, int startIndex) {
        int i = startIndex;
        while (i < source.length()) {
            if (source.charAt(i) > '\u007f') {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int indexOfNonLWSP(String source, int startIndex, boolean decrease) {
        int inc = 1;
        if (decrease) {
            inc = -1;
        }
        int i = startIndex;
        while (i >= 0 && i < source.length()) {
            char c = source.charAt(i);
            if (!MailUtility.isLWSP(c)) {
                return i;
            }
            i += inc;
        }
        return -1;
    }

    public static int indexOfLWSP(String source, int startIndex, boolean decrease, char additionalDelimiter) {
        int inc = 1;
        if (decrease) {
            inc = -1;
        }
        int i = startIndex;
        while (i >= 0 && i < source.length()) {
            char c = source.charAt(i);
            if (MailUtility.isLWSP(c) || c == additionalDelimiter) {
                return i;
            }
            i += inc;
        }
        return -1;
    }

    public static boolean isLWSP(char c) {
        return c == '\r' || c == '\n' || c == ' ' || c == '\t';
    }

    public static void setFileName(Part part, String filename, String charset, String lang) throws MessagingException {
        ContentDisposition disposition;
        String[] strings = part.getHeader("Content-Disposition");
        if (strings == null || strings.length < 1) {
            disposition = new ContentDisposition("attachment");
        } else {
            disposition = new ContentDisposition(strings[0]);
            disposition.getParameterList().remove("filename");
        }
        part.setHeader("Content-Disposition", String.valueOf(disposition.toString()) + MailUtility.encodeParameter("filename", filename, charset, lang));
        strings = part.getHeader("Content-Type");
        ContentType cType = strings == null || strings.length < 1 ? new ContentType(part.getDataHandler().getContentType()) : new ContentType(strings[0]);
        try {
            int i;
            String mimeString = MimeUtility.encodeWord((String)filename, (String)charset, (String)"B");
            StringBuffer sb = new StringBuffer();
            while ((i = mimeString.indexOf(13)) != -1) {
                sb.append(mimeString.substring(0, i));
                mimeString = mimeString.substring(i + 2);
            }
            sb.append(mimeString);
            cType.setParameter("name", new String(sb));
        }
        catch (UnsupportedEncodingException e) {
            throw new MessagingException("Encoding error", (Exception)e);
        }
        part.setHeader("Content-Type", cType.toString());
    }

    public static String encodeParameter(String name, String value, String encoding, String lang) {
        StringBuffer result = new StringBuffer();
        StringBuffer encodedPart = new StringBuffer();
        boolean needWriteCES = !MailUtility.isAllAscii(value);
        boolean CESWasWritten = false;
        boolean needFolding = false;
        int sequenceNo = 0;
        while (value.length() > 0) {
            boolean encoded;
            boolean isAscii = value.charAt(0) < '\u0080';
            int lastIndex = 1;
            while (lastIndex < value.length()) {
                if (value.charAt(lastIndex) < '\u0080' ? !isAscii : isAscii) break;
                ++lastIndex;
            }
            if (lastIndex != value.length()) {
                needFolding = true;
            }
            block4: while (true) {
                byte[] bytes;
                encodedPart.setLength(0);
                String target = value.substring(0, lastIndex);
                try {
                    bytes = isAscii ? target.getBytes("us-ascii") : target.getBytes(encoding);
                }
                catch (UnsupportedEncodingException e) {
                    bytes = target.getBytes();
                    encoding = MimeUtility.mimeCharset((String)MimeUtility.getDefaultJavaCharset());
                }
                encoded = false;
                int column = name.length() + 7;
                int i = 0;
                while (i < bytes.length) {
                    if (bytes[i] >= 48 && bytes[i] <= 57 || bytes[i] >= 65 && bytes[i] <= 90 || bytes[i] >= 97 && bytes[i] <= 122 || bytes[i] == 36 || bytes[i] == 46 || bytes[i] == 33) {
                        encodedPart.append((char)bytes[i]);
                        ++column;
                    } else {
                        encoded = true;
                        encodedPart.append('%');
                        String hex = Integer.toString(bytes[i] & 0xFF, 16);
                        if (hex.length() == 1) {
                            encodedPart.append('0');
                        }
                        encodedPart.append(hex);
                        column += 3;
                    }
                    if (column > 76) {
                        needFolding = true;
                        lastIndex /= 2;
                        continue block4;
                    }
                    ++i;
                }
                break;
            }
            result.append(";\r\n ").append(name);
            if (needFolding) {
                result.append('*').append(sequenceNo);
                ++sequenceNo;
            }
            if (!CESWasWritten && needWriteCES) {
                result.append("*=");
                CESWasWritten = true;
                result.append(encoding).append('\'');
                if (lang != null) {
                    result.append(lang);
                }
                result.append('\'');
            } else if (encoded) {
                result.append("*=");
            } else {
                result.append('=');
            }
            result.append(new String(encodedPart));
            value = value.substring(lastIndex);
        }
        return new String(result);
    }

    public static boolean isAllAscii(String text) {
        int i = 0;
        while (i < text.length()) {
            if (text.charAt(i) > '\u007f') {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static String getFileName(Part part) throws MessagingException {
        String filename;
        String[] disposition = part.getHeader("Content-Disposition");
        if (disposition == null || disposition.length < 1 || (filename = MailUtility.getParameter(disposition[0], "filename")) == null) {
            filename = part.getFileName();
            if (filename != null) {
                return MailUtility.decodeParameterSpciallyJapanese(filename);
            }
            return null;
        }
        return filename;
    }

    public static String getParameter(String header, String name) throws ParseException {
        StringBuffer sb;
        block11: {
            if (header == null) {
                return null;
            }
            header = MailUtility.decodeParameterSpciallyJapanese(header);
            HeaderTokenizer tokenizer = new HeaderTokenizer(header, ";=\t ", true);
            sb = new StringBuffer();
            Encoding encoding = new Encoding();
            try {
                HeaderTokenizer.Token token;
                while ((token = tokenizer.next()).getType() != -4) {
                    if (token.getType() != 59) continue;
                    token = tokenizer.next();
                    MailUtility.checkType(token);
                    String n = token.getValue();
                    token = tokenizer.next();
                    if (token.getType() != 61) {
                        throw new ParseException("Illegal token : " + token.getValue());
                    }
                    token = tokenizer.next();
                    MailUtility.checkType(token);
                    String v = token.getValue();
                    if (n.equalsIgnoreCase(name)) {
                        return v;
                    }
                    int index = name.length();
                    if (!n.startsWith(name) || n.charAt(index) != '*') continue;
                    int lastIndex = n.length() - 1;
                    if (n.charAt(lastIndex) == '*') {
                        if (index == lastIndex || n.charAt(index + 1) == '0') {
                            sb.append(MailUtility.decodeRFC2231(v, encoding, true));
                        } else {
                            sb.append(MailUtility.decodeRFC2231(v, encoding, false));
                        }
                    } else {
                        sb.append(v);
                    }
                    if (index != lastIndex) continue;
                }
                if (sb.length() != 0) break block11;
                return null;
            }
            catch (UnsupportedEncodingException e) {
                throw new ParseException(e.toString());
            }
        }
        return new String(sb);
    }

    private static void checkType(HeaderTokenizer.Token token) throws ParseException {
        int t = token.getType();
        if (t != -1 && t != -2) {
            throw new ParseException("Illegal token : " + token.getValue());
        }
    }

    private static String decodeRFC2231(String s, Encoding encoding, boolean isInitialSection) throws ParseException, UnsupportedEncodingException {
        int work;
        StringBuffer sb = new StringBuffer();
        int i = 0;
        if (isInitialSection && (work = s.indexOf(39)) > 0) {
            encoding.encoding = s.substring(0, work);
            if ((i = s.indexOf(39, ++work)) < 0) {
                throw new ParseException("lang tag area was missing.");
            }
            encoding.lang = s.substring(work, i);
            ++i;
        }
        try {
            while (i < s.length()) {
                if (s.charAt(i) == '%') {
                    sb.append((char)Integer.parseInt(s.substring(i + 1, i + 3), 16));
                    i += 2;
                } else {
                    sb.append(s.charAt(i));
                }
                ++i;
            }
            return new String(new String(sb).getBytes("ISO-8859-1"), encoding.encoding);
        }
        catch (IndexOutOfBoundsException e) {
            throw new ParseException(String.valueOf(s) + " :: this string were not decoded.");
        }
    }

    private static String decodeParameterSpciallyJapanese(String s) throws ParseException {
        try {
            s = new String(s.getBytes("ISO-8859-1"), "JISAutoDetect");
            return MailUtility.decodeText(s);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new ParseException("Unsupported Encoding");
        }
    }

    private MailUtility() {
    }

    static class RFC2047Decoder {
        private String source;
        private String pooledCES;
        private byte[] pooledBytes;
        private StringBuffer buf;
        private int pos = 0;
        private int startIndex;
        private int endIndex;

        public RFC2047Decoder(String source) {
            this.source = source;
            this.buf = new StringBuffer(source.length());
            this.parse();
        }

        private void parse() {
            while (this.hasEncodedWord()) {
                String work = this.source.substring(this.pos, this.startIndex);
                if (MailUtility.indexOfNonLWSP(work, 0, false) > -1) {
                    this.sweepPooledBytes();
                    this.buf.append(work);
                }
                this.parseWord();
            }
            this.sweepPooledBytes();
            this.buf.append(this.source.substring(this.pos));
        }

        private boolean hasEncodedWord() {
            this.startIndex = this.source.indexOf("=?", this.pos);
            if (this.startIndex == -1) {
                return false;
            }
            this.endIndex = this.source.indexOf("?=", this.startIndex + 2);
            if (this.endIndex == -1) {
                return false;
            }
            this.endIndex += 2;
            return true;
        }

        private void parseWord() {
            try {
                int s = this.startIndex + 2;
                int e = this.source.indexOf(63, s);
                if (e == this.endIndex - 2) {
                    throw new RuntimeException();
                }
                String ces = this.source.substring(s, e);
                try {
                    "".getBytes(ces);
                }
                catch (UnsupportedEncodingException ex) {
                    ces = "JISAutoDetect";
                }
                s = e + 1;
                e = this.source.indexOf(63, s);
                if (e == this.endIndex - 2) {
                    throw new RuntimeException();
                }
                String tes = this.source.substring(s, e);
                byte[] bytes = MailUtility.decodeByTES(this.source.substring(e + 1, this.endIndex - 2), tes);
                if (ces.equals(this.pooledCES)) {
                    byte[] w = new byte[this.pooledBytes.length + bytes.length];
                    System.arraycopy(this.pooledBytes, 0, w, 0, this.pooledBytes.length);
                    System.arraycopy(bytes, 0, w, this.pooledBytes.length, bytes.length);
                    this.pooledBytes = w;
                } else {
                    this.sweepPooledBytes();
                    this.pooledCES = ces;
                    this.pooledBytes = bytes;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.buf.append(this.source.substring(this.startIndex, this.endIndex));
            }
            this.pos = this.endIndex;
        }

        private void sweepPooledBytes() {
            if (this.pooledBytes == null) {
                return;
            }
            try {
                this.buf.append(new String(this.pooledBytes, this.pooledCES));
            }
            catch (UnsupportedEncodingException e) {
                throw new InternalError("CANT HAPPEN: Illegal encoding = " + this.pooledCES);
            }
            this.pooledCES = null;
            this.pooledBytes = null;
        }

        public String get() {
            return new String(this.buf);
        }
    }

    static class Encoding {
        String encoding = "us-ascii";
        String lang = "";

        Encoding() {
        }
    }
}

