/*
 * Decompiled with CFR 0.152.
 */
package com.ozacc.mail.fetch.impl.sk_jp.io;

import com.ozacc.mail.fetch.impl.sk_jp.io.FromCP932Corrector;
import com.ozacc.mail.fetch.impl.sk_jp.io.ToCP932Corrector;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;

public abstract class UnicodeCorrector {
    private static final Map correctorMap = new HashMap();

    public static UnicodeCorrector getInstance(String enc) throws UnsupportedEncodingException {
        Class correctorClass = (Class)correctorMap.get(enc.toLowerCase());
        if (correctorClass == null) {
            throw new UnsupportedEncodingException(enc);
        }
        try {
            return (UnicodeCorrector)correctorClass.newInstance();
        }
        catch (Exception e) {
            throw new UnsupportedEncodingException(correctorClass + " cannot get newInstance.\n" + e);
        }
    }

    public char[] correct(char[] cbuf, int off, int len) {
        StringBuffer buf = new StringBuffer();
        for (int i = off; i < len; ++i) {
            buf.append(this.correct(cbuf[i]));
        }
        return new String(buf).toCharArray();
    }

    public String correct(String s) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            buf.append(this.correct(s.charAt(i)));
        }
        return new String(buf);
    }

    public abstract char correct(char var1);

    public static void addCorrector(String enc, Class correctorClass) {
        if (!correctorClass.isInstance(UnicodeCorrector.class)) {
            throw new IllegalArgumentException("Corrector is not UnicodeCorrector type.");
        }
        correctorMap.put(enc, correctorClass);
    }

    static {
        correctorMap.put("iso2022jp", FromCP932Corrector.class);
        correctorMap.put("iso-2022-jp", FromCP932Corrector.class);
        correctorMap.put("euc-jp", FromCP932Corrector.class);
        correctorMap.put("eucjis", FromCP932Corrector.class);
        correctorMap.put("sjis", FromCP932Corrector.class);
        correctorMap.put("shift_jis", FromCP932Corrector.class);
        correctorMap.put("ms932", ToCP932Corrector.class);
        correctorMap.put("windows-31j", ToCP932Corrector.class);
    }
}

