/*
 * Decompiled with CFR 0.152.
 */
package com.ozacc.mail.xml.impl;

import com.ozacc.mail.Mail;
import com.ozacc.mail.xml.XMLBuildException;
import com.ozacc.mail.xml.XMLBuilder;
import java.io.File;
import java.util.Properties;
import javax.mail.internet.InternetAddress;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XMLBuilderImpl
implements XMLBuilder {
    private String charset = "UTF-8";

    public XMLBuilderImpl() {
    }

    public XMLBuilderImpl(String charset) {
        this.charset = charset;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public Document buildDocument(Mail mail) throws XMLBuildException {
        Document doc = XMLBuilderImpl.createNewDocument();
        Element mailElem = doc.createElement("mail");
        if (mail.getReturnPath() != null) {
            InternetAddress returnPath = mail.getReturnPath();
            Element returnPathElem = this.convertInternetAddressIntoElement(returnPath, "returnPath", doc);
            mailElem.appendChild(returnPathElem);
        }
        if (mail.getFrom() != null) {
            InternetAddress from = mail.getFrom();
            Element fromElem = this.convertInternetAddressIntoElement(from, "from", doc);
            mailElem.appendChild(fromElem);
        }
        if (mail.getTo().length > 0 || mail.getCc().length > 0 || mail.getBcc().length > 0) {
            Element recipientsElem = doc.createElement("recipients");
            if (mail.getTo().length > 0) {
                for (int i = 0; i < mail.getTo().length; ++i) {
                    InternetAddress to = mail.getTo()[i];
                    Element toElem = this.convertInternetAddressIntoElement(to, "to", doc);
                    recipientsElem.appendChild(toElem);
                }
            }
            if (mail.getCc().length > 0) {
                for (int i = 0; i < mail.getCc().length; ++i) {
                    InternetAddress cc = mail.getCc()[i];
                    Element ccElem = this.convertInternetAddressIntoElement(cc, "cc", doc);
                    recipientsElem.appendChild(ccElem);
                }
            }
            if (mail.getBcc().length > 0) {
                for (int i = 0; i < mail.getBcc().length; ++i) {
                    InternetAddress bcc = mail.getBcc()[i];
                    Element bccElem = this.convertInternetAddressIntoElement(bcc, "bcc", doc);
                    recipientsElem.appendChild(bccElem);
                }
            }
            mailElem.appendChild(recipientsElem);
        }
        if (mail.getReplyTo() != null) {
            InternetAddress replyTo = mail.getReplyTo();
            Element replyToElem = this.convertInternetAddressIntoElement(replyTo, "replyTo", doc);
            mailElem.appendChild(replyToElem);
        }
        if (mail.getSubject() != null) {
            Element subjectElem = doc.createElement("subject");
            subjectElem.appendChild(doc.createTextNode(mail.getSubject()));
            mailElem.appendChild(subjectElem);
        }
        if (mail.getText() != null) {
            Element bodyElem = doc.createElement("body");
            bodyElem.appendChild(doc.createTextNode(mail.getText()));
            mailElem.appendChild(bodyElem);
        }
        if (mail.isHtmlMail()) {
            Element htmlElem = doc.createElement("html");
            htmlElem.appendChild(doc.createCDATASection(mail.getHtmlText()));
            mailElem.appendChild(htmlElem);
        }
        doc.appendChild(mailElem);
        return doc;
    }

    public static Document createNewDocument() throws FactoryConfigurationError {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.newDocument();
            return doc;
        }
        catch (ParserConfigurationException e) {
            throw new XMLBuildException("", e);
        }
    }

    private Element convertInternetAddressIntoElement(InternetAddress address, String elemName, Document doc) {
        Element element = doc.createElement(elemName);
        element.setAttribute("email", address.getAddress());
        if (address.getPersonal() != null) {
            element.setAttribute("name", address.getPersonal());
        }
        return element;
    }

    public synchronized void saveDocument(Mail mail, File destFile) throws XMLBuildException {
        Transformer t;
        Document doc = this.buildDocument(mail);
        try {
            t = TransformerFactory.newInstance().newTransformer();
        }
        catch (Exception e) {
            throw new XMLBuildException(e.getMessage());
        }
        t.setOutputProperties(this.getOutputProperties());
        DOMSource source = new DOMSource(doc);
        StreamResult result = new StreamResult(destFile);
        try {
            t.transform(source, result);
        }
        catch (TransformerException e) {
            throw new XMLBuildException("XML\u30d5\u30a1\u30a4\u30eb\u306e\u4fdd\u5b58\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", e);
        }
    }

    private Properties getOutputProperties() {
        Properties p = new Properties();
        p.put("encoding", this.charset);
        p.put("indent", "yes");
        p.put("doctype-public", "-//OZACC//DTD MAIL//EN");
        p.put("doctype-system", "http://www.ozacc.com/library/dtd/ozacc-mail.dtd");
        return p;
    }
}

