using System;
using System.IO;
using System.Runtime.InteropServices;

namespace SQLiteCSLib.Inner
{
	/// <summary>
	/// SQLite3 f[^x[Xbp[
	/// </summary>
	public class OSQLiteDBWrap : IDisposable
	{
		/// <summary>
		/// CX^X
		/// </summary>
		protected IntPtr m_impl = IntPtr.Zero;

		/*
		*** lCeBuCX^X擾
		*/
		internal IntPtr internaldb() { return m_impl; }

		/// <summary>
		/// RXgN^
		/// </summary>
		public OSQLiteDBWrap()
		{
			m_impl = osqlite3_new();
		}

		/// <summary>
		/// fXgN^
		/// </summary>
		~OSQLiteDBWrap()
		{
			Dispose();
		}

		/// <summary>
		/// fXgN^
		/// </summary>
		public void Dispose()
		{
			if( m_impl != IntPtr.Zero )
			{
				osqlite3_delete( m_impl );
				m_impl = IntPtr.Zero;
			}

		}

		/// <summary>
		/// ڑ
		/// </summary>
		/// <param name="filename">f[^x[XڑpX</param>
		/// <returns></returns>
		public bool Open( string filename )
		{
			return osqlite3_open( m_impl, filename );
		}

		/// <summary>
		/// ؒf
		/// </summary>
		public void Close()
		{
			osqlite3_close( m_impl );
		}

		/// <summary>
		/// ŏIG[R[h
		/// </summary>
		/// <returns>G[R[h</returns>
		public ResultEnum getLastErr()
		{
			return (ResultEnum)osqlite3_getLastErr( m_impl );
		}

		/// <summary>
		/// ŏIG[bZ[W擾
		/// </summary>
		/// <returns>G[bZ[W</returns>
		public string getLastErrMsg()
		{
			return StringFromC.String( osqlite3_getLastErrMsg( m_impl ) );
		}

		/// <summary>
		/// STMTCX^X쐬
		/// </summary>
		/// <returns>STMTCX^X</returns>
		public OSQLiteStmtWrap CreateStmt()
		{
			return new OSQLiteStmtWrap( this );
		}

		/// <summary>
		/// f
		/// </summary>
		public void Interrupt()
		{
			osqlite3_interrupt( m_impl );
		}

		/// <summary>
		/// XVes
		/// </summary>
		/// <returns>XVes</returns>
		public int getChanges()
		{
			return osqlite3_changes( m_impl );
		}

		#region A}l[W`
		[DllImport("osqlite.dll",CharSet = CharSet.Unicode)]
		protected extern static IntPtr osqlite3_new();

		[DllImport("osqlite.dll",CharSet = CharSet.Unicode)]
		protected extern static void osqlite3_delete( IntPtr instance );

		[DllImport("osqlite.dll",CharSet = CharSet.Unicode)]
		protected extern static bool osqlite3_open( IntPtr instance, string filename );

		[DllImport("osqlite.dll",CharSet = CharSet.Unicode)]
		protected extern static void osqlite3_close( IntPtr instance );
		
		[DllImport("osqlite.dll",CharSet = CharSet.Unicode)]
		protected extern static int osqlite3_getLastErr( IntPtr instance );

		[DllImport("osqlite.dll",CharSet = CharSet.Unicode)]
		protected extern static IntPtr osqlite3_getLastErrMsg( IntPtr instance );

		[DllImport("osqlite.dll",CharSet = CharSet.Unicode)]
		protected extern static void osqlite3_interrupt( IntPtr instance );

		[DllImport("osqlite.dll",CharSet = CharSet.Unicode)]
		protected extern static int osqlite3_changes( IntPtr instance );

		#endregion

	}
}
