using System;
using System.ComponentModel;
using System.Collections;
using System.Data;

using SQLiteCSLib.Inner;

namespace SQLiteCSLib
{
	/// <summary>
	/// SQLiteڑ
	/// </summary>
	public class SQLiteConnection : Component, IDbConnection, IDisposable
	{
		/// <summary>
		/// f[^x[X
		/// </summary>
		protected OSQLiteDBWrap m_db = null;

		/// <summary>
		/// ڑ
		/// PɃt@C
		/// </summary>
		protected string m_connectstring = "";

		/// <summary>
		/// f[^x[XvpeB
		/// </summary>
		internal OSQLiteDBWrap OSQLiteDB
		{
			get
			{
				return m_db;
			}
		}

		/// <summary>
		/// RXgN^
		/// </summary>
		public SQLiteConnection()
		{
		}

		/// <summary>
		/// RXgN^
		/// </summary>
		/// <param name="connectstring">ڑt@C</param>
		public SQLiteConnection( string connectstring )
		{
			ConnectionString = connectstring;
		}

		/// <summary>
		/// f[^x[XύX
		/// T|[g
		/// </summary>
		/// <param name="databaseName"></param>
		public void ChangeDatabase(string databaseName)
		{
		}

		/// <summary>
		/// gUNVJn
		/// gUNV́AT|[g
		/// </summary>
		/// <param name="il"></param>
		/// <returns></returns>
		public IDbTransaction BeginTransaction(IsolationLevel il)
		{
			return BeginTransaction();
		}

		/// <summary>
		/// gUNVJn
		/// </summary>
		/// <returns></returns>
		public IDbTransaction BeginTransaction()
		{
			return new SQLiteTransaction( this );
		}

		/// <summary>
		/// ڑԃvpeB
		/// </summary>
		public ConnectionState State
		{
			get
			{
				if( m_db == null )
					return ConnectionState.Closed;

				return ConnectionState.Open;
			}
		}

		/// <summary>
		/// ڑvpeB
		/// </summary>
		public string ConnectionString
		{
			get
			{
				return m_connectstring;
			}
			set
			{
				m_connectstring = value;
			}
		}

		/// <summary>
		/// R}h쐬
		/// </summary>
		/// <returns></returns>
		public IDbCommand CreateCommand()
		{
			return new SQLiteCommand( this );
		}

		/// <summary>
		/// ڑ
		/// </summary>
		public void Open()
		{
			Close();

			m_db = new OSQLiteDBWrap();
			if( m_db.Open( m_connectstring ) == false )
			{
				m_db = null;

				throw new DataException( m_db.getLastErrMsg(), null );
			}
		}

		/// <summary>
		/// ؒf
		/// </summary>
		public void Close()
		{
			if( m_db != null )
			{
				m_db.Close();
				m_db = null;
			}
		}

		/// <summary>
		/// f[^x[XvpeB
		/// T|[g
		/// </summary>
		public string Database
		{
			get
			{
				return string.Empty;
			}
		}

		/// <summary>
		/// ڑ^CAEgvpeB
		/// T|[g
		/// </summary>
		public int ConnectionTimeout
		{
			get
			{
				return 0;
			}
		}

		/// <summary>
		/// fXgN^
		/// </summary>
		new public void Dispose()
		{
			Close();

			foreach( OSQLiteFunc userfunc in m_userfunclist )
			{
				userfunc.Dispose();
			}

			foreach( OSQLiteCollation usercoll in m_usercollationlist )
			{
				usercoll.Dispose();
			}
		}

		#region [U`֐

		/// <summary>
		/// [U`֐Xg
		/// </summary>
		protected ArrayList m_userfunclist = new ArrayList();

		/// <summary>
		/// [U`֐쐬
		/// </summary>
		/// <param name="funcname">֐</param>
		/// <param name="inArg">̐</param>
		/// <param name="iCallinterface">֐R[obNC^[tF[X</param>
		/// <returns></returns>
		public ResultEnum CreateFunction( string funcname, int inArg, ICallUserFunction iCallinterface )
		{
			OSQLiteFunc userfunc = new OSQLiteFunc( m_db, iCallinterface );
			m_userfunclist.Add( userfunc );
			return userfunc.CreateFunction( funcname, inArg );
		}

		#endregion

		#region [U`ƍ֐

		/// <summary>
		/// [U`ƍ֐Xg
		/// </summary>
		protected ArrayList m_usercollationlist = new ArrayList();

		/// <summary>
		/// [U`ƍ֐쐬
		/// </summary>
		/// <param name="funcname">֐</param>
		/// <param name="iCallinterface">֐R[obNC^[tF[X</param>
		/// <returns></returns>
		public ResultEnum CreateCollation( string funcname, ICollationFunction iCallinterface )
		{
			OSQLiteCollation usercollation = new OSQLiteCollation( m_db, iCallinterface );
			m_usercollationlist.Add( usercollation );
			return usercollation.CreateFunction( funcname );
		}

		#endregion

	}
}
