using System;
using System.IO;
using System.Data;

using SQLiteCSLib.Inner;

namespace SQLiteCSLib
{
	/// <summary>
	/// SQLitef[^[_
	/// </summary>
	public class SQLiteDataReader : IDataReader, IDisposable
	{
		/// <summary>
		/// SQLs
		/// </summary>
		protected OSQLiteStmtWrap m_stmt = null;

		/// <summary>
		/// RXgN^
		/// </summary>
		public SQLiteDataReader( OSQLiteStmtWrap stmt )
		{
			m_stmt = stmt;
		}

		/// <summary>
		/// es
		/// </summary>
		protected int m_affected = 0;

		/// <summary>
		/// esvpeB
		/// </summary>
		public int RecordsAffected
		{
			get
			{
				return m_stmt.DbWrap().getChanges();
			}
		}

		/// <summary>
		/// mFvpeB
		/// </summary>
		public bool IsClosed
		{
			get
			{
				if( m_stmt == null )
					return true;

				return false;
			}
		}

		/// <summary>
		/// ɃXebv
		/// </summary>
		/// <returns></returns>
		public bool NextResult()
		{
			if( m_stmt.Step() == ResultEnum.ROW )
				return true;

			return false;
		}

		/// <summary>
		/// 
		/// </summary>
		public void Close()
		{
			if( m_stmt != null )
			{
				m_stmt.Dispose();
				m_stmt = null;
			}
		}

		/// <summary>
		/// ɃXebv
		/// </summary>
		/// <returns></returns>
		public bool Read()
		{
			ResultEnum iRes = m_stmt.Step();
			if( iRes == ResultEnum.ROW )
				return true;

			if( iRes != ResultEnum.DONE &&
				iRes != ResultEnum.OK &&
				iRes != ResultEnum.NOTFOUND )
				throw new SQLiteException( m_stmt );

			return false;
		}

		/// <summary>
		/// q̐[vpeB
		/// </summary>
		public int Depth
		{
			get
			{
				return 0;
			}
		}

		/// <summary>
		/// f[^XL[}쐬
		/// </summary>
		/// <returns></returns>
		public DataTable GetSchemaTable()
		{
			DataTable dt = new DataTable();

			int iColCnt = -1;

			while( Read() == true )
			{
				if( iColCnt == -1 )
				{
					iColCnt = m_stmt.column_count();

					for( int iCol=0; iCol<iColCnt; iCol++ )
					{
						//J쐬
						DataColumn dc = new DataColumn();
						Type fieldtype = GetFieldType( iCol );
						if( fieldtype != null )
						{
							dc.DataType = fieldtype;
						}
						dc.Caption = m_stmt.getColumnName( iCol );
						dc.ColumnName = dc.Caption;
						dt.Columns.Add( dc );
					}
				}

				//lZbg
				object[] rowdata = new object[iColCnt];
				int iResCnt = GetValues(rowdata);
				DataRow row = dt.NewRow();
				for( int iIdx=0; iIdx<iResCnt; iIdx++ )
				{
					row[ dt.Columns[iIdx] ] = rowdata[ iIdx ] ;
				}
				dt.Rows.Add( row );
			}

			return dt;
		}

		/// <summary>
		/// j
		/// </summary>
		public void Dispose()
		{
			Close();
		}

		/// <summary>
		/// JvpeB
		/// </summary>
		public int FieldCount
		{
			get
			{
				return m_stmt.column_count();
			}
		}

		/// <summary>
		/// J擾
		/// </summary>
		/// <param name="i"></param>
		/// <returns></returns>
		public string GetName(int i)
		{
			return m_stmt.getColumnName( i );
		}

		/// <summary>
		/// Je[u擾
		/// Ɠ̃\bh
		/// </summary>
		/// <param name="i"></param>
		/// <returns></returns>
		public string GetColumnTableName( int i )
		{
			return m_stmt.getColumnTableName( i );
		}

		/// <summary>
		/// 擾
		/// </summary>
		/// <param name="i"></param>
		/// <returns></returns>
		public int GetInt32(int i)
		{
			return m_stmt.getInt( i );
		}

		/// <summary>
		/// 擾
		/// </summary>
		/// <param name="i"></param>
		/// <returns></returns>
		public short GetInt16(int i)
		{
			return (short)m_stmt.getInt( i );
		}

		/// <summary>
		/// ^U擾
		/// [T|[g
		/// </summary>
		/// <param name="i"></param>
		/// <returns></returns>
		public bool GetBoolean(int i)
		{
			short sVal = (short)m_stmt.getInt( i );

			return ( sVal == 0 ) ? false:true;
		}

		/// <summary>
		/// 擾
		/// </summary>
		/// <param name="i"></param>
		/// <returns></returns>
		public float GetFloat(int i)
		{
			return (float)m_stmt.getDouble( i );
		}

		/// <summary>
		/// 擾
		/// </summary>
		/// <param name="i"></param>
		/// <returns></returns>
		public string GetString(int i)
		{
			return m_stmt.getText( i );
		}

		/// <summary>
		/// _擾
		/// </summary>
		/// <param name="i"></param>
		/// <returns></returns>
		public double GetDouble(int i)
		{
			return m_stmt.getDouble( i );
		}

		/// <summary>
		/// 擾
		/// </summary>
		/// <param name="i"></param>
		/// <returns></returns>
		public decimal GetDecimal(int i)
		{
			return (decimal)m_stmt.getDouble( i );
		}

		/// <summary>
		/// x^擾
		/// </summary>
		/// <param name="i"></param>
		/// <returns></returns>
		public long GetInt64(int i)
		{
			return m_stmt.getInt64( i );
		}

		/// <summary>
		/// oCi擾
		/// T|[g
		/// </summary>
		/// <param name="i"></param>
		/// <param name="fieldOffset"></param>
		/// <param name="buffer"></param>
		/// <param name="bufferoffset"></param>
		/// <param name="length"></param>
		/// <returns></returns>
		public long GetBytes(int i, long fieldOffset, byte[] buffer, int bufferoffset, int length)
		{
			if( buffer == null )
			{
				return m_stmt.getSize( i );
			}

			MemoryStream blobstream = m_stmt.getBlob( i );
			blobstream.Seek( 0, SeekOrigin.Begin );

			long lLen = blobstream.Length ;
			lLen = ( lLen < (bufferoffset+length) ) ? lLen:(bufferoffset+length);

			return (long)blobstream.Read( buffer, bufferoffset, (int)lLen );
		}

		/// <summary>
		/// l擾
		/// </summary>
		/// <param name="i"></param>
		/// <returns></returns>
		public object GetValue(int i)
		{
			switch( m_stmt.getType( i ) )
			{
				case DATATYPE.INTEGER:
					return GetInt64( i );

				case DATATYPE.FLOAT:
					return GetDouble( i );

				case DATATYPE.TEXT:
					return GetString( i );

				case DATATYPE.BLOB:
				{
					long binsize = GetBytes( i, 0, null, 0, 0 );
					byte[] val = new byte[binsize];
					GetBytes( i, 0, val, 0, (int)binsize );
					return val;
				}

				case DATATYPE.DBNULL:
					return null;
			}

			return null;
		}

		/// <summary>
		/// SJ擾
		/// </summary>
		/// <param name="values">Zbgz(^z񐔕)</param>
		/// <returns>ʃZbg</returns>
		public int GetValues(object[] values)
		{
			int iResCount = 0;

			int iResultCol = m_stmt.column_count();
			for( int iValIdx=0; iValIdx<values.Length; iValIdx++ )
			{
				if( iValIdx >= iResultCol )
					break;

				values[ iValIdx ] = GetValue( iValIdx );
				iResCount++;
			}
			
			return iResCount;
		}

		/// <summary>
		/// ^擾
		/// </summary>
		/// <param name="i"></param>
		/// <returns></returns>
		public string GetDataTypeName(int i)
		{
			return GetValue( i ).GetType().Name;
		}

		/// <summary>
		/// ^擾
		/// </summary>
		/// <param name="i"></param>
		/// <returns></returns>
		public Type GetFieldType(int i)
		{
			object fieldval = GetValue( i );
			if( fieldval == null )
				return null;
			return fieldval.GetType();
		}

		/// <summary>
		/// l擾
		/// </summary>
		public object this[string name]
		{
			get
			{
				for( int iCol=0; iCol<m_stmt.column_count(); iCol++ )
				{
					if( m_stmt.getColumnName( iCol ) == name )
						return this.GetValue( iCol );
				}

				return null;
			}
		}

		/// <summary>
		/// GetValueƓ
		/// </summary>
		object System.Data.IDataRecord.this[int i]
		{
			get
			{
				return GetValue( i );
			}
		}

		/// <summary>
		/// NULL`FbN
		/// </summary>
		/// <param name="i"></param>
		/// <returns></returns>
		public bool IsDBNull(int i)
		{
			if( m_stmt.getType( i ) == DATATYPE.DBNULL )
				return true;
			return false;
		}

		/// <summary>
		/// oCgl擾
		/// T|[g
		/// </summary>
		/// <param name="i"></param>
		/// <returns></returns>
		public byte GetByte(int i)
		{
			return 0;
		}

		/// <summary>
		/// GUID擾
		/// T|[g
		/// </summary>
		/// <param name="i"></param>
		/// <returns></returns>
		public Guid GetGuid(int i)
		{
			return new Guid ();
		}

		/// <summary>
		/// t擾
		/// T|[g
		/// </summary>
		/// <param name="i"></param>
		/// <returns></returns>
		public DateTime GetDateTime(int i)
		{
			return new DateTime ();
		}

		/// <summary>
		/// Ordinal擾
		/// T|[g
		/// </summary>
		/// <param name="i"></param>
		/// <returns></returns>
		public int GetOrdinal(string name)
		{
			return 0;
		}

		/// <summary>
		/// R[h擾
		/// T|[g
		/// </summary>
		/// <param name="i"></param>
		/// <returns></returns>
		public IDataReader GetData(int i)
		{
			return null;
		}

		/// <summary>
		/// 擾
		/// T|[g
		/// </summary>
		/// <param name="i"></param>
		/// <returns></returns>
		public long GetChars(int i, long fieldoffset, char[] buffer, int bufferoffset, int length)
		{
			return 0;
		}

		/// <summary>
		/// 擾
		/// T|[g
		/// </summary>
		/// <param name="i"></param>
		/// <returns></returns>
		public char GetChar(int i)
		{
			return '\0';
		}

	}
}
