#pragma once

#include "sqlite3.h"

/*
*** SQLITE3_stmt bp[
*/
class osqlite3_stmt
{
protected:
	/*
	*** Xe[gg
	*/
	sqlite3_stmt* m_statement;

	/*
	*** f[^x[XCX^X
	*/
	osqlite3* m_db;

	/*
	*** I
	*/
	void finalize();
public:
	/*
	*** RXgN^
	*** db : f[^x[XCX^X
	*/
	osqlite3_stmt( osqlite3* );

	/*
	*** fXgN^
	*/
	~osqlite3_stmt();

	/*
	*** SQLPs
	*** sql : SQL
	*/
	bool execute( wchar_t* sql );

	/*
	*** SQLs\
	*** sql : SQL
	*/
	bool prepare( wchar_t* sql );

	/*
	*** \(prepare)s
	*** J[\s
	*/
	int step();

	/*
	*** f[^ʃJEg
	*** step̌݃JEg
	*/
	int data_count();

	/*
	*** f[^ʃJJEg
	*/
	int column_count();

	/*
	*** J^Cv擾
	*** ߒl:<sqlite3.h>Q
	*/
	int getType( int icol );

	/*
	*** ^l擾
	*/
	int getInt( int icol );

	/*
	*** ^l擾
	*/
	sqlite3_int64 getInt64( int icol );

	/*
	*** _l擾
	*/
	double getDouble( int icol );

	/*
	*** l擾
	*/
	const wchar_t* getText( int icol );

	/*
	*** BLOBl擾
	*/
	const void* getBlob( int icol, int& valsize );

	/*
	*** J擾
	*/
	const wchar_t* getColumnName( int icol );

	/*
	*** J̃e[u擾
	*/
	const wchar_t* getColumnTableName( int icol );

	/*
	*** BLOBTCY擾
	*/
	int getSize( int icol ) { return sqlite3_column_bytes( m_statement, icol ); }

	/*
	*** oChϐZbg
	*/
	bool reset();

	/*
	*** ^UoCh
	*/
	bool bindBool( int icol, bool val );

	/*
	*** oCh
	*/
	bool bindInt( int icol, int val );

	/*
	*** oCh
	*/
	bool bindInt64( int icol, sqlite3_int64 val );

	/*
	*** _oCh
	*/
	bool bindDouble( int icol, double val );

	/*
	*** oCh
	*** _ELXg
	*/
	bool bindDecimal( int icol, long double val );

	/*
	*** oCh
	*/
	bool bindText( int icol, wchar_t* val );

	/*
	*** NULLoCh
	*/
	bool bindNull( int icol );

	/*
	*** BloboCh
	*/
	bool bindBlob( int icol, void* val, int valsize );

};
