using System;
using System.IO;
using System.Runtime.InteropServices;

namespace SQLiteCSLib.Inner
{
	/// <summary>
	/// SQLite3 f[^x[XSTMTbp[
	/// </summary>
	public class OSQLiteStmtWrap : IDisposable
	{
		/// <summary>
		/// CX^X
		/// </summary>
		protected IntPtr m_impl = IntPtr.Zero;

		/// <summary>
		/// bp[CX^X
		/// </summary>
		OSQLiteDBWrap m_dbwrap;

		/// <summary>
		/// RXgN^
		/// </summary>
		public OSQLiteStmtWrap( OSQLiteDBWrap dbwrap )
		{
			m_dbwrap = dbwrap;
			m_impl = osqlite3_stmt_new( dbwrap.internaldb() );
		}

		/// <summary>
		/// fXgN^
		/// </summary>
		~OSQLiteStmtWrap()
		{
			Dispose();
		}

		/// <summary>
		/// j
		/// </summary>
		public void Dispose()
		{
			if( m_impl != IntPtr.Zero )
			{
				osqlite3_stmt_delete( m_impl );
				m_impl = IntPtr.Zero;
			}
		}

		/// <summary>
		/// bp[CX^X擾
		/// </summary>
		/// <returns>f[^x[Xbp[</returns>
		public OSQLiteDBWrap DbWrap()
		{
			return m_dbwrap;
		}

		/// <summary>
		/// SQLPs
		/// </summary>
		/// <param name="sql">SQL</param>
		/// <returns></returns>
		public bool Execute( string sql )
		{
			return osqlite3_stmt_execute( m_impl, sql );
		}

		/// <summary>
		/// SQLs\
		/// </summary>
		/// <param name="sql">SQL</param>
		/// <returns></returns>
		public bool Prepate( string sql )
		{
			return osqlite3_stmt_prepare( m_impl, sql );
		}

		/// <summary>
		/// \(prepare)s
		/// J[\s
		/// </summary>
		/// <returns>G[R[h</returns>
		public ResultEnum Step()
		{
			return (ResultEnum)osqlite3_stmt_step( m_impl );

		}

		/// <summary>
		/// f[^ʃJEg
		/// step̌݃JEg
		/// </summary>
		/// <returns>f[^ʐ</returns>
		public int data_count()
		{
			return osqlite3_stmt_data_count( m_impl );
		}

		/// <summary>
		/// f[^ʃJJEg
		/// </summary>
		/// <returns>f[^ʃJ</returns>
		public int column_count()
		{
			return osqlite3_stmt_data_count( m_impl );
		}

		/// <summary>
		/// J^Cv擾
		/// </summary>
		/// <param name="icol">Jʒu(0N_)</param>
		/// <returns>f[^^</returns>
		public DATATYPE getType( int icol )
		{
			return (DATATYPE)osqlite3_stmt_getType( m_impl, icol );
		}

		/// <summary>
		/// ^l擾
		/// </summary>
		/// <param name="icol">Jʒu(0N_)</param>
		/// <returns>l</returns>
		public int getInt( int icol )
		{
			return osqlite3_stmt_getInt( m_impl, icol );
		}

		/// <summary>
		/// ^l擾
		/// </summary>
		/// <param name="icol">Jʒu(0N_)</param>
		/// <returns>^l</returns>
		public long getInt64( int icol )
		{
#if MOBILEPC
			long lVal = 0;
			osqlite3_stmt_getInt64( m_impl, icol, ref lVal );
			return lVal;
#else
			return osqlite3_stmt_getInt64( m_impl, icol );
#endif
		}

		/// <summary>
		/// _l擾
		/// </summary>
		/// <param name="icol">Jʒu(0N_)</param>
		/// <returns>_l</returns>
		public double getDouble( int icol )
		{
#if MOBILEPC
			double dVal = 0.0;
			osqlite3_stmt_getDouble( m_impl, icol, ref dVal );
			return dVal;
#else
			return osqlite3_stmt_getDouble( m_impl, icol );
#endif
		}

		/// <summary>
		/// l擾
		/// </summary>
		/// <param name="icol">Jʒu(0N_)</param>
		/// <returns>l</returns>
		public string getText( int icol )
		{
			return StringFromC.String( osqlite3_stmt_getText( m_impl, icol ) );
		}

		/// <summary>
		/// BLOBl擾
		/// </summary>
		/// <param name="icol">Jʒu(0N_)</param>
		/// <returns>BLOBl(Xg[)</returns>
		public MemoryStream getBlob( int icol )
		{
			int iLen = 0;
			IntPtr pBin = osqlite3_stmt_getBlob( m_impl, icol, ref iLen );
			byte[] bBin = new byte[iLen];
			Marshal.Copy( pBin, bBin, 0, iLen );
			return new MemoryStream(bBin);
		}

		/// <summary>
		/// J擾
		/// </summary>
		/// <param name="icol">Jʒu(0N_)</param>
		/// <returns>J</returns>
		public string getColumnName( int icol )
		{
			return StringFromC.String( osqlite3_stmt_getColumnName( m_impl, icol ) );
		}

		/// <summary>
		/// J̃e[u擾
		/// </summary>
		/// <param name="icol">Jʒu(0N_)</param>
		/// <returns>e[u</returns>
		public string getColumnTableName( int icol )
		{
			return StringFromC.String( osqlite3_stmt_getColumnTableName( m_impl, icol ) );
		}

		/// <summary>
		/// J̎擾
		/// </summary>
		/// <param name="icol">Jʒu(0N_)</param>
		/// <returns></returns>
		public string getColumnOriginalName( int icol )
		{
			return StringFromC.String( osqlite3_stmt_getColumnOriginalName( m_impl, icol ) );
		}

		/// <summary>
		/// J錾擾
		/// </summary>
		/// <param name="icol">Jʒu(0N_)</param>
		/// <returns>錾</returns>
		public string getColumnDecltype( int icol )
		{
			return StringFromC.String( osqlite3_stmt_getColumnDecltype( m_impl, icol ) );
		}

		/// <summary>
		/// BLOBTCY擾
		/// </summary>
		/// <param name="icol">Jʒu(0N_)</param>
		/// <returns>BLOBTCY</returns>
		public int getSize( int icol )
		{
			return osqlite3_stmt_getSize( m_impl, icol );
		}

		/// <summary>
		/// oChϐZbg
		/// </summary>
		/// <returns></returns>
		public bool Reset( )
		{
			return osqlite3_stmt_reset( m_impl );
		}

		/// <summary>
		/// ^UloCh
		/// </summary>
		/// <param name="icol">Jʒu(0N_)</param>
		/// <param name="val">^U^</param>
		/// <returns></returns>
		public bool bindBool( int icol, bool val )
		{
			return osqlite3_stmt_bindBool( m_impl, icol, val );
		}

		/// <summary>
		/// oCh
		/// </summary>
		/// <param name="icol">Jʒu(0N_)</param>
		/// <param name="val">^</param>
		/// <returns></returns>
		public bool bindInt( int icol, int val )
		{
			return osqlite3_stmt_bindInt( m_impl, icol, val );
		}

		/// <summary>
		/// oCh
		/// 64rbg
		/// </summary>
		/// <param name="icol">Jʒu(0N_)</param>
		/// <param name="val">^</param>
		/// <returns></returns>
		public bool bindInt64( int icol, long val )
		{
#if MOBILEPC
			return osqlite3_stmt_bindInt64( m_impl, icol, ref val );
#else
			return osqlite3_stmt_bindInt64( m_impl, icol, val );
#endif
		}

		/// <summary>
		/// _oCh
		/// </summary>
		/// <param name="icol">Jʒu(0N_)</param>
		/// <param name="val">_^</param>
		/// <returns></returns>
		public bool bindDouble( int icol, double val )
		{
#if MOBILEPC
			return osqlite3_stmt_bindDouble( m_impl, icol, ref val );
#else
			return osqlite3_stmt_bindDouble( m_impl, icol, val );
#endif
		}

		/// <summary>
		/// oCh
		/// _Ƀ_ELXgB
		/// </summary>
		/// <param name="icol">Jʒu(0N_)</param>
		/// <param name="val">^</param>
		/// <returns></returns>
		public bool bindDecimal( int icol, decimal val )
		{
#if MOBILEPC
			return osqlite3_stmt_bindDecimal( m_impl, icol, ref val );
#else
			return osqlite3_stmt_bindDecimal( m_impl, icol, val );
#endif
		}

		/// <summary>
		/// oCh
		/// </summary>
		/// <param name="icol">Jʒu(0N_)</param>
		/// <param name="val"></param>
		/// <returns></returns>
		public bool bindText( int icol, string val )
		{
			return osqlite3_stmt_bindText( m_impl, icol, val );
		}

		/// <summary>
		/// NULLoCh
		/// </summary>
		/// <param name="icol">Jʒu(0N_)</param>
		/// <returns></returns>
		public bool bindNull( int icol )
		{
			return osqlite3_stmt_bindNull( m_impl, icol );
		}

		/// <summary>
		/// BloboCh
		/// </summary>
		/// <param name="icol">Jʒu(0N_)</param>
		/// <param name="val">BLOB(Xg[)</param>
		/// <returns></returns>
		public bool bindBlob( int icol, MemoryStream val )
		{
			// x_ERo[gĂ
			int iValLen = (int)val.Length;
			val.Seek( 0, SeekOrigin.Begin );

			byte[] bBin = new byte[iValLen];
			val.Read( bBin, 0, iValLen );

			IntPtr pBin = IntPtr.Zero;
			try
			{
				//A}l[Wm
#if MOBILEPC
				pBin = AllocHGlobal( iValLen );
#else
				pBin = Marshal.AllocHGlobal( iValLen );
#endif
				//}l[WA}l[WփRs[
				Marshal.Copy( bBin, 0, pBin, iValLen );

				return osqlite3_stmt_bindBlob( m_impl, icol, pBin, iValLen );
			}
			finally
			{
				if( pBin != IntPtr.Zero )
				{
#if MOBILEPC
					FreeHGlobal(pBin);
#else
					Marshal.FreeHGlobal(pBin);
#endif
				}
			}
		}

		#region A}l[W`
		[DllImport("osqlite.dll",CharSet = CharSet.Unicode)]
		protected extern static IntPtr osqlite3_stmt_new( IntPtr dbwrap );

		[DllImport("osqlite.dll",CharSet = CharSet.Unicode)]
		protected extern static void osqlite3_stmt_delete( IntPtr instance );

		[DllImport("osqlite.dll",CharSet = CharSet.Unicode)]
		protected extern static bool osqlite3_stmt_execute( IntPtr instance, string sql );

		[DllImport("osqlite.dll",CharSet = CharSet.Unicode)]
		protected extern static bool osqlite3_stmt_prepare( IntPtr instance, string sql );

		[DllImport("osqlite.dll",CharSet = CharSet.Unicode)]
		protected extern static int osqlite3_stmt_step( IntPtr instance );

		[DllImport("osqlite.dll",CharSet = CharSet.Unicode)]
		protected extern static int osqlite3_stmt_data_count( IntPtr instance );

		[DllImport("osqlite.dll",CharSet = CharSet.Unicode)]
		protected extern static int osqlite3_stmt_column_count( IntPtr instance );

		[DllImport("osqlite.dll",CharSet = CharSet.Unicode)]
		protected extern static int osqlite3_stmt_getType( IntPtr instance, int icol );

		[DllImport("osqlite.dll",CharSet = CharSet.Unicode)]
		protected extern static int osqlite3_stmt_getInt( IntPtr instance, int icol );
#if MOBILEPC
		[DllImport("osqlite.dll",CharSet = CharSet.Unicode)]
		protected extern static void osqlite3_stmt_getInt64( IntPtr instance, int icol, ref long lVal );

		[DllImport("osqlite.dll",CharSet = CharSet.Unicode)]
		protected extern static void osqlite3_stmt_getDouble( IntPtr instance, int icol, ref double dVal );
#else
		[DllImport("osqlite.dll",CharSet = CharSet.Unicode)]
		protected extern static long osqlite3_stmt_getInt64( IntPtr instance, int icol );

		[DllImport("osqlite.dll",CharSet = CharSet.Unicode)]
		protected extern static double osqlite3_stmt_getDouble( IntPtr instance, int icol );
#endif

		[DllImport("osqlite.dll",CharSet = CharSet.Unicode)]
		protected extern static IntPtr osqlite3_stmt_getText( IntPtr instance, int icol );

		[DllImport("osqlite.dll",CharSet = CharSet.Unicode)]
		protected extern static IntPtr osqlite3_stmt_getBlob( IntPtr instance, int icol, ref int valsize );

		[DllImport("osqlite.dll",CharSet = CharSet.Unicode)]
		protected extern static IntPtr osqlite3_stmt_getColumnName( IntPtr instance, int icol );

		[DllImport("osqlite.dll",CharSet = CharSet.Unicode)]
		protected extern static IntPtr osqlite3_stmt_getColumnTableName( IntPtr instance, int icol );

		[DllImport("osqlite.dll",CharSet = CharSet.Unicode)]
		protected extern static IntPtr osqlite3_stmt_getColumnOriginalName( IntPtr instance, int icol );

		[DllImport("osqlite.dll",CharSet = CharSet.Unicode)]
		protected extern static IntPtr osqlite3_stmt_getColumnDecltype( IntPtr instance, int icol );

		[DllImport("osqlite.dll",CharSet = CharSet.Unicode)]
		protected extern static int osqlite3_stmt_getSize( IntPtr instance, int icol );

		[DllImport("osqlite.dll",CharSet = CharSet.Unicode)]
		protected extern static bool osqlite3_stmt_reset( IntPtr instance );

		[DllImport("osqlite.dll",CharSet = CharSet.Unicode)]
		protected extern static bool osqlite3_stmt_bindBool( IntPtr instance, int icol, bool val );

		[DllImport("osqlite.dll",CharSet = CharSet.Unicode)]
		protected extern static bool osqlite3_stmt_bindInt( IntPtr instance, int icol, int val );

#if MOBILEPC
		[DllImport("osqlite.dll",CharSet = CharSet.Unicode)]
		protected extern static bool osqlite3_stmt_bindInt64( IntPtr instance, int icol, ref long val );

		[DllImport("osqlite.dll",CharSet = CharSet.Unicode)]
		protected extern static bool osqlite3_stmt_bindDouble( IntPtr instance, int icol, ref double val );

		[DllImport("osqlite.dll",CharSet = CharSet.Unicode)]
		protected extern static bool osqlite3_stmt_bindDecimal( IntPtr instance, int icol, ref decimal val );
#else
		[DllImport("osqlite.dll",CharSet = CharSet.Unicode)]
		protected extern static bool osqlite3_stmt_bindInt64( IntPtr instance, int icol, long val );

		[DllImport("osqlite.dll",CharSet = CharSet.Unicode)]
		protected extern static bool osqlite3_stmt_bindDouble( IntPtr instance, int icol, double val );

		[DllImport("osqlite.dll",CharSet = CharSet.Unicode)]
		protected extern static bool osqlite3_stmt_bindDecimal( IntPtr instance, int icol, decimal val );
#endif

		[DllImport("osqlite.dll",CharSet = CharSet.Unicode)]
		protected extern static bool osqlite3_stmt_bindText( IntPtr instance, int icol, string val );

		[DllImport("osqlite.dll",CharSet = CharSet.Unicode)]
		protected extern static bool osqlite3_stmt_bindNull( IntPtr instance, int icol );

		[DllImport("osqlite.dll",CharSet = CharSet.Unicode)]
		protected extern static bool osqlite3_stmt_bindBlob( IntPtr instance, int icol, IntPtr val, int valsize );

		[DllImport("osqlite.dll",CharSet = CharSet.Unicode)]
		protected extern static IntPtr AllocHGlobal( int isize );

		[DllImport("osqlite.dll",CharSet = CharSet.Unicode)]
		protected extern static void FreeHGlobal( IntPtr pMem );
		
		#endregion
	}
}
