using System;
using System.Collections;
using System.Runtime.InteropServices;

namespace SQLiteCSLib.Inner
{
	/// <summary>
	/// ϊ A}l[W}l[W
	/// </summary>
	public class StringFromC
	{
		/// <summary>
		/// A}l[WUTFϊ
		/// </summary>
		/// <param name="str">A}l[W|C^</param>
		/// <returns></returns>
		unsafe static public string String( void* str )
		{
			IntPtr ValPtr = new IntPtr( str );
#if MOBILEPC
			return Marshal.PtrToStringUni( ValPtr );
#else
			return Marshal.PtrToStringAuto( ValPtr );
#endif
		}

		/// <summary>
		/// A}l[WUTFϊ
		/// </summary>
		/// <param name="ValPtr">A}l[W|C^</param>
		/// <returns></returns>
		unsafe static public string String( IntPtr ValPtr )
		{
#if MOBILEPC
			return Marshal.PtrToStringUni( ValPtr );
#else
			return Marshal.PtrToStringAuto( ValPtr );
#endif
		}

		/// <summary>
		/// A}l[WANSIϊ
		/// </summary>
		/// <param name="ValPtr">A}l[W|C^</param>
		/// <returns></returns>
		unsafe static public string StringAnsi( IntPtr ValPtr )
		{
#if MOBILEPC
			ArrayList ansistr = new ArrayList();
			int iTop = ValPtr.ToInt32();

			while( true )
			{
				IntPtr pPos = new IntPtr(iTop++);
				byte bBin = Marshal.ReadByte( pPos );
				if( bBin == 0x00 )
				{
					break;
				}

				ansistr.Add( bBin );
			}

			byte[] ansibin = ansistr.ToArray( typeof(byte) ) as byte[];
			System.Text.Decoder dec = System.Text.Encoding.ASCII.GetDecoder();
			int iLen = ansibin.Length;
			char[] cChars= new char[iLen];
			dec.GetChars(ansibin,0,iLen, cChars, 0 );
			return new string(cChars);
#else
			return Marshal.PtrToStringAnsi( ValPtr );
#endif
		}

		/// <summary>
		/// A}l[WUTFϊ
		/// </summary>
		/// <param name="str">A}l[W|C^</param>
		/// <param name="isize">(oCgł͖̂Œ)</param>
		/// <returns></returns>
		unsafe static public string String( void* str, int isize )
		{
			IntPtr ValPtr = new IntPtr( str );
#if MOBILEPC
			return Marshal.PtrToStringUni( ValPtr, isize );
#else
			return Marshal.PtrToStringAuto( ValPtr, isize );
#endif
		}

		/// <summary>
		/// A}l[WUTFϊ
		/// </summary>
		/// <param name="str">A}l[W|C^</param>
		/// <param name="isize">(oCgł͖̂Œ)</param>
		/// <returns></returns>
		unsafe static public string String( IntPtr ValPtr, int isize )
		{
#if MOBILEPC
			return Marshal.PtrToStringUni( ValPtr, isize );
#else
			return Marshal.PtrToStringAuto( ValPtr, isize );
#endif
		}
	}
}
