/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.sqlite.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.logging.Logger;
import org.sqlite.Statement;
import org.sqlite.io.BlobInputStream;
import org.sqlite.swig.SWIGTYPE_p_void;

/**
 *
 * @author calico
 */
public class JdbcBlob implements Blob {
    private final Statement stmt;
    private final SWIGTYPE_p_void blob;
    private final long length;
    private boolean isClosed = false;
    
    public JdbcBlob(Statement stmt, int columnIndex) {
        this.stmt = stmt;
        this.blob = stmt.getBlob(columnIndex);
        this.length = stmt.getByteLength(columnIndex);
    }
    
    // START implements
    public long length() throws SQLException {
        return length;
    }

    public byte[] getBytes(long pos, int len) throws SQLException {
        if (pos < 1) {
            throw new SQLException("Should pos is greater than or equal to 1.");
        }
        if (len < 0) {
            throw new SQLException("Should len is greater than or equal to 0.");
        }
        if (len == 0) {
            return new byte[0];
        }
        
        if (pos + len > length) {
            len -= ((pos + len) - length - 1);
        }
        
        final byte[] b = new byte[len];
        final InputStream in = new BlobInputStream(this, blob, length);
        try {
            in.skip(pos - 1);
            in.read(b, 0, len);
            return b;

        } catch (IOException ex) {
            // BlobInputStream doesn't throw IOException
            Logger.getLogger(JdbcBlob.class.getName()).throwing(JdbcBlob.class.getName(), "getBytes(long, int)", ex);
            throw new SQLException(ex.getMessage());
        }
    }

    public InputStream getBinaryStream() throws SQLException {
        return new BlobInputStream(this, blob, length);
    }

    public long position(byte[] pattern, long start) throws SQLException {
        // TODO do implements! position(byte[], long)
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    public long position(Blob pattern, long start) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public int setBytes(long pos, byte[] bytes) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public int setBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public OutputStream setBinaryStream(long pos) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void truncate(long len) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }
    // END implements

    public void close() {
        isClosed = true;
    }
    
    public boolean isClosed() {
        return (isClosed || stmt.isClosed());
    }
}
