/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.sqlite.jdbc;

import java.sql.Blob;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Types;
import org.sqlite.Statement;
import org.sqlite.swig.SQLite3;

/**
 *
 * @author calico
 */
public class JdbcResultSetMetaData implements ResultSetMetaData {
    private final Statement stmt;

    public JdbcResultSetMetaData(Statement stmt) {
        this.stmt = stmt;
    }
    
    // TODO org.sqlite.Statement#getColumnCount()メソッド以外は step を一回以上呼び出さないと値が取れないためエラーになる！

    // START implements
    public int getColumnCount() throws SQLException {
        return stmt.getColumnCount();
    }

    public boolean isAutoIncrement(int column) throws SQLException {
        validateColumnIndexRange(column);
        
        // TODO PRIMARY KEY は自動採番される（sqlite3_table_column_metadata）
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    public boolean isCaseSensitive(int column) throws SQLException {
        validateColumnIndexRange(column);
        
        return false;
    }

    /**
     * 
     * @see org.sqlite.jdbc.JdbcDatabaseMetaData#getTypeInfo()
     * @param column
     * @return
     * @throws java.sql.SQLException
     */
    public boolean isSearchable(int column) throws SQLException {
        validateColumnIndexRange(column);
        
        return true;
    }

    public boolean isCurrency(int column) throws SQLException {
        validateColumnIndexRange(column);
        
        return false;
    }

    public int isNullable(int column) throws SQLException {
        validateColumnIndexRange(column);
        
        // TODO sqlite3_table_column_metadata を使って実装する！
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    /**
     * 
     * @see org.sqlite.jdbc.JdbcDatabaseMetaData#getTypeInfo()
     * @param column
     * @return
     * @throws java.sql.SQLException
     */
    public boolean isSigned(int column) throws SQLException {
        validateColumnIndexRange(column);
        
        switch (stmt.getColumnType(column)) {
            case SQLite3.SQLITE_INTEGER:
            case SQLite3.SQLITE_FLOAT:
                return true;
                
            case SQLite3.SQLITE_TEXT:
            case SQLite3.SQLITE_BLOB:
            case SQLite3.SQLITE_NULL:
                return false;
        }
        
        throw new SQLException("Not supported column type.");
    }

    /**
     * 
     * @see org.hsqldb.Types#getMaxDisplaySize(int)
     * @param column
     * @return
     * @throws java.sql.SQLException
     */
    public int getColumnDisplaySize(int column) throws SQLException {
        validateColumnIndexRange(column);
        
        switch (stmt.getColumnType(column)) {
            case SQLite3.SQLITE_INTEGER:
                return 11;  // precision + "-".length()
                
            case SQLite3.SQLITE_FLOAT:
                return 23;  // String.valueOf(-Double.MAX_VALUE).length()
                
            case SQLite3.SQLITE_TEXT:
            case SQLite3.SQLITE_BLOB:
                return Integer.MAX_VALUE;

            case SQLite3.SQLITE_NULL:
                return 0;
        }
        
        throw new SQLException("Not supported column type.");
    }

    public String getColumnLabel(int column) throws SQLException {
        validateColumnIndexRange(column);
        
        return stmt.getColumnLabel(column);
    }

    public String getColumnName(int column) throws SQLException {
        validateColumnIndexRange(column);
        
        return stmt.getColumnName(column);
    }

    public String getSchemaName(int column) throws SQLException {
        validateColumnIndexRange(column);
        
        return "";
    }

    /**
     * 
     * @see org.sqlite.jdbc.JdbcDatabaseMetaData#getTypeInfo()
     * @param column
     * @return
     * @throws java.sql.SQLException
     */
    public int getPrecision(int column) throws SQLException {
        validateColumnIndexRange(column);
        
        switch (stmt.getColumnType(column)) {
            case SQLite3.SQLITE_INTEGER:
                return 10;
                
            case SQLite3.SQLITE_FLOAT:
                return 16;   // 倍精度
                
            case SQLite3.SQLITE_TEXT:
            case SQLite3.SQLITE_BLOB:
            case SQLite3.SQLITE_NULL:
                return 0;
        }
        
        throw new SQLException("Not supported column type.");
    }

    public int getScale(int column) throws SQLException {
        validateColumnIndexRange(column);
        
        switch (stmt.getColumnType(column)) {
            case SQLite3.SQLITE_FLOAT:
                // TODO REAL型の小数点以下桁数を返すようにすべきか？
//                return ?;
                
            case SQLite3.SQLITE_INTEGER:
            case SQLite3.SQLITE_TEXT:
            case SQLite3.SQLITE_BLOB:
            case SQLite3.SQLITE_NULL:
                return 0;
        }
        
        throw new SQLException("Not supported column type.");
    }

    public String getTableName(int column) throws SQLException {
        validateColumnIndexRange(column);
        
        return stmt.getColumnTableName(column);
    }

    public String getCatalogName(int column) throws SQLException {
        validateColumnIndexRange(column);
        
        return "";
    }

    public int getColumnType(int column) throws SQLException {
        validateColumnIndexRange(column);
        
        switch (stmt.getColumnType(column)) {
            case SQLite3.SQLITE_INTEGER:
                return Types.INTEGER;
                
            case SQLite3.SQLITE_FLOAT:
                return Types.FLOAT;
                
            case SQLite3.SQLITE_TEXT:
                return Types.VARCHAR;
                
            case SQLite3.SQLITE_BLOB:
                return Types.BLOB;

            case SQLite3.SQLITE_NULL:
                return Types.NULL;
        }
        
        throw new SQLException("Not supported column type.");
    }

    public String getColumnTypeName(int column) throws SQLException {
        validateColumnIndexRange(column);
        
        return stmt.getColumnTypeName(column);
    }

    public boolean isReadOnly(int column) throws SQLException {
        validateColumnIndexRange(column);
        
        return true;
    }

    public boolean isWritable(int column) throws SQLException {
        validateColumnIndexRange(column);
        
        return false;
    }

    public boolean isDefinitelyWritable(int column) throws SQLException {
        validateColumnIndexRange(column);
        
        return false;
    }

    public String getColumnClassName(int column) throws SQLException {
        validateColumnIndexRange(column);
        
        switch (stmt.getColumnType(column)) {
            case SQLite3.SQLITE_INTEGER:
                return Integer.class.getName();
                
            case SQLite3.SQLITE_FLOAT:
                return Double.class.getName();
                
            case SQLite3.SQLITE_TEXT:
                return String.class.getName();
                
            case SQLite3.SQLITE_BLOB:
                return Blob.class.getName();

            case SQLite3.SQLITE_NULL:
                return Object.class.getName();
        }
        
        throw new SQLException("Not supported column type.");
    }
    // END implements

    protected void validateColumnIndexRange(int columnIndex) throws SQLException {
        if (columnIndex > getColumnCount() || columnIndex < 1) {
            throw new SQLException("Column index out of range.");
        }
    }    
}
