/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.sqlite.types;

import org.sqlite.swig.SQLite3;
import org.sqlite.swig.SWIGTYPE_p_p_sqlite3_stmt;
import org.sqlite.swig.SWIGTYPE_p_sqlite3_stmt;

/**
 *
 * @author calico
 */
public class SQLite3StmtPtrPtr extends SWIGTYPE_p_p_sqlite3_stmt {
    private boolean isDeleted = false;
    
    public SQLite3StmtPtrPtr() {
        super(getCPtr(SQLite3.new_p_p_sqlite3_stmt()), false);
    }
    
    public synchronized void delete() {
        if (!isDeleted) {
            SQLite3.delete_p_p_sqlite3_stmt(this);
            isDeleted = true;
        }
    }
    
    public SWIGTYPE_p_sqlite3_stmt getSQLite3StmtPtr() {
        if (isDeleted) {
            throw new IllegalStateException("SQLite3StmtPtrPtr is already deleted.");
        }
        return SQLite3.p_p_sqlite3_stmt_value(this);
    }

    @Override
    protected void finalize() throws Throwable {
        delete();
        super.finalize();
    }
    
    
}
