/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.sqlite;

import java.sql.Connection;
import java.sql.SQLException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import static org.junit.Assert.*;

/**
 *
 * @author calico
 */
public class DriverTest {

    public DriverTest() {
    }

    @BeforeClass
    public static void setUpClass() throws Exception {
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void getDriverName() {
        assertEquals("SQLite JDBC Driver", Driver.getDriverName());
    }
    
    @Test
    public void getDriverVersion() {
        assertEquals(
                Driver.getDriverMajorVersion()
                    + "." + Driver.getDriverMinorVersion()
                    + "." + Driver.getDriverReleaseVersion(),
                Driver.getDriverVersion()
            );        
    }
    
    @Test
    public void getDriverMajorVersion() {
        assertEquals(0, Driver.getDriverMajorVersion());
    }
    
    @Test
    public void getDriverMinorVersion() {
        assertEquals(0, Driver.getDriverMajorVersion());
    }
    
    @Test
    public void getDriverReleaseVersion() {
        assertEquals(1, Driver.getDriverReleaseVersion());
    }
    
    private static final String[] ACCEPT_URLs
            = new String[] {
                    "jdbc:sqlite:file:\\My Documents\\mydb.db",
                    "jdbc:sqlite:mem:",
                    "jdbc:sqlite:mem:SAMPLE",
                    "jdbc:sqlite:\\My Documents\\mydb.db",
                };
    
    private static final String[] DENIAL_URLs
            = new String[] {
                    "jdbc:sqlite\\My Documents\\mydb.db",
                    "sqlite:/\\My Documents\\mydb.db",
                };
    
    @Test
    public void acceptsURL() {
        Driver driver = new Driver();

        for (final String url : ACCEPT_URLs) {
            assertTrue(driver.acceptsURL(url));
        }

        for (final String url : DENIAL_URLs) {
            assertFalse(driver.acceptsURL(url));
        }
    }
    
    private static final String[] OPEN_URLs
            = new String[] {
                    "jdbc:sqlite:file:mydb.db",
                    "jdbc:sqlite:mem:",
                    "jdbc:sqlite:mem:SAMPLE",
                    "jdbc:sqlite:\\mydb.db",
                };
    
    @Test
    public void connect() throws SQLException {
        Driver driver = new Driver();
        
        Connection conn = null;
        for (final String url : OPEN_URLs) {
            conn = driver.connect(url, null);
            assertNotNull(conn);
            conn.close();
        }

        for (final String url : DENIAL_URLs) {
            conn = driver.connect(url, null);
            assertNull(conn);
        }
    }
    
    private static final String[] NOT_OPEN_URLs
            = new String[] {
                    "jdbc:sqlite:file:\\Program Files",
                };
    
    @Test(expected = java.sql.SQLException.class)
    public void connectThrowSQLException() throws SQLException {
        Driver driver = new Driver();
        
        Connection conn = null;
        for (final String url : NOT_OPEN_URLs) {
            conn = driver.connect(url, null);
            conn.close();
        }
    }
    
    @Test
    public void getMajorVersion() {
        assertEquals(Driver.getDriverMajorVersion(), new Driver().getMajorVersion());
    }
    
    @Test
    public void getMinorVersion() {
        assertEquals(Driver.getDriverMinorVersion(), new Driver().getMinorVersion());
    }
    
    @Test
    public void getPropertyInfo() {
        // TODO do unit test!
    }
    
    
}