import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.sqlite.event.BusyHandler;
import org.sqlite.jdbc.JdbcConnection;
import static org.sqlite.swig.SQLite3Constants.*;

public class BusyHandlerExample {

    @org.junit.Test
    public void example() throws ClassNotFoundException, SQLException {
        Class.forName("org.sqlite.Driver");
        final String url = "jdbc:sqlite:mem:";
        final JdbcConnection conn = (JdbcConnection) DriverManager.getConnection(url);
        try {
            // new busy handler
            final BusyHandler handler
                    = new BusyHandler() {
                            @Override
                            protected int xBusy(int count) {
                                System.out.printf("Called xBusy(%d)\n", count);
                                return (count < 10 ? -1 : 0);
                            }
                        };

            // set busy handler
            conn.setBusyHandler(handler);

            final Statement stmt = conn.createStatement();
            String sql
                    = "CREATE TEMPORARY TABLE IF NOT EXISTS temp_tbl_1("
                        + "  ID INTEGER PRIMARY KEY AUTOINCREMENT"
                        + ", VALUE TEXT"
                    + ")";
            stmt.executeUpdate(sql);

            sql = "INSERT INTO temp_tbl_1 VALUES(1, 'One')";
            stmt.executeUpdate(sql);

            sql = "SELECT * FROM temp_tbl_1";
            for (final ResultSet rs = stmt.executeQuery(sql); rs.next(); ) {
                System.out.println(rs.getString(1));
            }
            
            stmt.close();

            // clear busy handler
            conn.clearBusyHandler();

        } finally {
            conn.close();
        }
    }

    public static void main(String[] args) throws Exception {
        new BusyHandlerExample().example();
    }
}
