/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 1.3.33
 * 
 * This file is not intended to be easily readable and contains a number of 
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG 
 * interface file instead. 
 * ----------------------------------------------------------------------------- */

/* -----------------------------------------------------------------------------
 *  This section contains generic SWIG labels for method/variable
 *  declarations/attributes, and other compiler dependent labels.
 * ----------------------------------------------------------------------------- */

/* template workaround for compilers that cannot correctly implement the C++ standard */
#ifndef SWIGTEMPLATEDISAMBIGUATOR
# if defined(__SUNPRO_CC) && (__SUNPRO_CC <= 0x560)
#  define SWIGTEMPLATEDISAMBIGUATOR template
# elif defined(__HP_aCC)
/* Needed even with `aCC -AA' when `aCC -V' reports HP ANSI C++ B3910B A.03.55 */
/* If we find a maximum version that requires this, the test would be __HP_aCC <= 35500 for A.03.55 */
#  define SWIGTEMPLATEDISAMBIGUATOR template
# else
#  define SWIGTEMPLATEDISAMBIGUATOR
# endif
#endif

/* inline attribute */
#ifndef SWIGINLINE
# if defined(__cplusplus) || (defined(__GNUC__) && !defined(__STRICT_ANSI__))
#   define SWIGINLINE inline
# else
#   define SWIGINLINE
# endif
#endif

/* attribute recognised by some compilers to avoid 'unused' warnings */
#ifndef SWIGUNUSED
# if defined(__GNUC__)
#   if !(defined(__cplusplus)) || (__GNUC__ > 3 || (__GNUC__ == 3 && __GNUC_MINOR__ >= 4))
#     define SWIGUNUSED __attribute__ ((__unused__)) 
#   else
#     define SWIGUNUSED
#   endif
# elif defined(__ICC)
#   define SWIGUNUSED __attribute__ ((__unused__)) 
# else
#   define SWIGUNUSED 
# endif
#endif

#ifndef SWIGUNUSEDPARM
# ifdef __cplusplus
#   define SWIGUNUSEDPARM(p)
# else
#   define SWIGUNUSEDPARM(p) p SWIGUNUSED 
# endif
#endif

/* internal SWIG method */
#ifndef SWIGINTERN
# define SWIGINTERN static SWIGUNUSED
#endif

/* internal inline SWIG method */
#ifndef SWIGINTERNINLINE
# define SWIGINTERNINLINE SWIGINTERN SWIGINLINE
#endif

/* exporting methods */
#if (__GNUC__ >= 4) || (__GNUC__ == 3 && __GNUC_MINOR__ >= 4)
#  ifndef GCC_HASCLASSVISIBILITY
#    define GCC_HASCLASSVISIBILITY
#  endif
#endif

#ifndef SWIGEXPORT
# if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#   if defined(STATIC_LINKED)
#     define SWIGEXPORT
#   else
#     define SWIGEXPORT __declspec(dllexport)
#   endif
# else
#   if defined(__GNUC__) && defined(GCC_HASCLASSVISIBILITY)
#     define SWIGEXPORT __attribute__ ((visibility("default")))
#   else
#     define SWIGEXPORT
#   endif
# endif
#endif

/* calling conventions for Windows */
#ifndef SWIGSTDCALL
# if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#   define SWIGSTDCALL __stdcall
# else
#   define SWIGSTDCALL
# endif 
#endif

/* Deal with Microsoft's attempt at deprecating C standard runtime functions */
#if !defined(SWIG_NO_CRT_SECURE_NO_DEPRECATE) && defined(_MSC_VER) && !defined(_CRT_SECURE_NO_DEPRECATE)
# define _CRT_SECURE_NO_DEPRECATE
#endif

/* Deal with Microsoft's attempt at deprecating methods in the standard C++ library */
#if !defined(SWIG_NO_SCL_SECURE_NO_DEPRECATE) && defined(_MSC_VER) && !defined(_SCL_SECURE_NO_DEPRECATE)
# define _SCL_SECURE_NO_DEPRECATE
#endif



/* Fix for jlong on some versions of gcc on Windows */
#if defined(__GNUC__) && !defined(__INTELC__)
  typedef long long __int64;
#endif

/* Fix for jlong on 64-bit x86 Solaris */
#if defined(__x86_64)
# ifdef _LP64
#   undef _LP64
# endif
#endif

#include <jni.h>
#include <stdlib.h>
#include <string.h>


/* Support for throwing Java exceptions */
typedef enum {
  SWIG_JavaOutOfMemoryError = 1, 
  SWIG_JavaIOException, 
  SWIG_JavaRuntimeException, 
  SWIG_JavaIndexOutOfBoundsException,
  SWIG_JavaArithmeticException,
  SWIG_JavaIllegalArgumentException,
  SWIG_JavaNullPointerException,
  SWIG_JavaDirectorPureVirtual,
  SWIG_JavaUnknownError
} SWIG_JavaExceptionCodes;

typedef struct {
  SWIG_JavaExceptionCodes code;
  const char *java_exception;
} SWIG_JavaExceptions_t;


static void SWIGUNUSED SWIG_JavaThrowException(JNIEnv *jenv, SWIG_JavaExceptionCodes code, const char *msg) {
  jclass excep;
  static const SWIG_JavaExceptions_t java_exceptions[] = {
    { SWIG_JavaOutOfMemoryError, "java/lang/OutOfMemoryError" },
    { SWIG_JavaIOException, "java/io/IOException" },
    { SWIG_JavaRuntimeException, "java/lang/RuntimeException" },
    { SWIG_JavaIndexOutOfBoundsException, "java/lang/IndexOutOfBoundsException" },
    { SWIG_JavaArithmeticException, "java/lang/ArithmeticException" },
    { SWIG_JavaIllegalArgumentException, "java/lang/IllegalArgumentException" },
    { SWIG_JavaNullPointerException, "java/lang/NullPointerException" },
    { SWIG_JavaDirectorPureVirtual, "java/lang/RuntimeException" },
    { SWIG_JavaUnknownError,  "java/lang/UnknownError" },
    { (SWIG_JavaExceptionCodes)0,  "java/lang/UnknownError" } };
  const SWIG_JavaExceptions_t *except_ptr = java_exceptions;

  while (except_ptr->code != code && except_ptr->code)
    except_ptr++;

  (*jenv)->ExceptionClear(jenv);
  excep = (*jenv)->FindClass(jenv, except_ptr->java_exception);
  if (excep)
    (*jenv)->ThrowNew(jenv, excep, msg);
}


/* Contract support */

#define SWIG_contract_assert(nullreturn, expr, msg) if (!(expr)) {SWIG_JavaThrowException(jenv, SWIG_JavaIllegalArgumentException, msg); return nullreturn; } else


#include <assert.h>
#include "sqlite3.h"

#ifdef __cplusplus
extern "C" {
#endif

/* Field ID of org.sqlite.callback.Callback._this member field */
static jfieldID fid_callback_this = 0;

/* Field ID of org.sqlite.callback.NamedCallback.name member field */
static jfieldID fid_namedcallback_name = 0;

/* org.sqlite.udf.Function class */
static jclass clsFunction = 0;

/* Field ID of org.sqlite.udf.Function member fields  */
static jfieldID fid_function_argc = 0;

/* org.sqlite.udf.AggregateFunction class */
static jclass clsAggregateFunction = 0;

/* org.sqlite.text.Collator class */
static jclass clsCollator = 0;

/* org.sqlite.auth.Authorizer class */
static jclass clsAuthorizer = 0;

/* org.sqlite.event.BusyHandler class */
static jclass clsBusyHandler = 0;

/* org.sqlite.event.ProgressHandler class */
static jclass clsProgressHandler = 0;

JNIEXPORT jint JNICALL JNI_OnLoad(JavaVM *vm, void *reserved) {
    JNIEnv *jenv = NULL;
    // require JNI ver 1.2 or later
    if ((*vm)->GetEnv(vm, (void **)&jenv, JNI_VERSION_1_2) != JNI_OK) {
        return JNI_ERR;
    }
    return JNI_VERSION_1_2;
}

/* delete clsFunction and clsAggregateFunction */
JNIEXPORT void JNICALL JNI_OnUnload(JavaVM *vm, void *reserved) {
    JNIEnv *jenv = NULL;
    if ((*vm)->AttachCurrentThread(vm, (void **)&jenv, 0) == JNI_OK) {
        if (clsFunction) {
            (*jenv)->DeleteGlobalRef(jenv, clsFunction);
            clsFunction = 0;
        }
        if (clsAggregateFunction) {
            (*jenv)->DeleteGlobalRef(jenv, clsAggregateFunction);
            clsAggregateFunction = 0;
        }
        if (clsCollator) {
            (*jenv)->DeleteGlobalRef(jenv, clsCollator);
            clsCollator = 0;
        }
        if (clsAuthorizer) {
            (*jenv)->DeleteGlobalRef(jenv, clsAuthorizer);
            clsAuthorizer = 0;
        }
        if (clsBusyHandler) {
            (*jenv)->DeleteGlobalRef(jenv, clsBusyHandler);
            clsBusyHandler = 0;
        }
        if (clsProgressHandler) {
            (*jenv)->DeleteGlobalRef(jenv, clsProgressHandler);
            clsProgressHandler = 0;
        }
    }
}

/* throw new Exception */
static void JavaThrowException(JNIEnv *jenv, const char *clazz, const char *message) {
    if (jenv) {
        jclass ex;
        char *cls = (char *)clazz;
        char *msg = (char *)message;
        (*jenv)->ExceptionClear(jenv);
        do {
            ex = (*jenv)->FindClass(jenv, cls);
            if (ex) {
                (*jenv)->ThrowNew(jenv, ex, msg);
                (*jenv)->DeleteLocalRef(jenv, ex);
                return;
            }
            // exception class not found
            msg = cls;
            cls = "java/lang/ClassNotFoundException";
        } while (cls != msg);
    }
}

/* sqlite3_column_blob by byte[] */
JNIEXPORT jbyteArray JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1column_1blob_1by_1bytes(JNIEnv *jenv, jclass jcls, jlong stmt, jint col) {
    sqlite3_stmt *pStmt = *(sqlite3_stmt **)&stmt;
    jsize len;
    jbyteArray result;
    jbyte *pSrc;
    const void *blob = sqlite3_column_blob(pStmt, col);

    if (!blob) {
        return NULL;
    }

    len = sqlite3_column_bytes(pStmt, col);
    result = (*jenv)->NewByteArray(jenv, len);
    if (!result) {
        SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "Not enough memory.");
        return NULL;
    }

    pSrc = (*jenv)->GetPrimitiveArrayCritical(jenv, result, 0);
    memcpy(pSrc, blob, len);
    (*jenv)->ReleasePrimitiveArrayCritical(jenv, result, pSrc, 0);

    return result;
}

/* sqlite3_value_blob by byte[] */
JNIEXPORT jbyteArray JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1value_1blob_1by_1bytes(JNIEnv *jenv, jclass jcls, jlong value) {
    sqlite3_value *pVal = *(sqlite3_value **)&value;
    jsize len;
    jbyteArray result;
    jbyte *pSrc;
    const void *blob = sqlite3_value_blob(pVal);

    if (!blob) {
        return NULL;
    }

    len = sqlite3_value_bytes(pVal);
    result = (*jenv)->NewByteArray(jenv, len);
    if (!result) {
        SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "Not enough memory.");
        return NULL;
    }

    pSrc = (*jenv)->GetPrimitiveArrayCritical(jenv, result, 0);
    memcpy(pSrc, blob, len);
    (*jenv)->ReleasePrimitiveArrayCritical(jenv, result, pSrc, 0);

    return result;
}

/* loadl class */
static int LoadClass(JNIEnv *jenv, jclass *clazz, const char* name) {
	if (*clazz || (*clazz = (*jenv)->FindClass(jenv, name))) {
		return 1;
	}

	JavaThrowException(jenv, "java/lang/ClassNotFoundException", name);
    return 0;
}

/* load 'org.sqlite.callback.Callback' class */
static int LoadCallbackClass(JNIEnv *jenv) {
    if (fid_callback_this) {
        // alrealy loaded
        return 1;

	} else {
		jclass clsCallback = 0;
		if (LoadClass(jenv, &clsCallback, "org/sqlite/callback/Callback")) {
			fid_callback_this = (*jenv)->GetFieldID(jenv, clsCallback, "_this", "J");
			return 1;
		}
	}

    return 0;
}

/* load 'org.sqlite.callback.NamedCallback' class */
static int LoadNamedCallbackClass(JNIEnv *jenv) {
    if (fid_namedcallback_name) {
        // alrealy loaded
        return 1;

	} else {
		jclass clsNamedCallback = 0;
		if (LoadCallbackClass(jenv)
				&& LoadClass(jenv, &clsNamedCallback, "org/sqlite/callback/NamedCallback")) {
			fid_namedcallback_name = (*jenv)->GetFieldID(jenv, clsNamedCallback, "name", "Ljava/lang/String;");
			return 1;
		}
	}

    return 0;
}

/* load 'org.sqlite.udf.Function' class */
static int LoadFunctionClass(JNIEnv *jenv) {
    if (clsFunction) {
        // alrealy loaded
        return 1;
    }

	if (LoadNamedCallbackClass(jenv)
			&& LoadClass(jenv, &clsFunction, "org/sqlite/udf/Function")) {
	    clsFunction = (*jenv)->NewGlobalRef(jenv, clsFunction);
		fid_function_argc = (*jenv)->GetFieldID(jenv, clsFunction, "argc", "I");
		return 1;
	}
    
    return 0;
}

/* load 'org.sqlite.udf.AggregateFunction' class */
static int LoadAggregateFunctionClass(JNIEnv *jenv) {
    if (clsAggregateFunction) {
        // alrealy loaded
        return 1;

    } else if (LoadNamedCallbackClass(jenv)
				&& LoadClass(jenv, &clsAggregateFunction, "org/sqlite/udf/AggregateFunction")) {
	    clsAggregateFunction = (*jenv)->NewGlobalRef(jenv, clsAggregateFunction);
		return 1;
	}
    
    return 0;
}

/* load 'org.sqlite.text.Collator' class */
static int LoadCollatorClass(JNIEnv *jenv) {
    if (clsCollator) {
        // alrealy loaded
        return 1;

    } else if (LoadNamedCallbackClass(jenv)
				&& LoadClass(jenv, &clsCollator, "org/sqlite/text/Collator")) {
	    clsCollator = (*jenv)->NewGlobalRef(jenv, clsCollator);
		return 1;
	}

    return 0;
}

/* load 'org.sqlite.auth.Authorizer' class */
static int LoadAuthorizerClass(JNIEnv *jenv) {
    if (clsAuthorizer) {
        // alrealy loaded
        return 1;

    } else if (LoadCallbackClass(jenv)
				&& LoadClass(jenv, &clsAuthorizer, "org/sqlite/auth/Authorizer")) {
	    clsAuthorizer = (*jenv)->NewGlobalRef(jenv, clsAuthorizer);
		return 1;
	}

    return 0;
}

/* load 'org.sqlite.event.BusyHandler' class */
static int LoadBusyHandlerClass(JNIEnv *jenv) {
    if (clsBusyHandler) {
        // alrealy loaded
        return 1;

    } else if (LoadCallbackClass(jenv)
				&& LoadClass(jenv, &clsBusyHandler, "org/sqlite/event/BusyHandler")) {
	    clsBusyHandler = (*jenv)->NewGlobalRef(jenv, clsBusyHandler);
		return 1;
	}

    return 0;
}

/* load 'org.sqlite.event.ProgressHandler' class */
static int LoadProgressHandlerClass(JNIEnv *jenv) {
    if (clsProgressHandler) {
        // alrealy loaded
        return 1;

    } else if (LoadCallbackClass(jenv)
				&& LoadClass(jenv, &clsProgressHandler, "org/sqlite/event/ProgressHandler")) {
	    clsProgressHandler = (*jenv)->NewGlobalRef(jenv, clsProgressHandler);
		return 1;
	}

    return 0;
}

/* convert pointer to jlong */
static jlong _jlong(void *p) {
    jvalue val;
    val.l = p;
    return val.j;
}

/* convert jlong to pointer */
static void * _voidp(jlong j) {
    jvalue val;
    val.j = j;
    return (void *)val.l;
}

/* structure for user-defined function and user-defined collating sequences */
typedef struct _JAVA_OBJECT {
    JavaVM *jvm;
    jobject obj;
} JAVA_OBJECT, *PJAVA_OBJECT;

static void xFunc(sqlite3_context* ctx, int argc, sqlite3_value** value) {
    static jmethodID mid_xFunc = 0;
    JNIEnv *jenv = NULL;
    PJAVA_OBJECT jobj = (PJAVA_OBJECT)sqlite3_user_data(ctx);
    if ((*jobj->jvm)->AttachCurrentThread(jobj->jvm, (void **)&jenv, 0) != JNI_OK) {
        // AttachCurrentThread() is not supported
        JavaThrowException(jenv, "java/lang/InternalError", "AttachCurrentThread() failed");
        return;
    }

    if (!mid_xFunc) {
        mid_xFunc = (*jenv)->GetMethodID(jenv, clsFunction, "xFunc", "(JIJ)V");
    }

    (*jenv)->CallVoidMethod(jenv, jobj->obj, mid_xFunc, _jlong(ctx), argc, _jlong(value));
    (*jobj->jvm)->DetachCurrentThread(jobj->jvm);
}

static void xFinal(sqlite3_context* ctx) {
    static jmethodID mid_xFinal = 0;
    JNIEnv *jenv = NULL;
    PJAVA_OBJECT jobj = (PJAVA_OBJECT)sqlite3_user_data(ctx);
    if ((*jobj->jvm)->AttachCurrentThread(jobj->jvm, (void **)&jenv, 0) != JNI_OK) {
        // AttachCurrentThread() is not supported
        JavaThrowException(jenv, "java/lang/InternalError", "AttachCurrentThread() failed");
        return;
    }

    if (!mid_xFinal) {
        mid_xFinal = (*jenv)->GetMethodID(jenv, clsAggregateFunction, "xFinal", "(J)V");
    }

    (*jenv)->CallVoidMethod(jenv, jobj->obj, mid_xFinal, _jlong(ctx));
    (*jobj->jvm)->DetachCurrentThread(jobj->jvm);
}

/* sqlite3_create_function by org.sqlite.udf.Function */
JNIEXPORT jint JNICALL Java_org_sqlite_swig_SQLite3JNI_create_1function(JNIEnv *jenv, jclass jcls, jlong db, jobject func) {
    PJAVA_OBJECT jobj = NULL;
    jstring jname = NULL;
    char *name = NULL;
    jint argc = 0;
    int isAgFunc = 0;
    jint jresult = SQLITE_ERROR;
    int result;

    if (!clsFunction) {
        if (!LoadFunctionClass(jenv)) {
            // not found 'org.sqlite.udf.Function' class
            return jresult;
        }
        assert(clsFunction);
    }

    // validate instance
    if (!(*jenv)->IsInstanceOf(jenv, func, clsFunction)) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIllegalArgumentException, "function is not instanceof 'org.sqlite.udf.Function'.");
        return jresult;
    }

    // get org.sqlite.udf.Function._this value
    if ((*jenv)->GetLongField(jenv, func, fid_callback_this)) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIllegalArgumentException, "function is already registered.");
        return jresult;
    }

    // get org.sqlite.udf.Function.name value
    jname = (jstring)(*jenv)->GetObjectField(jenv, func, fid_namedcallback_name);
    if (jname) {
        name = (char *)(*jenv)->GetStringUTFChars(jenv, jname, 0);
        if (!name) {
            SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException, "Failed JNIEnv#GetStringUTFChars().");
            return jresult;
        }
    } else {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "name is null.");
        return jresult;
    }

    // get org.sqlite.udf.Function.argc value
    argc = (*jenv)->GetIntField(jenv, func, fid_function_argc);

    // allocate user data
    jobj = (PJAVA_OBJECT)calloc(1, sizeof(JAVA_OBJECT));
    if (!jobj) {
        SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "Not enough memory.");
        return jresult;
    }
    jobj->obj = (*jenv)->NewGlobalRef(jenv, func);
    (*jenv)->GetJavaVM(jenv, &jobj->jvm);
    
    if (!clsAggregateFunction) {
        if (!LoadAggregateFunctionClass(jenv)) {
            // not found 'org.sqlite.udf.AggregateFunction' class
            return jresult;
        }
        assert(clsAggregateFunction);
    }
    
    // func insetanceof org.sqlite.udf.AggregateFunction
    isAgFunc = (*jenv)->IsInstanceOf(jenv, func, clsAggregateFunction);
    
    // register function
    result = sqlite3_create_function(*(sqlite3 **)&db, name, (int)argc, SQLITE_UTF8, jobj, (isAgFunc ? NULL : &xFunc), (isAgFunc ? &xFunc : NULL), (isAgFunc ? &xFinal : NULL));
    if (result == SQLITE_OK) {
        // set org.sqlite.udf.Function.pUserData value
        (*jenv)->SetLongField(jenv, func, fid_callback_this, _jlong(jobj));

    } else {
        // clean up user data
        (*jenv)->DeleteGlobalRef(jenv, jobj->obj);
        free(jobj);
    }

    if (name) {
        (*jenv)->ReleaseStringUTFChars(jenv, jname, (const char *)name);
    }

    jresult = (jint)result;
    return jresult;
}

/* sqlite3_create_function by org.sqlite.udf.Function */
JNIEXPORT jint JNICALL Java_org_sqlite_swig_SQLite3JNI_drop_1function(JNIEnv *jenv, jclass jcls, jlong db, jobject func) {
    jlong _this;
    jstring jname = NULL;
    char *name = NULL;
    jint jresult = SQLITE_ERROR;
    int result;

    if (!clsFunction) {
        if (!LoadFunctionClass(jenv)) {
            // not found 'org.sqlite.udf.Function' class
            return jresult;
        }
        assert(clsFunction);
    }

    // validate instance
    if (!(*jenv)->IsInstanceOf(jenv, func, clsFunction)) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIllegalArgumentException, "function is not instanceof 'org.sqlite.udf.Function'.");
        return jresult;
    }

    // get org.sqlite.udf.Function._this value
    _this = (*jenv)->GetLongField(jenv, func, fid_callback_this);
    if (!_this) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIllegalArgumentException, "function is not registered.");
        return jresult;
    }

    // get org.sqlite.udf.Function.name value
    jname = (jstring)(*jenv)->GetObjectField(jenv, func, fid_namedcallback_name);
    if (jname) {
        name = (char *)(*jenv)->GetStringUTFChars(jenv, jname, 0);
        if (!name) {
            SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException, "Failed JNIEnv#GetStringUTFChars().");
            return jresult;
        }
    } else {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "name is null.");
        return jresult;
    }

    // unregister function
    result = sqlite3_create_function(*(sqlite3 **)&db, name, -1, SQLITE_UTF8, NULL, NULL, NULL, NULL);
    if (result == SQLITE_OK) {
        // clean up user data
        PJAVA_OBJECT jobj = _voidp(_this);
        (*jenv)->DeleteGlobalRef(jenv, jobj->obj);
        free(jobj);
        (*jenv)->SetLongField(jenv, func, fid_callback_this, 0);
    }

    if (name) {
        (*jenv)->ReleaseStringUTFChars(jenv, jname, (const char *)name);
    }

    jresult = (jint)result;
    return jresult;
}

static int xCompare(void *p, int len1, const void *str1, int len2, const void *str2) {
    static jmethodID mid_xCompare = 0;
    PJAVA_OBJECT jobj = (PJAVA_OBJECT)p;
    JNIEnv *jenv = NULL;
    jstring jstr1 = NULL;
    jstring jstr2 = NULL;
    jint jresult = 0;
    
    if ((*jobj->jvm)->AttachCurrentThread(jobj->jvm, (void **)&jenv, 0) != JNI_OK) {
        // AttachCurrentThread() is not supported
        JavaThrowException(jenv, "java/lang/InternalError", "AttachCurrentThread() failed");
        return jresult;
    }

    if (!mid_xCompare) {
        mid_xCompare = (*jenv)->GetMethodID(jenv, clsCollator, "xCompare", "(Ljava/lang/String;Ljava/lang/String;)I");
    }

    if (str1) {
        if (strlen((const char *)str1) == len1) {
            jstr1 = (*jenv)->NewStringUTF(jenv, (const char *)str1);        
        } else {
            char *str = (char *)calloc(len1 + 1, sizeof(char));
            strncpy(str, str1, len1);
            str[len1] = '\0';
            jstr1 = (*jenv)->NewStringUTF(jenv, (const char *)str);
            free(str);
        }
    }

    if (str2) {
        if (strlen((const char *)str2) == len2) {
            jstr2 = (*jenv)->NewStringUTF(jenv, (const char *)str2);        
        } else {
            char *str = (char *)calloc(len2 + 1, sizeof(char));
            strncpy(str, str2, len2);
            str[len2] = '\0';
            jstr2 = (*jenv)->NewStringUTF(jenv, (const char *)str);
            free(str);
        }
    }
    
    jresult = (*jenv)->CallIntMethod(jenv, jobj->obj, mid_xCompare, jstr1, jstr2);
    
    (*jobj->jvm)->DetachCurrentThread(jobj->jvm);
    
    return jresult;
}

/* sqlite3_create_collation by org.sqlite.text.Collator */
JNIEXPORT jint JNICALL Java_org_sqlite_swig_SQLite3JNI_create_1collation(JNIEnv *jenv, jclass jcls, jlong db, jobject col) {
    PJAVA_OBJECT jobj = NULL;
    jstring jname = NULL;
    char *name = NULL;
    jint jresult = SQLITE_ERROR;
    int result;

    if (!clsCollator) {
        if (!LoadCollatorClass(jenv)) {
            // not found 'org.sqlite.text.Collator' class
            return jresult;
        }
        assert(clsCollator);
    }

    // validate instance
    if (!(*jenv)->IsInstanceOf(jenv, col, clsCollator)) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIllegalArgumentException, "collator is not instanceof 'org.sqlite.text.Collator'.");
        return jresult;
    }

    // get org.sqlite.text.Collator._this value
    if ((*jenv)->GetLongField(jenv, col, fid_callback_this)) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIllegalArgumentException, "collation is already registered.");
        return jresult;
    }

    // get org.sqlite.text.Collator.name value
    jname = (jstring)(*jenv)->GetObjectField(jenv, col, fid_namedcallback_name);
    if (jname) {
        name = (char *)(*jenv)->GetStringUTFChars(jenv, jname, 0);
        if (!name) {
            SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException, "Failed JNIEnv#GetStringUTFChars().");
            return jresult;
        }
    } else {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "name is null.");
        return jresult;
    }

    // allocate user data
    jobj = (PJAVA_OBJECT)calloc(1, sizeof(JAVA_OBJECT));
    if (!jobj) {
        SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "Not enough memory.");
        return jresult;
    }
    jobj->obj = (*jenv)->NewGlobalRef(jenv, col);
    (*jenv)->GetJavaVM(jenv, &jobj->jvm);
    
    // register collation
    result = sqlite3_create_collation(*(sqlite3 **)&db, name, SQLITE_UTF8, jobj, &xCompare);
    if (result == SQLITE_OK) {
        // set org.sqlite.text.Collator._this value
        (*jenv)->SetLongField(jenv, col, fid_callback_this, _jlong(jobj));

    } else {
        // clean up user data
        (*jenv)->DeleteGlobalRef(jenv, jobj->obj);
        free(jobj);
    }

    if (name) {
        (*jenv)->ReleaseStringUTFChars(jenv, jname, (const char *)name);
    }

    jresult = (jint)result;
    return jresult;
}

/* sqlite3_create_collation by org.sqlite.text.Collator */
JNIEXPORT jint JNICALL Java_org_sqlite_swig_SQLite3JNI_drop_1collation(JNIEnv *jenv, jclass jcls, jlong db, jobject col) {
    jlong _this;
    jstring jname = NULL;
    char *name = NULL;
    jint jresult = SQLITE_ERROR;
    int result;

    if (!clsCollator) {
        if (!LoadCollatorClass(jenv)) {
            // not found 'org.sqlite.text.Collator' class
            return jresult;
        }
        assert(clsCollator);
    }

    // validate instance
    if (!(*jenv)->IsInstanceOf(jenv, col, clsCollator)) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIllegalArgumentException, "collator is not instanceof 'org.sqlite.text.Collator'.");
        return jresult;
    }

    // get org.sqlite.text.Collator._this value
    _this = (*jenv)->GetLongField(jenv, col, fid_callback_this);
    if (!_this) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIllegalArgumentException, "collation is not registered.");
        return jresult;
    }

    // get org.sqlite.text.Collator.name value
    jname = (jstring)(*jenv)->GetObjectField(jenv, col, fid_namedcallback_name);
    if (jname) {
        name = (char *)(*jenv)->GetStringUTFChars(jenv, jname, 0);
        if (!name) {
            SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException, "Failed JNIEnv#GetStringUTFChars().");
            return jresult;
        }
    } else {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "name is null.");
        return jresult;
    }

    // unregister collation
    result = sqlite3_create_collation(*(sqlite3 **)&db, name, SQLITE_UTF8, NULL, NULL);
    if (result == SQLITE_OK) {
        // clean up user data
        PJAVA_OBJECT jobj = _voidp(_this);
        (*jenv)->DeleteGlobalRef(jenv, jobj->obj);
        free(jobj);
        (*jenv)->SetLongField(jenv, col, fid_callback_this, 0);
    }

    if (name) {
        (*jenv)->ReleaseStringUTFChars(jenv, jname, (const char *)name);
    }

    jresult = (jint)result;
    return jresult;
}

static int xAuth(void *p, int action, const char *param3, const char *param4, const char* database, const char* triggerOrView) {
    static jmethodID mid_xAuth = 0;
    PJAVA_OBJECT jobj = (PJAVA_OBJECT)p;
    JNIEnv *jenv = NULL;
    jint jaction = (jint)action;
    jstring jstr1 = NULL;
    jstring jstr2 = NULL;
    jstring jstr3 = NULL;
    jstring jstr4 = NULL;    
    jint jresult = SQLITE_DENY;
    
    if ((*jobj->jvm)->AttachCurrentThread(jobj->jvm, (void **)&jenv, 0) != JNI_OK) {
        // AttachCurrentThread() is not supported
        JavaThrowException(jenv, "java/lang/InternalError", "AttachCurrentThread() failed");
        return jresult;
    }

    if (!mid_xAuth) {
        mid_xAuth = (*jenv)->GetMethodID(jenv, clsAuthorizer, "xAuth", "(ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)I");
    }

    if (param3) {
        jstr1 = (*jenv)->NewStringUTF(jenv, param3);        
    }
    if (param4) {
        jstr2 = (*jenv)->NewStringUTF(jenv, param4);        
    }
    if (database) {
        jstr3 = (*jenv)->NewStringUTF(jenv, database);        
    }
    if (triggerOrView) {
        jstr4 = (*jenv)->NewStringUTF(jenv, triggerOrView);        
    }
    
    jresult = (*jenv)->CallIntMethod(jenv, jobj->obj, mid_xAuth, jaction, jstr1, jstr2, jstr3, jstr4);
    
    (*jobj->jvm)->DetachCurrentThread(jobj->jvm);
    
    return jresult;
}

/* sqlite3_set_authorizer by org.sqlite.auth.Authorizer */
JNIEXPORT jint JNICALL Java_org_sqlite_swig_SQLite3JNI_set_1authorizer(JNIEnv *jenv, jclass jcls, jlong db, jobject auth) {
    PJAVA_OBJECT jobj = NULL;
    jint jresult = SQLITE_ERROR;
    int result;

    if (!clsAuthorizer) {
        if (!LoadAuthorizerClass(jenv)) {
            // not found 'org.sqlite.auth.Authorizer' class
            return jresult;
        }
        assert(clsAuthorizer);
    }

    // validate instance
    if (!(*jenv)->IsInstanceOf(jenv, auth, clsAuthorizer)) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIllegalArgumentException, "authorizer is not instanceof 'org.sqlite.auth.Authorizer'.");
        return jresult;
    }

    // get org.sqlite.auth.Authorizer._this value
    if ((*jenv)->GetLongField(jenv, auth, fid_callback_this)) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIllegalArgumentException, "authorizer has already been set.");
        return jresult;
    }

    // allocate user data
    jobj = (PJAVA_OBJECT)calloc(1, sizeof(JAVA_OBJECT));
    if (!jobj) {
        SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "Not enough memory.");
        return jresult;
    }
    jobj->obj = (*jenv)->NewGlobalRef(jenv, auth);
    (*jenv)->GetJavaVM(jenv, &jobj->jvm);
    
    // set authorizer
    result = sqlite3_set_authorizer(*(sqlite3 **)&db, &xAuth, jobj);
    if (result == SQLITE_OK) {
        // set org.sqlite.auth.Authorizer._this value
        (*jenv)->SetLongField(jenv, auth, fid_callback_this, _jlong(jobj));

    } else {
        // clean up user data
        (*jenv)->DeleteGlobalRef(jenv, jobj->obj);
        free(jobj);
    }

    jresult = (jint)result;
    return jresult;
}

/* sqlite3_set_authorizer by org.sqlite.auth.Authorizer */
JNIEXPORT jint JNICALL Java_org_sqlite_swig_SQLite3JNI_clear_1authorizer(JNIEnv *jenv, jclass jcls, jlong db, jobject auth) {
    jlong _this = 0;
    jint jresult = SQLITE_ERROR;
    int result;

    if (!clsAuthorizer) {
        if (!LoadAuthorizerClass(jenv)) {
            // not found 'org.sqlite.auth.Authorizer' class
            return jresult;
        }
        assert(clsAuthorizer);
    }

    // validate instance
    if (!(*jenv)->IsInstanceOf(jenv, auth, clsAuthorizer)) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIllegalArgumentException, "authorizer is not instanceof 'org.sqlite.auth.Authorizer'.");
        return jresult;
    }

    // get org.sqlite.auth.Authorizer._this value
    _this = (*jenv)->GetLongField(jenv, auth, fid_callback_this);
    if (!_this) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIllegalArgumentException, "authorizer is not set.");
        return jresult;
    }

    // clear authorizer
    result = sqlite3_set_authorizer(*(sqlite3 **)&db, NULL, NULL);
    if (result == SQLITE_OK) {
        // clean up user data
        PJAVA_OBJECT jobj = _voidp(_this);
        (*jenv)->DeleteGlobalRef(jenv, jobj->obj);
        free(jobj);
        (*jenv)->SetLongField(jenv, auth, fid_callback_this, 0);
    }

    jresult = (jint)result;
    return jresult;
}

static int xBusy(void *p, int count) {
    static jmethodID mid_xBusy = 0;
    PJAVA_OBJECT jobj = (PJAVA_OBJECT)p;
    JNIEnv *jenv = NULL;
    jint jresult = 0;
    
    if ((*jobj->jvm)->AttachCurrentThread(jobj->jvm, (void **)&jenv, 0) != JNI_OK) {
        // AttachCurrentThread() is not supported
        JavaThrowException(jenv, "java/lang/InternalError", "AttachCurrentThread() failed");
        return jresult;
    }

    if (!mid_xBusy) {
        mid_xBusy = (*jenv)->GetMethodID(jenv, clsBusyHandler, "xBusy", "(I)I");
    }

    jresult = (*jenv)->CallIntMethod(jenv, jobj->obj, mid_xBusy, (jint)count);
    
    (*jobj->jvm)->DetachCurrentThread(jobj->jvm);
    
    return jresult;
}

/* sqlite3_busy_handler by org.sqlite.event.BusyHandler */
JNIEXPORT jint JNICALL Java_org_sqlite_swig_SQLite3JNI_set_1busy_1handler(JNIEnv *jenv, jclass jcls, jlong db, jobject busy) {
    PJAVA_OBJECT jobj = NULL;
    jint jresult = SQLITE_ERROR;
    int result;

    if (!clsBusyHandler) {
        if (!LoadBusyHandlerClass(jenv)) {
            // not found 'org.sqlite.event.BusyHandler' class
            return jresult;
        }
        assert(clsBusyHandler);
    }

    // validate instance
    if (!(*jenv)->IsInstanceOf(jenv, busy, clsBusyHandler)) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIllegalArgumentException, "busy handler is not instanceof 'org.sqlite.event.BusyHandler'.");
        return jresult;
    }

    // get org.sqlite.event.BusyHandler._this value
    if ((*jenv)->GetLongField(jenv, busy, fid_callback_this)) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIllegalArgumentException, "busy handler has already been set.");
        return jresult;
    }

    // allocate user data
    jobj = (PJAVA_OBJECT)calloc(1, sizeof(JAVA_OBJECT));
    if (!jobj) {
        SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "Not enough memory.");
        return jresult;
    }
    jobj->obj = (*jenv)->NewGlobalRef(jenv, busy);
    (*jenv)->GetJavaVM(jenv, &jobj->jvm);
    
    // set busy handler
    result = sqlite3_busy_handler(*(sqlite3 **)&db, &xBusy, jobj);
    if (result == SQLITE_OK) {
        // set org.sqlite.event.BusyHandler._this value
        (*jenv)->SetLongField(jenv, busy, fid_callback_this, _jlong(jobj));

    } else {
        // clean up user data
        (*jenv)->DeleteGlobalRef(jenv, jobj->obj);
        free(jobj);
    }

    jresult = (jint)result;
    return jresult;
}

/* sqlite3_busy_handler by org.sqlite.event.BusyHandler */
JNIEXPORT jint JNICALL Java_org_sqlite_swig_SQLite3JNI_clear_1busy_1handler(JNIEnv *jenv, jclass jcls, jlong db, jobject busy) {
    jlong _this = 0;
    jint jresult = SQLITE_ERROR;
    int result;

    if (!clsBusyHandler) {
        if (!LoadBusyHandlerClass(jenv)) {
            // not found 'org.sqlite.event.BusyHandler' class
            return jresult;
        }
        assert(clsBusyHandler);
    }

    // validate instance
    if (!(*jenv)->IsInstanceOf(jenv, busy, clsBusyHandler)) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIllegalArgumentException, "busy handler is not instanceof 'org.sqlite.event.BusyHandler'.");
        return jresult;
    }

    // get org.sqlite.event.BusyHandler._this value
    _this = (*jenv)->GetLongField(jenv, busy, fid_callback_this);
    if (!_this) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIllegalArgumentException, "busy handler is not set.");
        return jresult;
    }

    // clear busy handler
    result = sqlite3_busy_handler(*(sqlite3 **)&db, NULL, NULL);
    if (result == SQLITE_OK) {
        // clean up user data
        PJAVA_OBJECT jobj = _voidp(_this);
        (*jenv)->DeleteGlobalRef(jenv, jobj->obj);
        free(jobj);
        (*jenv)->SetLongField(jenv, busy, fid_callback_this, 0);
    }

    jresult = (jint)result;
    return jresult;
}

static int xProgress(void *p) {
    static jmethodID mid_xProgress = 0;
    PJAVA_OBJECT jobj = (PJAVA_OBJECT)p;
    JNIEnv *jenv = NULL;
    jint jresult = 0;
    
    if ((*jobj->jvm)->AttachCurrentThread(jobj->jvm, (void **)&jenv, 0) != JNI_OK) {
        // AttachCurrentThread() is not supported
        JavaThrowException(jenv, "java/lang/InternalError", "AttachCurrentThread() failed");
        return jresult;
    }

    if (!mid_xProgress) {
        mid_xProgress = (*jenv)->GetMethodID(jenv, clsProgressHandler, "xProgress", "()I");
    }

    jresult = (*jenv)->CallIntMethod(jenv, jobj->obj, mid_xProgress);
    
    (*jobj->jvm)->DetachCurrentThread(jobj->jvm);
    
    return jresult;
}

/* sqlite3_progress_handler by org.sqlite.event.ProgressHandler */
JNIEXPORT void JNICALL Java_org_sqlite_swig_SQLite3JNI_set_1progress_1handler(JNIEnv *jenv, jclass jcls, jlong db, jobject prog) {
    static jfieldID fid_progresshandler_opecodes = 0;
    jint opecodes = 0;
    PJAVA_OBJECT jobj = NULL;

    if (!clsProgressHandler) {
        if (!LoadProgressHandlerClass(jenv)) {
            // not found 'org.sqlite.event.ProgressHandler' class
            return;
        }
        assert(clsProgressHandler);

		fid_progresshandler_opecodes = (*jenv)->GetFieldID(jenv, clsProgressHandler, "opecodes", "I");
    }

    // validate instance
    if (!(*jenv)->IsInstanceOf(jenv, prog, clsProgressHandler)) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIllegalArgumentException, "progress handler is not instanceof 'org.sqlite.event.ProgressHandler'.");
        return;
    }

    // get org.sqlite.event.ProgressHandler._this value
    if ((*jenv)->GetLongField(jenv, prog, fid_callback_this)) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIllegalArgumentException, "progress handler has already been set.");
        return;
    }

    // get org.sqlite.event.ProgressHandler.opecodes value
    opecodes = (*jenv)->GetIntField(jenv, prog, fid_progresshandler_opecodes);
    
    // allocate user data
    jobj = (PJAVA_OBJECT)calloc(1, sizeof(JAVA_OBJECT));
    if (!jobj) {
        SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "Not enough memory.");
        return;
    }
    jobj->obj = (*jenv)->NewGlobalRef(jenv, prog);
    (*jenv)->GetJavaVM(jenv, &jobj->jvm);
    
    // set progress handler
    sqlite3_progress_handler(*(sqlite3 **)&db, (int)opecodes, &xProgress, jobj);

    // set org.sqlite.event.ProgressHandler._this value
    (*jenv)->SetLongField(jenv, prog, fid_callback_this, _jlong(jobj));
}

/* sqlite3_progress_handler by org.sqlite.event.ProgressHandler */
JNIEXPORT void JNICALL Java_org_sqlite_swig_SQLite3JNI_clear_1progress_1handler(JNIEnv *jenv, jclass jcls, jlong db, jobject prog) {
    jlong _this = 0;
    PJAVA_OBJECT jobj = NULL;

    if (!clsProgressHandler) {
        if (!LoadProgressHandlerClass(jenv)) {
            // not found 'org.sqlite.event.ProgressHandler' class
            return;
        }
        assert(clsProgressHandler);
    }

    // validate instance
    if (!(*jenv)->IsInstanceOf(jenv, prog, clsProgressHandler)) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIllegalArgumentException, "progress handler is not instanceof 'org.sqlite.event.ProgressHandler'.");
        return;
    }

    // get org.sqlite.event.ProgressHandler._this value
    _this = (*jenv)->GetLongField(jenv, prog, fid_callback_this);
    if (!_this) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIllegalArgumentException, "progress handler is not set.");
        return;
    }

    // clear progress handler
    sqlite3_progress_handler(*(sqlite3 **)&db, 0, NULL, NULL);
    
    // clean up user data
    jobj = _voidp(_this);
    (*jenv)->DeleteGlobalRef(jenv, jobj->obj);
    free(jobj);
    (*jenv)->SetLongField(jenv, prog, fid_callback_this, 0);
}


#ifdef __cplusplus
}
#endif


static sqlite3* *new_p_p_sqlite3() { 
  return (sqlite3* *) calloc(1,sizeof(sqlite3*)); 
}

static sqlite3* *copy_p_p_sqlite3(sqlite3* value) { 
  sqlite3* *self = (sqlite3* *) calloc(1,sizeof(sqlite3*));
  *self = value;
  return self; 
}

static void delete_p_p_sqlite3(sqlite3* *self) { 
  if (self) free(self); 
}

static void p_p_sqlite3_assign(sqlite3* *self, sqlite3* value) {
  *self = value;
}

static sqlite3* p_p_sqlite3_value(sqlite3* *self) {
  return *self;
}


static sqlite3_stmt* *new_p_p_sqlite3_stmt() { 
  return (sqlite3_stmt* *) calloc(1,sizeof(sqlite3_stmt*)); 
}

static sqlite3_stmt* *copy_p_p_sqlite3_stmt(sqlite3_stmt* value) { 
  sqlite3_stmt* *self = (sqlite3_stmt* *) calloc(1,sizeof(sqlite3_stmt*));
  *self = value;
  return self; 
}

static void delete_p_p_sqlite3_stmt(sqlite3_stmt* *self) { 
  if (self) free(self); 
}

static void p_p_sqlite3_stmt_assign(sqlite3_stmt* *self, sqlite3_stmt* value) {
  *self = value;
}

static sqlite3_stmt* p_p_sqlite3_stmt_value(sqlite3_stmt* *self) {
  return *self;
}


static char const* *new_p_p_char() { 
  return (char const* *) calloc(1,sizeof(char const*)); 
}

static char const* *copy_p_p_char(char const* value) { 
  char const* *self = (char const* *) calloc(1,sizeof(char const*));
  *self = value;
  return self; 
}

static void delete_p_p_char(char const* *self) { 
  if (self) free(self); 
}

static void p_p_char_assign(char const* *self, char const* value) {
  *self = value;
}

static char const* p_p_char_value(char const* *self) {
  return *self;
}


static int *new_p_int() { 
  return (int *) calloc(1,sizeof(int)); 
}

static int *copy_p_int(int value) { 
  int *self = (int *) calloc(1,sizeof(int));
  *self = value;
  return self; 
}

static void delete_p_int(int *self) { 
  if (self) free(self); 
}

static void p_int_assign(int *self, int value) {
  *self = value;
}

static int p_int_value(int *self) {
  return *self;
}


/* sqlite3_bind_blob by byte[] */
static int sqlite3_bind_blob_by_bytes(sqlite3_stmt *pStmt, int parameterIndex, char *BYTE, int length, void (*xDel)(void*)) {
    return sqlite3_bind_blob(pStmt, parameterIndex, BYTE, length, xDel);
}

/* sqlite3_column_blob by java.sql.Blob */
static void read_blob(const void *blob, long long pos, char *BYTE, int offset, int len) {
    memcpy(&BYTE[offset], &((const char *)blob)[pos], len);
}

/* get (sqlite3_value*)sqlite3_value**[i] */
static sqlite3_value* get_p_sqlite3_value(sqlite3_value** value, int i) {
    return value[i];
}

/* sqlite3_result_blob by byte[] */
static void sqlite3_result_blob_by_bytes(sqlite3_context *pCtx, char *BYTE, int length, void (*xDel)(void*)) {
    sqlite3_result_blob(pCtx, BYTE, length, xDel);
}



#ifdef __cplusplus
extern "C" {
#endif

SWIGEXPORT jstring JNICALL Java_org_sqlite_swig_SQLite3JNI_SQLITE_1VERSION_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *) "3.3.5";
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, (const char *)result);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sqlite_swig_SQLite3JNI_SQLITE_1VERSION_1NUMBER_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int) 3003005;
  
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1version_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)sqlite3_version;
  if(result) jresult = (*jenv)->NewStringUTF(jenv, (const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1libversion(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)sqlite3_libversion();
  if(result) jresult = (*jenv)->NewStringUTF(jenv, (const char *)result);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1libversion_1number(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)sqlite3_libversion_number();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1close(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  sqlite3 *arg1 = (sqlite3 *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(sqlite3 **)&jarg1; 
  result = (int)sqlite3_close(arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1exec(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jlong jarg3, jlong jarg4, jlong jarg5) {
  jint jresult = 0 ;
  sqlite3 *arg1 = (sqlite3 *) 0 ;
  char *arg2 = (char *) 0 ;
  sqlite3_callback arg3 = (sqlite3_callback) 0 ;
  void *arg4 = (void *) 0 ;
  char **arg5 = (char **) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(sqlite3 **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = *(sqlite3_callback *)&jarg3; 
  arg4 = *(void **)&jarg4; 
  arg5 = *(char ***)&jarg5; 
  result = (int)sqlite3_exec(arg1,(char const *)arg2,arg3,arg4,arg5);
  jresult = (jint)result; 
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1last_1insert_1rowid(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  sqlite3 *arg1 = (sqlite3 *) 0 ;
  sqlite_int64 result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(sqlite3 **)&jarg1; 
  result = (sqlite_int64)sqlite3_last_insert_rowid(arg1);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1changes(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  sqlite3 *arg1 = (sqlite3 *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(sqlite3 **)&jarg1; 
  result = (int)sqlite3_changes(arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1total_1changes(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  sqlite3 *arg1 = (sqlite3 *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(sqlite3 **)&jarg1; 
  result = (int)sqlite3_total_changes(arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1interrupt(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  sqlite3 *arg1 = (sqlite3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(sqlite3 **)&jarg1; 
  sqlite3_interrupt(arg1);
}


SWIGEXPORT jint JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1complete(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jint jresult = 0 ;
  char *arg1 = (char *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg1, 0);
    if (!arg1) return 0;
  }
  result = (int)sqlite3_complete((char const *)arg1);
  jresult = (jint)result; 
  if (arg1) (*jenv)->ReleaseStringUTFChars(jenv, jarg1, (const char *)arg1);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1busy_1handler(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3) {
  jint jresult = 0 ;
  sqlite3 *arg1 = (sqlite3 *) 0 ;
  int (*arg2)(void *,int) = (int (*)(void *,int)) 0 ;
  void *arg3 = (void *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(sqlite3 **)&jarg1; 
  arg2 = *(int (**)(void *,int))&jarg2; 
  arg3 = *(void **)&jarg3; 
  result = (int)sqlite3_busy_handler(arg1,arg2,arg3);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1busy_1timeout(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  jint jresult = 0 ;
  sqlite3 *arg1 = (sqlite3 *) 0 ;
  int arg2 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(sqlite3 **)&jarg1; 
  arg2 = (int)jarg2; 
  result = (int)sqlite3_busy_timeout(arg1,arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1get_1table(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jlong jarg3, jlong jarg4, jlong jarg5, jlong jarg6) {
  jint jresult = 0 ;
  sqlite3 *arg1 = (sqlite3 *) 0 ;
  char *arg2 = (char *) 0 ;
  char ***arg3 = (char ***) 0 ;
  int *arg4 = (int *) 0 ;
  int *arg5 = (int *) 0 ;
  char **arg6 = (char **) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(sqlite3 **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = *(char ****)&jarg3; 
  arg4 = *(int **)&jarg4; 
  arg5 = *(int **)&jarg5; 
  arg6 = *(char ***)&jarg6; 
  result = (int)sqlite3_get_table(arg1,(char const *)arg2,arg3,arg4,arg5,arg6);
  jresult = (jint)result; 
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1free_1table(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  char **arg1 = (char **) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(char ***)&jarg1; 
  sqlite3_free_table(arg1);
}


SWIGEXPORT jstring JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1mprintf(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jstring jresult = 0 ;
  char *arg1 = (char *) 0 ;
  void *arg2 = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg1, 0);
    if (!arg1) return 0;
  }
  result = (char *)sqlite3_mprintf((char const *)arg1,arg2);
  if(result) jresult = (*jenv)->NewStringUTF(jenv, (const char *)result);
  if (arg1) (*jenv)->ReleaseStringUTFChars(jenv, jarg1, (const char *)arg1);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1vmprintf(JNIEnv *jenv, jclass jcls, jstring jarg1, jlong jarg2) {
  jstring jresult = 0 ;
  char *arg1 = (char *) 0 ;
  va_list arg2 ;
  char *result = 0 ;
  va_list *argp2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg1, 0);
    if (!arg1) return 0;
  }
  argp2 = *(va_list **)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null va_list");
    return 0;
  }
  arg2 = *argp2; 
  result = (char *)sqlite3_vmprintf((char const *)arg1,arg2);
  if(result) jresult = (*jenv)->NewStringUTF(jenv, (const char *)result);
  if (arg1) (*jenv)->ReleaseStringUTFChars(jenv, jarg1, (const char *)arg1);
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1free(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  char *arg1 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg1, 0);
    if (!arg1) return ;
  }
  sqlite3_free(arg1);
  if (arg1) (*jenv)->ReleaseStringUTFChars(jenv, jarg1, (const char *)arg1);
}


SWIGEXPORT jstring JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1snprintf(JNIEnv *jenv, jclass jcls, jint jarg1, jstring jarg2, jstring jarg3) {
  jstring jresult = 0 ;
  int arg1 ;
  char *arg2 = (char *) 0 ;
  char *arg3 = (char *) 0 ;
  void *arg4 = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg3, 0);
    if (!arg3) return 0;
  }
  result = (char *)sqlite3_snprintf(arg1,arg2,(char const *)arg3,arg4);
  if(result) jresult = (*jenv)->NewStringUTF(jenv, (const char *)result);
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, (const char *)arg2);
  if (arg3) (*jenv)->ReleaseStringUTFChars(jenv, jarg3, (const char *)arg3);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1set_1authorizer(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3) {
  jint jresult = 0 ;
  sqlite3 *arg1 = (sqlite3 *) 0 ;
  int (*arg2)(void *,int,char const *,char const *,char const *,char const *) = (int (*)(void *,int,char const *,char const *,char const *,char const *)) 0 ;
  void *arg3 = (void *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(sqlite3 **)&jarg1; 
  arg2 = *(int (**)(void *,int,char const *,char const *,char const *,char const *))&jarg2; 
  arg3 = *(void **)&jarg3; 
  result = (int)sqlite3_set_authorizer(arg1,arg2,arg3);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1trace(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  sqlite3 *arg1 = (sqlite3 *) 0 ;
  void (*arg2)(void *,char const *) = (void (*)(void *,char const *)) 0 ;
  void *arg3 = (void *) 0 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(sqlite3 **)&jarg1; 
  arg2 = *(void (**)(void *,char const *))&jarg2; 
  arg3 = *(void **)&jarg3; 
  result = (void *)sqlite3_trace(arg1,arg2,arg3);
  *(void **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1profile(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  sqlite3 *arg1 = (sqlite3 *) 0 ;
  void (*arg2)(void *,char const *,sqlite_uint64) = (void (*)(void *,char const *,sqlite_uint64)) 0 ;
  void *arg3 = (void *) 0 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(sqlite3 **)&jarg1; 
  arg2 = *(void (**)(void *,char const *,sqlite_uint64))&jarg2; 
  arg3 = *(void **)&jarg3; 
  result = (void *)sqlite3_profile(arg1,arg2,arg3);
  *(void **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1progress_1handler(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jlong jarg3, jlong jarg4) {
  sqlite3 *arg1 = (sqlite3 *) 0 ;
  int arg2 ;
  int (*arg3)(void *) = (int (*)(void *)) 0 ;
  void *arg4 = (void *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(sqlite3 **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = *(int (**)(void *))&jarg3; 
  arg4 = *(void **)&jarg4; 
  sqlite3_progress_handler(arg1,arg2,arg3,arg4);
}


SWIGEXPORT jlong JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1commit_1hook(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  sqlite3 *arg1 = (sqlite3 *) 0 ;
  int (*arg2)(void *) = (int (*)(void *)) 0 ;
  void *arg3 = (void *) 0 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(sqlite3 **)&jarg1; 
  arg2 = *(int (**)(void *))&jarg2; 
  arg3 = *(void **)&jarg3; 
  result = (void *)sqlite3_commit_hook(arg1,arg2,arg3);
  *(void **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1open(JNIEnv *jenv, jclass jcls, jstring jarg1, jlong jarg2) {
  jint jresult = 0 ;
  char *arg1 = (char *) 0 ;
  sqlite3 **arg2 = (sqlite3 **) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg1, 0);
    if (!arg1) return 0;
  }
  arg2 = *(sqlite3 ***)&jarg2; 
  result = (int)sqlite3_open((char const *)arg1,arg2);
  jresult = (jint)result; 
  if (arg1) (*jenv)->ReleaseStringUTFChars(jenv, jarg1, (const char *)arg1);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1errcode(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  sqlite3 *arg1 = (sqlite3 *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(sqlite3 **)&jarg1; 
  result = (int)sqlite3_errcode(arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1errmsg(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  sqlite3 *arg1 = (sqlite3 *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(sqlite3 **)&jarg1; 
  result = (char *)sqlite3_errmsg(arg1);
  if(result) jresult = (*jenv)->NewStringUTF(jenv, (const char *)result);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1prepare(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jint jarg3, jlong jarg4, jlong jarg5) {
  jint jresult = 0 ;
  sqlite3 *arg1 = (sqlite3 *) 0 ;
  char *arg2 = (char *) 0 ;
  int arg3 ;
  sqlite3_stmt **arg4 = (sqlite3_stmt **) 0 ;
  char **arg5 = (char **) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(sqlite3 **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = (int)jarg3; 
  arg4 = *(sqlite3_stmt ***)&jarg4; 
  arg5 = *(char ***)&jarg5; 
  result = (int)sqlite3_prepare(arg1,(char const *)arg2,arg3,arg4,(char const **)arg5);
  jresult = (jint)result; 
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1bind_1blob(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jlong jarg3, jint jarg4, jlong jarg5) {
  jint jresult = 0 ;
  sqlite3_stmt *arg1 = (sqlite3_stmt *) 0 ;
  int arg2 ;
  void *arg3 = (void *) 0 ;
  int arg4 ;
  void (*arg5)(void *) = (void (*)(void *)) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(sqlite3_stmt **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = *(void **)&jarg3; 
  arg4 = (int)jarg4; 
  arg5 = *(void (**)(void *))&jarg5; 
  result = (int)sqlite3_bind_blob(arg1,arg2,(void const *)arg3,arg4,arg5);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1bind_1double(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jdouble jarg3) {
  jint jresult = 0 ;
  sqlite3_stmt *arg1 = (sqlite3_stmt *) 0 ;
  int arg2 ;
  double arg3 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(sqlite3_stmt **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (double)jarg3; 
  result = (int)sqlite3_bind_double(arg1,arg2,arg3);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1bind_1int(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jint jarg3) {
  jint jresult = 0 ;
  sqlite3_stmt *arg1 = (sqlite3_stmt *) 0 ;
  int arg2 ;
  int arg3 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(sqlite3_stmt **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  result = (int)sqlite3_bind_int(arg1,arg2,arg3);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1bind_1int64(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jlong jarg3) {
  jint jresult = 0 ;
  sqlite3_stmt *arg1 = (sqlite3_stmt *) 0 ;
  int arg2 ;
  sqlite_int64 arg3 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(sqlite3_stmt **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (sqlite_int64)jarg3; 
  result = (int)sqlite3_bind_int64(arg1,arg2,arg3);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1bind_1null(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  jint jresult = 0 ;
  sqlite3_stmt *arg1 = (sqlite3_stmt *) 0 ;
  int arg2 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(sqlite3_stmt **)&jarg1; 
  arg2 = (int)jarg2; 
  result = (int)sqlite3_bind_null(arg1,arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1bind_1text(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jstring jarg3, jint jarg4, jlong jarg5) {
  jint jresult = 0 ;
  sqlite3_stmt *arg1 = (sqlite3_stmt *) 0 ;
  int arg2 ;
  char *arg3 = (char *) 0 ;
  int arg4 ;
  void (*arg5)(void *) = (void (*)(void *)) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(sqlite3_stmt **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg3, 0);
    if (!arg3) return 0;
  }
  arg4 = (int)jarg4; 
  arg5 = *(void (**)(void *))&jarg5; 
  result = (int)sqlite3_bind_text(arg1,arg2,(char const *)arg3,arg4,arg5);
  jresult = (jint)result; 
  if (arg3) (*jenv)->ReleaseStringUTFChars(jenv, jarg3, (const char *)arg3);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1bind_1parameter_1count(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  sqlite3_stmt *arg1 = (sqlite3_stmt *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(sqlite3_stmt **)&jarg1; 
  result = (int)sqlite3_bind_parameter_count(arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1bind_1parameter_1name(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  jstring jresult = 0 ;
  sqlite3_stmt *arg1 = (sqlite3_stmt *) 0 ;
  int arg2 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(sqlite3_stmt **)&jarg1; 
  arg2 = (int)jarg2; 
  result = (char *)sqlite3_bind_parameter_name(arg1,arg2);
  if(result) jresult = (*jenv)->NewStringUTF(jenv, (const char *)result);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1bind_1parameter_1index(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  jint jresult = 0 ;
  sqlite3_stmt *arg1 = (sqlite3_stmt *) 0 ;
  char *arg2 = (char *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(sqlite3_stmt **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return 0;
  }
  result = (int)sqlite3_bind_parameter_index(arg1,(char const *)arg2);
  jresult = (jint)result; 
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1column_1count(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  sqlite3_stmt *arg1 = (sqlite3_stmt *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(sqlite3_stmt **)&jarg1; 
  result = (int)sqlite3_column_count(arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1column_1name(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  jstring jresult = 0 ;
  sqlite3_stmt *arg1 = (sqlite3_stmt *) 0 ;
  int arg2 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(sqlite3_stmt **)&jarg1; 
  arg2 = (int)jarg2; 
  result = (char *)sqlite3_column_name(arg1,arg2);
  if(result) jresult = (*jenv)->NewStringUTF(jenv, (const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1column_1database_1name(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  jstring jresult = 0 ;
  sqlite3_stmt *arg1 = (sqlite3_stmt *) 0 ;
  int arg2 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(sqlite3_stmt **)&jarg1; 
  arg2 = (int)jarg2; 
  result = (char *)sqlite3_column_database_name(arg1,arg2);
  if(result) jresult = (*jenv)->NewStringUTF(jenv, (const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1column_1table_1name(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  jstring jresult = 0 ;
  sqlite3_stmt *arg1 = (sqlite3_stmt *) 0 ;
  int arg2 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(sqlite3_stmt **)&jarg1; 
  arg2 = (int)jarg2; 
  result = (char *)sqlite3_column_table_name(arg1,arg2);
  if(result) jresult = (*jenv)->NewStringUTF(jenv, (const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1column_1origin_1name(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  jstring jresult = 0 ;
  sqlite3_stmt *arg1 = (sqlite3_stmt *) 0 ;
  int arg2 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(sqlite3_stmt **)&jarg1; 
  arg2 = (int)jarg2; 
  result = (char *)sqlite3_column_origin_name(arg1,arg2);
  if(result) jresult = (*jenv)->NewStringUTF(jenv, (const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1column_1decltype(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  jstring jresult = 0 ;
  sqlite3_stmt *arg1 = (sqlite3_stmt *) 0 ;
  int arg2 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(sqlite3_stmt **)&jarg1; 
  arg2 = (int)jarg2; 
  result = (char *)sqlite3_column_decltype(arg1,arg2);
  if(result) jresult = (*jenv)->NewStringUTF(jenv, (const char *)result);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1step(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  sqlite3_stmt *arg1 = (sqlite3_stmt *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(sqlite3_stmt **)&jarg1; 
  result = (int)sqlite3_step(arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1data_1count(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  sqlite3_stmt *arg1 = (sqlite3_stmt *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(sqlite3_stmt **)&jarg1; 
  result = (int)sqlite3_data_count(arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1column_1blob(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  jlong jresult = 0 ;
  sqlite3_stmt *arg1 = (sqlite3_stmt *) 0 ;
  int arg2 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(sqlite3_stmt **)&jarg1; 
  arg2 = (int)jarg2; 
  result = (void *)sqlite3_column_blob(arg1,arg2);
  *(void **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1column_1bytes(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  jint jresult = 0 ;
  sqlite3_stmt *arg1 = (sqlite3_stmt *) 0 ;
  int arg2 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(sqlite3_stmt **)&jarg1; 
  arg2 = (int)jarg2; 
  result = (int)sqlite3_column_bytes(arg1,arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1column_1bytes16(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  jint jresult = 0 ;
  sqlite3_stmt *arg1 = (sqlite3_stmt *) 0 ;
  int arg2 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(sqlite3_stmt **)&jarg1; 
  arg2 = (int)jarg2; 
  result = (int)sqlite3_column_bytes16(arg1,arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1column_1double(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  jdouble jresult = 0 ;
  sqlite3_stmt *arg1 = (sqlite3_stmt *) 0 ;
  int arg2 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(sqlite3_stmt **)&jarg1; 
  arg2 = (int)jarg2; 
  result = (double)sqlite3_column_double(arg1,arg2);
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1column_1int(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  jint jresult = 0 ;
  sqlite3_stmt *arg1 = (sqlite3_stmt *) 0 ;
  int arg2 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(sqlite3_stmt **)&jarg1; 
  arg2 = (int)jarg2; 
  result = (int)sqlite3_column_int(arg1,arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1column_1int64(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  jlong jresult = 0 ;
  sqlite3_stmt *arg1 = (sqlite3_stmt *) 0 ;
  int arg2 ;
  sqlite_int64 result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(sqlite3_stmt **)&jarg1; 
  arg2 = (int)jarg2; 
  result = (sqlite_int64)sqlite3_column_int64(arg1,arg2);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1column_1text(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  jstring jresult = 0 ;
  sqlite3_stmt *arg1 = (sqlite3_stmt *) 0 ;
  int arg2 ;
  unsigned char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(sqlite3_stmt **)&jarg1; 
  arg2 = (int)jarg2; 
  result = (unsigned char *)sqlite3_column_text(arg1,arg2);
  if(result) jresult = (*jenv)->NewStringUTF(jenv, (const char *)result);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1column_1type(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  jint jresult = 0 ;
  sqlite3_stmt *arg1 = (sqlite3_stmt *) 0 ;
  int arg2 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(sqlite3_stmt **)&jarg1; 
  arg2 = (int)jarg2; 
  result = (int)sqlite3_column_type(arg1,arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1finalize(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  sqlite3_stmt *arg1 = (sqlite3_stmt *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(sqlite3_stmt **)&jarg1; 
  result = (int)sqlite3_finalize(arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1reset(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  sqlite3_stmt *arg1 = (sqlite3_stmt *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(sqlite3_stmt **)&jarg1; 
  result = (int)sqlite3_reset(arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1create_1function(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jint jarg3, jint jarg4, jlong jarg5, jlong jarg6, jlong jarg7, jlong jarg8) {
  jint jresult = 0 ;
  sqlite3 *arg1 = (sqlite3 *) 0 ;
  char *arg2 = (char *) 0 ;
  int arg3 ;
  int arg4 ;
  void *arg5 = (void *) 0 ;
  void (*arg6)(sqlite3_context *,int,sqlite3_value **) = (void (*)(sqlite3_context *,int,sqlite3_value **)) 0 ;
  void (*arg7)(sqlite3_context *,int,sqlite3_value **) = (void (*)(sqlite3_context *,int,sqlite3_value **)) 0 ;
  void (*arg8)(sqlite3_context *) = (void (*)(sqlite3_context *)) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(sqlite3 **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = (int)jarg3; 
  arg4 = (int)jarg4; 
  arg5 = *(void **)&jarg5; 
  arg6 = *(void (**)(sqlite3_context *,int,sqlite3_value **))&jarg6; 
  arg7 = *(void (**)(sqlite3_context *,int,sqlite3_value **))&jarg7; 
  arg8 = *(void (**)(sqlite3_context *))&jarg8; 
  result = (int)sqlite3_create_function(arg1,(char const *)arg2,arg3,arg4,arg5,arg6,arg7,arg8);
  jresult = (jint)result; 
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1aggregate_1count(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  sqlite3_context *arg1 = (sqlite3_context *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(sqlite3_context **)&jarg1; 
  result = (int)sqlite3_aggregate_count(arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1value_1blob(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  sqlite3_value *arg1 = (sqlite3_value *) 0 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(sqlite3_value **)&jarg1; 
  result = (void *)sqlite3_value_blob(arg1);
  *(void **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1value_1bytes(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  sqlite3_value *arg1 = (sqlite3_value *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(sqlite3_value **)&jarg1; 
  result = (int)sqlite3_value_bytes(arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1value_1double(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jdouble jresult = 0 ;
  sqlite3_value *arg1 = (sqlite3_value *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(sqlite3_value **)&jarg1; 
  result = (double)sqlite3_value_double(arg1);
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1value_1int(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  sqlite3_value *arg1 = (sqlite3_value *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(sqlite3_value **)&jarg1; 
  result = (int)sqlite3_value_int(arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1value_1int64(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  sqlite3_value *arg1 = (sqlite3_value *) 0 ;
  sqlite_int64 result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(sqlite3_value **)&jarg1; 
  result = (sqlite_int64)sqlite3_value_int64(arg1);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1value_1text(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  sqlite3_value *arg1 = (sqlite3_value *) 0 ;
  unsigned char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(sqlite3_value **)&jarg1; 
  result = (unsigned char *)sqlite3_value_text(arg1);
  if(result) jresult = (*jenv)->NewStringUTF(jenv, (const char *)result);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1value_1type(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  sqlite3_value *arg1 = (sqlite3_value *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(sqlite3_value **)&jarg1; 
  result = (int)sqlite3_value_type(arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1value_1numeric_1type(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  sqlite3_value *arg1 = (sqlite3_value *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(sqlite3_value **)&jarg1; 
  result = (int)sqlite3_value_numeric_type(arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1aggregate_1context(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  jlong jresult = 0 ;
  sqlite3_context *arg1 = (sqlite3_context *) 0 ;
  int arg2 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(sqlite3_context **)&jarg1; 
  arg2 = (int)jarg2; 
  result = (void *)sqlite3_aggregate_context(arg1,arg2);
  *(void **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1user_1data(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  sqlite3_context *arg1 = (sqlite3_context *) 0 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(sqlite3_context **)&jarg1; 
  result = (void *)sqlite3_user_data(arg1);
  *(void **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1get_1auxdata(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  jlong jresult = 0 ;
  sqlite3_context *arg1 = (sqlite3_context *) 0 ;
  int arg2 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(sqlite3_context **)&jarg1; 
  arg2 = (int)jarg2; 
  result = (void *)sqlite3_get_auxdata(arg1,arg2);
  *(void **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1set_1auxdata(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jlong jarg3, jlong jarg4) {
  sqlite3_context *arg1 = (sqlite3_context *) 0 ;
  int arg2 ;
  void *arg3 = (void *) 0 ;
  void (*arg4)(void *) = (void (*)(void *)) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(sqlite3_context **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = *(void **)&jarg3; 
  arg4 = *(void (**)(void *))&jarg4; 
  sqlite3_set_auxdata(arg1,arg2,arg3,arg4);
}


SWIGEXPORT void JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1result_1blob(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jint jarg3, jlong jarg4) {
  sqlite3_context *arg1 = (sqlite3_context *) 0 ;
  void *arg2 = (void *) 0 ;
  int arg3 ;
  void (*arg4)(void *) = (void (*)(void *)) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(sqlite3_context **)&jarg1; 
  arg2 = *(void **)&jarg2; 
  arg3 = (int)jarg3; 
  arg4 = *(void (**)(void *))&jarg4; 
  sqlite3_result_blob(arg1,(void const *)arg2,arg3,arg4);
}


SWIGEXPORT void JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1result_1double(JNIEnv *jenv, jclass jcls, jlong jarg1, jdouble jarg2) {
  sqlite3_context *arg1 = (sqlite3_context *) 0 ;
  double arg2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(sqlite3_context **)&jarg1; 
  arg2 = (double)jarg2; 
  sqlite3_result_double(arg1,arg2);
}


SWIGEXPORT void JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1result_1error(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jint jarg3) {
  sqlite3_context *arg1 = (sqlite3_context *) 0 ;
  char *arg2 = (char *) 0 ;
  int arg3 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(sqlite3_context **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  arg3 = (int)jarg3; 
  sqlite3_result_error(arg1,(char const *)arg2,arg3);
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, (const char *)arg2);
}


SWIGEXPORT void JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1result_1int(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  sqlite3_context *arg1 = (sqlite3_context *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(sqlite3_context **)&jarg1; 
  arg2 = (int)jarg2; 
  sqlite3_result_int(arg1,arg2);
}


SWIGEXPORT void JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1result_1int64(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  sqlite3_context *arg1 = (sqlite3_context *) 0 ;
  sqlite_int64 arg2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(sqlite3_context **)&jarg1; 
  arg2 = (sqlite_int64)jarg2; 
  sqlite3_result_int64(arg1,arg2);
}


SWIGEXPORT void JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1result_1null(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  sqlite3_context *arg1 = (sqlite3_context *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(sqlite3_context **)&jarg1; 
  sqlite3_result_null(arg1);
}


SWIGEXPORT void JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1result_1text(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jint jarg3, jlong jarg4) {
  sqlite3_context *arg1 = (sqlite3_context *) 0 ;
  char *arg2 = (char *) 0 ;
  int arg3 ;
  void (*arg4)(void *) = (void (*)(void *)) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(sqlite3_context **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  arg3 = (int)jarg3; 
  arg4 = *(void (**)(void *))&jarg4; 
  sqlite3_result_text(arg1,(char const *)arg2,arg3,arg4);
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, (const char *)arg2);
}


SWIGEXPORT void JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1result_1value(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  sqlite3_context *arg1 = (sqlite3_context *) 0 ;
  sqlite3_value *arg2 = (sqlite3_value *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(sqlite3_context **)&jarg1; 
  arg2 = *(sqlite3_value **)&jarg2; 
  sqlite3_result_value(arg1,arg2);
}


SWIGEXPORT jint JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1create_1collation(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jint jarg3, jlong jarg4, jlong jarg5) {
  jint jresult = 0 ;
  sqlite3 *arg1 = (sqlite3 *) 0 ;
  char *arg2 = (char *) 0 ;
  int arg3 ;
  void *arg4 = (void *) 0 ;
  int (*arg5)(void *,int,void const *,int,void const *) = (int (*)(void *,int,void const *,int,void const *)) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(sqlite3 **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = (int)jarg3; 
  arg4 = *(void **)&jarg4; 
  arg5 = *(int (**)(void *,int,void const *,int,void const *))&jarg5; 
  result = (int)sqlite3_create_collation(arg1,(char const *)arg2,arg3,arg4,arg5);
  jresult = (jint)result; 
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1collation_1needed(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3) {
  jint jresult = 0 ;
  sqlite3 *arg1 = (sqlite3 *) 0 ;
  void *arg2 = (void *) 0 ;
  void (*arg3)(void *,sqlite3 *,int,char const *) = (void (*)(void *,sqlite3 *,int,char const *)) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(sqlite3 **)&jarg1; 
  arg2 = *(void **)&jarg2; 
  arg3 = *(void (**)(void *,sqlite3 *,int,char const *))&jarg3; 
  result = (int)sqlite3_collation_needed(arg1,arg2,arg3);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1expired(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  sqlite3_stmt *arg1 = (sqlite3_stmt *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(sqlite3_stmt **)&jarg1; 
  result = (int)sqlite3_expired(arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1transfer_1bindings(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jint jresult = 0 ;
  sqlite3_stmt *arg1 = (sqlite3_stmt *) 0 ;
  sqlite3_stmt *arg2 = (sqlite3_stmt *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(sqlite3_stmt **)&jarg1; 
  arg2 = *(sqlite3_stmt **)&jarg2; 
  result = (int)sqlite3_transfer_bindings(arg1,arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1temp_1directory_1set(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  char *arg1 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg1, 0);
    if (!arg1) return ;
  }
  {
    if (sqlite3_temp_directory) free((char *)sqlite3_temp_directory);
    if (arg1) {
      sqlite3_temp_directory = (char *) malloc(strlen((const char *)arg1)+1);
      strcpy((char *)sqlite3_temp_directory, (const char *)arg1);
    } else {
      sqlite3_temp_directory = 0;
    }
  }
  if (arg1) (*jenv)->ReleaseStringUTFChars(jenv, jarg1, (const char *)arg1);
}


SWIGEXPORT jstring JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1temp_1directory_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)sqlite3_temp_directory;
  if(result) jresult = (*jenv)->NewStringUTF(jenv, (const char *)result);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1global_1recover(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)sqlite3_global_recover();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1get_1autocommit(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  sqlite3 *arg1 = (sqlite3 *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(sqlite3 **)&jarg1; 
  result = (int)sqlite3_get_autocommit(arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1db_1handle(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  sqlite3_stmt *arg1 = (sqlite3_stmt *) 0 ;
  sqlite3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(sqlite3_stmt **)&jarg1; 
  result = (sqlite3 *)sqlite3_db_handle(arg1);
  *(sqlite3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1update_1hook(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  sqlite3 *arg1 = (sqlite3 *) 0 ;
  void (*arg2)(void *,int,char const *,char const *,sqlite_int64) = (void (*)(void *,int,char const *,char const *,sqlite_int64)) 0 ;
  void *arg3 = (void *) 0 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(sqlite3 **)&jarg1; 
  arg2 = *(void (**)(void *,int,char const *,char const *,sqlite_int64))&jarg2; 
  arg3 = *(void **)&jarg3; 
  result = (void *)sqlite3_update_hook(arg1,arg2,arg3);
  *(void **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1rollback_1hook(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  sqlite3 *arg1 = (sqlite3 *) 0 ;
  void (*arg2)(void *) = (void (*)(void *)) 0 ;
  void *arg3 = (void *) 0 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(sqlite3 **)&jarg1; 
  arg2 = *(void (**)(void *))&jarg2; 
  arg3 = *(void **)&jarg3; 
  result = (void *)sqlite3_rollback_hook(arg1,arg2,arg3);
  *(void **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1enable_1shared_1cache(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jint jresult = 0 ;
  int arg1 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  result = (int)sqlite3_enable_shared_cache(arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1thread_1cleanup(JNIEnv *jenv, jclass jcls) {
  (void)jenv;
  (void)jcls;
  sqlite3_thread_cleanup();
}


SWIGEXPORT jint JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1table_1column_1metadata(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jstring jarg3, jstring jarg4, jlong jarg5, jlong jarg6, jlong jarg7, jlong jarg8, jlong jarg9) {
  jint jresult = 0 ;
  sqlite3 *arg1 = (sqlite3 *) 0 ;
  char *arg2 = (char *) 0 ;
  char *arg3 = (char *) 0 ;
  char *arg4 = (char *) 0 ;
  char **arg5 = (char **) 0 ;
  char **arg6 = (char **) 0 ;
  int *arg7 = (int *) 0 ;
  int *arg8 = (int *) 0 ;
  int *arg9 = (int *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(sqlite3 **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg3, 0);
    if (!arg3) return 0;
  }
  arg4 = 0;
  if (jarg4) {
    arg4 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg4, 0);
    if (!arg4) return 0;
  }
  arg5 = *(char ***)&jarg5; 
  arg6 = *(char ***)&jarg6; 
  arg7 = *(int **)&jarg7; 
  arg8 = *(int **)&jarg8; 
  arg9 = *(int **)&jarg9; 
  result = (int)sqlite3_table_column_metadata(arg1,(char const *)arg2,(char const *)arg3,(char const *)arg4,(char const **)arg5,(char const **)arg6,arg7,arg8,arg9);
  jresult = (jint)result; 
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, (const char *)arg2);
  if (arg3) (*jenv)->ReleaseStringUTFChars(jenv, jarg3, (const char *)arg3);
  if (arg4) (*jenv)->ReleaseStringUTFChars(jenv, jarg4, (const char *)arg4);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_sqlite_swig_SQLite3JNI_new_1p_1p_1sqlite3(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  sqlite3 **result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    result = (sqlite3 **)new_p_p_sqlite3();
    if (!result) {
      SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "Not enough memory.");
      return 0;
    }
  }
  *(sqlite3 ***)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_sqlite_swig_SQLite3JNI_copy_1p_1p_1sqlite3(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  sqlite3 *arg1 = (sqlite3 *) 0 ;
  sqlite3 **result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(sqlite3 **)&jarg1; 
  result = (sqlite3 **)copy_p_p_sqlite3(arg1);
  *(sqlite3 ***)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_sqlite_swig_SQLite3JNI_delete_1p_1p_1sqlite3(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  sqlite3 **arg1 = (sqlite3 **) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(sqlite3 ***)&jarg1; 
  delete_p_p_sqlite3(arg1);
}


SWIGEXPORT void JNICALL Java_org_sqlite_swig_SQLite3JNI_p_1p_1sqlite3_1assign(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  sqlite3 **arg1 = (sqlite3 **) 0 ;
  sqlite3 *arg2 = (sqlite3 *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(sqlite3 ***)&jarg1; 
  arg2 = *(sqlite3 **)&jarg2; 
  p_p_sqlite3_assign(arg1,arg2);
}


SWIGEXPORT jlong JNICALL Java_org_sqlite_swig_SQLite3JNI_p_1p_1sqlite3_1value(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  sqlite3 **arg1 = (sqlite3 **) 0 ;
  sqlite3 *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(sqlite3 ***)&jarg1; 
  result = (sqlite3 *)p_p_sqlite3_value(arg1);
  *(sqlite3 **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_sqlite_swig_SQLite3JNI_new_1p_1p_1sqlite3_1stmt(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  sqlite3_stmt **result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    result = (sqlite3_stmt **)new_p_p_sqlite3_stmt();
    if (!result) {
      SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "Not enough memory.");
      return 0;
    }
  }
  *(sqlite3_stmt ***)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_sqlite_swig_SQLite3JNI_copy_1p_1p_1sqlite3_1stmt(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  sqlite3_stmt *arg1 = (sqlite3_stmt *) 0 ;
  sqlite3_stmt **result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(sqlite3_stmt **)&jarg1; 
  result = (sqlite3_stmt **)copy_p_p_sqlite3_stmt(arg1);
  *(sqlite3_stmt ***)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_sqlite_swig_SQLite3JNI_delete_1p_1p_1sqlite3_1stmt(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  sqlite3_stmt **arg1 = (sqlite3_stmt **) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(sqlite3_stmt ***)&jarg1; 
  delete_p_p_sqlite3_stmt(arg1);
}


SWIGEXPORT void JNICALL Java_org_sqlite_swig_SQLite3JNI_p_1p_1sqlite3_1stmt_1assign(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  sqlite3_stmt **arg1 = (sqlite3_stmt **) 0 ;
  sqlite3_stmt *arg2 = (sqlite3_stmt *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(sqlite3_stmt ***)&jarg1; 
  arg2 = *(sqlite3_stmt **)&jarg2; 
  p_p_sqlite3_stmt_assign(arg1,arg2);
}


SWIGEXPORT jlong JNICALL Java_org_sqlite_swig_SQLite3JNI_p_1p_1sqlite3_1stmt_1value(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  sqlite3_stmt **arg1 = (sqlite3_stmt **) 0 ;
  sqlite3_stmt *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(sqlite3_stmt ***)&jarg1; 
  result = (sqlite3_stmt *)p_p_sqlite3_stmt_value(arg1);
  *(sqlite3_stmt **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_sqlite_swig_SQLite3JNI_new_1p_1p_1char(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  char **result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    result = (char **)new_p_p_char();
    if (!result) {
      SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "Not enough memory.");
      return 0;
    }
  }
  *(char ***)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_sqlite_swig_SQLite3JNI_copy_1p_1p_1char(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jlong jresult = 0 ;
  char *arg1 = (char *) 0 ;
  char **result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg1, 0);
    if (!arg1) return 0;
  }
  result = (char **)copy_p_p_char((char const *)arg1);
  *(char ***)&jresult = result; 
  if (arg1) (*jenv)->ReleaseStringUTFChars(jenv, jarg1, (const char *)arg1);
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_sqlite_swig_SQLite3JNI_delete_1p_1p_1char(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  char **arg1 = (char **) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(char ***)&jarg1; 
  delete_p_p_char((char const **)arg1);
}


SWIGEXPORT void JNICALL Java_org_sqlite_swig_SQLite3JNI_p_1p_1char_1assign(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  char **arg1 = (char **) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(char ***)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  p_p_char_assign((char const **)arg1,(char const *)arg2);
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, (const char *)arg2);
}


SWIGEXPORT jstring JNICALL Java_org_sqlite_swig_SQLite3JNI_p_1p_1char_1value(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  char **arg1 = (char **) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(char ***)&jarg1; 
  result = (char *)p_p_char_value((char const **)arg1);
  if(result) jresult = (*jenv)->NewStringUTF(jenv, (const char *)result);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_sqlite_swig_SQLite3JNI_new_1p_1int(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  int *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    result = (int *)new_p_int();
    if (!result) {
      SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "Not enough memory.");
      return 0;
    }
  }
  *(int **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_sqlite_swig_SQLite3JNI_copy_1p_1int(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  int arg1 ;
  int *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  result = (int *)copy_p_int(arg1);
  *(int **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_sqlite_swig_SQLite3JNI_delete_1p_1int(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  int *arg1 = (int *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(int **)&jarg1; 
  delete_p_int(arg1);
}


SWIGEXPORT void JNICALL Java_org_sqlite_swig_SQLite3JNI_p_1int_1assign(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  int *arg1 = (int *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(int **)&jarg1; 
  arg2 = (int)jarg2; 
  p_int_assign(arg1,arg2);
}


SWIGEXPORT jint JNICALL Java_org_sqlite_swig_SQLite3JNI_p_1int_1value(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  int *arg1 = (int *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(int **)&jarg1; 
  result = (int)p_int_value(arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1bind_1blob_1by_1bytes(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jbyteArray jarg3, jint jarg4, jlong jarg5) {
  jint jresult = 0 ;
  sqlite3_stmt *arg1 = (sqlite3_stmt *) 0 ;
  int arg2 ;
  char *arg3 = (char *) 0 ;
  int arg4 ;
  void (*arg5)(void *) = (void (*)(void *)) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(sqlite3_stmt **)&jarg1; 
  arg2 = (int)jarg2; 
  {
    arg3 = (char *) (*jenv)->GetByteArrayElements(jenv, jarg3, 0); 
  }
  arg4 = (int)jarg4; 
  arg5 = *(void (**)(void *))&jarg5; 
  result = (int)sqlite3_bind_blob_by_bytes(arg1,arg2,arg3,arg4,arg5);
  jresult = (jint)result; 
  {
    (*jenv)->ReleaseByteArrayElements(jenv, jarg3, (jbyte *) arg3, 0); 
  }
  
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_sqlite_swig_SQLite3JNI_read_1blob(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jbyteArray jarg3, jint jarg4, jint jarg5) {
  void *arg1 = (void *) 0 ;
  long long arg2 ;
  char *arg3 = (char *) 0 ;
  int arg4 ;
  int arg5 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(void **)&jarg1; 
  arg2 = (long long)jarg2; 
  {
    arg3 = (char *) (*jenv)->GetByteArrayElements(jenv, jarg3, 0); 
  }
  arg4 = (int)jarg4; 
  arg5 = (int)jarg5; 
  read_blob((void const *)arg1,arg2,arg3,arg4,arg5);
  {
    (*jenv)->ReleaseByteArrayElements(jenv, jarg3, (jbyte *) arg3, 0); 
  }
  
}


SWIGEXPORT jlong JNICALL Java_org_sqlite_swig_SQLite3JNI_get_1p_1sqlite3_1value(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  jlong jresult = 0 ;
  sqlite3_value **arg1 = (sqlite3_value **) 0 ;
  int arg2 ;
  sqlite3_value *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(sqlite3_value ***)&jarg1; 
  arg2 = (int)jarg2; 
  result = (sqlite3_value *)get_p_sqlite3_value(arg1,arg2);
  *(sqlite3_value **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_sqlite_swig_SQLite3JNI_sqlite3_1result_1blob_1by_1bytes(JNIEnv *jenv, jclass jcls, jlong jarg1, jbyteArray jarg2, jint jarg3, jlong jarg4) {
  sqlite3_context *arg1 = (sqlite3_context *) 0 ;
  char *arg2 = (char *) 0 ;
  int arg3 ;
  void (*arg4)(void *) = (void (*)(void *)) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(sqlite3_context **)&jarg1; 
  {
    arg2 = (char *) (*jenv)->GetByteArrayElements(jenv, jarg2, 0); 
  }
  arg3 = (int)jarg3; 
  arg4 = *(void (**)(void *))&jarg4; 
  sqlite3_result_blob_by_bytes(arg1,arg2,arg3,arg4);
  {
    (*jenv)->ReleaseByteArrayElements(jenv, jarg2, (jbyte *) arg2, 0); 
  }
  
}


#ifdef __cplusplus
}
#endif

