/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.sqlite.udf;

import java.sql.SQLException;
import java.util.logging.Logger;
import org.sqlite.callback.NamedCallback;

/**
 * User-Defined function class.
 * @author calico
 * @see <a href="http://sqlite.org/c3ref/create_function.html">Create Or Redefine SQL Functions</a>
 * @see org.sqlite.jdbc.JdbcConnection#createFunction(Function)
 * @see org.sqlite.jdbc.JdbcConnection#dropFunction(Function)
 */
public abstract class Function extends NamedCallback {
    protected final int argc;
    
    protected Function(String name) {
        this(name, -1);
    }
    
    protected Function(String name, int argc) {
        super(name);
        this.argc = argc;
    }
    
    public int getArgumentCount() {
        return argc;
    }
    
    /**
     * Called from the sqlite3_step() function.
     * @param context
     * @param argc
     * @param value
     */
    protected final void xFunc(long context, int argc, long value) {
        // TODO Mysaifu JVMのBug#11980が解決したらアクセス修飾子をprivateに戻すこと！
        // @see http://sourceforge.jp/tracker/index.php?func=detail&aid=11980&group_id=1890&atid=7027
        Context ctx = null;
        try {
            ctx = new Context(context, argc, value);
            xFunc(ctx);
            
        } catch (Throwable th) {
            if (ctx != null) {
                final String msg = th.toString();
                ctx.resultError((msg != null ? msg : "Unknown error."));
                
            } else {
                Logger.getLogger(Function.class.getName()).fine("Exception occurred: " + th.toString());
            }
        }
    }
    
    protected abstract void xFunc(Context ctx) throws SQLException;
}
