import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import org.sqlite.event.CommitHook;
import org.sqlite.jdbc.JdbcConnection;

public class CommitHookExample {

    @org.junit.Test(expected = java.sql.SQLException.class)
    public void example() throws ClassNotFoundException, SQLException {
        Class.forName("org.sqlite.Driver");
        final String url = "jdbc:sqlite:mem:";
        final JdbcConnection conn = (JdbcConnection) DriverManager.getConnection(url);
        try {
            // new commit hook
            final CommitHook hook
                    = new CommitHook() {
                            @Override
                            protected int xCommit() {
                                System.out.println("Called xCommit()");
                                // cancel commit
                                return 1;
                            }
                        };

            // set commit hook
            conn.setCommitHook(hook);
            // begin transaction
            conn.setAutoCommit(false);
            
            final Statement stmt = conn.createStatement();
            String sql
                    = "CREATE TEMPORARY TABLE IF NOT EXISTS temp_tbl_1("
                        + "  ID INTEGER PRIMARY KEY AUTOINCREMENT"
                        + ", VALUE TEXT"
                    + ")";
            stmt.executeUpdate(sql);

            sql = "INSERT INTO temp_tbl_1 VALUES(1, 'One')";
            stmt.executeUpdate(sql);
            stmt.close();
            
            // commit transaction
            conn.commit();

            // clear commit hook
            conn.clearCommitHook();

        } finally {
            conn.close();
        }
    }

    public static void main(String[] args) throws Exception {
        new CommitHookExample().example();
    }
}
