/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import org.sqlite.Statement;
import org.sqlite.auth.Authorizer;
import org.sqlite.callback.ExecCallback;
import org.sqlite.event.BusyHandler;
import org.sqlite.event.CollationNeededHandler;
import org.sqlite.event.CommitHook;
import org.sqlite.event.ProgressHandler;
import org.sqlite.event.RollbackHook;
import org.sqlite.event.UpdateHook;
import org.sqlite.jdbc.JdbcSQLException;
import org.sqlite.jdbc.TransactionType;
import org.sqlite.profiler.Profiler;
import org.sqlite.profiler.Tracer;
import org.sqlite.schema.ColumnMetaData;
import org.sqlite.swig.SQLite3;
import org.sqlite.swig.SWIGTYPE_p_int;
import org.sqlite.swig.SWIGTYPE_p_p_char;
import org.sqlite.swig.SWIGTYPE_p_p_sqlite3;
import org.sqlite.swig.SWIGTYPE_p_sqlite3;
import org.sqlite.text.Collator;
import org.sqlite.types.SQLite3StmtPtrPtr;
import org.sqlite.udf.Function;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Database {
    protected final Properties info;
    private final boolean isInMemory;
    private final SQLite3PtrPtr ppDb = new SQLite3PtrPtr();
    private List<Statement> statements;
    private Map<String, Function> functions;
    private Map<String, Collator> collators;
    private Authorizer authorizer;
    private BusyHandler busyHandler;
    private CollationNeededHandler collNeeded;
    private ProgressHandler progressHandler;
    private int timeout;

    public Database(String filename, Properties info) throws SQLException {
        this.info = info;
        this.isInMemory = filename == null || SQLite3.getInMemoryFileName().equals(filename);
        this.open(filename);
    }

    public String getProductName() {
        return "SQLite";
    }

    public boolean isInMemoryMode() {
        return this.isInMemory;
    }

    private SWIGTYPE_p_sqlite3 getHandle() {
        return this.ppDb.getSQLite3Ptr();
    }

    protected void open(String filename) throws SQLException {
        String tempDir;
        if (this.info != null && (tempDir = this.info.getProperty("TEMP_DIR")) != null) {
            SQLite3.set_sqlite3_temp_directory(tempDir);
        }
        int ret = SQLite3.sqlite3_open(filename, this.ppDb);
        this.ppDb.allocateHandle();
        if (ret != 0) {
            SWIGTYPE_p_sqlite3 db = this.getHandle();
            JdbcSQLException ex = new JdbcSQLException(ret, db);
            this.ppDb.delete();
            throw ex;
        }
    }

    public boolean isReadOnly() {
        return false;
    }

    public boolean isClosed() {
        return this.ppDb.isDeleted();
    }

    public void close() throws SQLException {
        if (!this.isClosed()) {
            this.closeStatements();
            this.dropFunctions();
            this.dropCollators();
            this.internalClearAuthorizer();
            this.internalClearBusyHandler();
            this.internalClearCollationNeededHandler();
            this.clearProgressHandler();
            this.clearCommitHook();
            this.clearRollbackHook();
            this.clearUpdateHook();
            this.clearProfiler();
            this.clearTracer();
            SWIGTYPE_p_sqlite3 db = this.getHandle();
            int ret = SQLite3.sqlite3_close(db);
            if (ret != 0) {
                throw new JdbcSQLException(ret, db);
            }
            this.ppDb.delete();
        }
    }

    public boolean getAutoCommit() {
        SWIGTYPE_p_sqlite3 db = this.getHandle();
        return SQLite3.sqlite3_get_autocommit(db) != 0;
    }

    public void setBusyTimeout(int ms) throws SQLException {
        this.clearBusyHandler();
        SWIGTYPE_p_sqlite3 db = this.getHandle();
        int ret = SQLite3.sqlite3_busy_timeout(db, ms);
        if (ret != 0) {
            throw new JdbcSQLException(ret, db);
        }
        this.timeout = ms < 1 ? 0 : ms;
    }

    public int getBusyTimeout() {
        return this.timeout;
    }

    public void execute(String sql) throws SQLException {
        this.execute(sql, null, null);
    }

    public void execute(String sql, ExecCallback callback, SWIGTYPE_p_p_char errmsg) throws SQLException {
        SWIGTYPE_p_sqlite3 db = this.getHandle();
        int ret = 0;
        if (this.timeout == 0) {
            while ((ret = SQLite3.sqlite3_exec(db, sql, callback, errmsg)) == 5) {
            }
        } else {
            ret = SQLite3.sqlite3_exec(db, sql, callback, errmsg);
        }
        if (ret != 0) {
            throw new JdbcSQLException(ret, db);
        }
    }

    public void pragma(String[] commands) throws SQLException {
        StringBuilder sql = new StringBuilder();
        for (String cmd : commands) {
            sql.append("PRAGMA ").append(cmd).append(";");
        }
        this.execute(sql.toString());
    }

    public void beginTransaction(TransactionType type) throws SQLException {
        this.closeStatements();
        if (type == null) {
            this.execute("BEGIN");
        } else {
            this.execute("BEGIN " + (Object)((Object)type));
        }
    }

    public void commitTransaction() throws SQLException {
        this.closeStatements();
        this.execute("COMMIT");
    }

    public void rollbackTransaction() throws SQLException {
        this.closeStatements();
        this.execute("ROLLBACK");
    }

    public Statement prepare(String sql, SQLite3StmtPtrPtr ppStmt) throws SQLException {
        if (sql == null) {
            throw new NullPointerException("sql is null.");
        }
        if (ppStmt == null) {
            throw new NullPointerException("ppStmt is null.");
        }
        SWIGTYPE_p_sqlite3 db = this.getHandle();
        int ret = SQLite3.sqlite3_prepare(db, sql, -1, ppStmt, null);
        if (ret != 0) {
            throw new JdbcSQLException(ret, db);
        }
        return new Statement(this, ppStmt.getSQLite3StmtPtr());
    }

    public Statement prepare(String sql) throws SQLException {
        SQLite3StmtPtrPtr ppStmt;
        if (sql == null) {
            throw new NullPointerException("sql is null.");
        }
        SWIGTYPE_p_sqlite3 db = this.getHandle();
        int ret = SQLite3.sqlite3_prepare(db, sql, -1, ppStmt = new SQLite3StmtPtrPtr(), null);
        if (ret != 0) {
            ppStmt.delete();
            throw new JdbcSQLException(ret, db);
        }
        return new Statement(this, ppStmt);
    }

    public List<Statement> prepareMultiple(String sql) throws SQLException {
        if (sql == null) {
            throw new NullPointerException("sql is null.");
        }
        SWIGTYPE_p_sqlite3 db = this.getHandle();
        ArrayList<SQLite3StmtPtrPtr> stmts = new ArrayList<SQLite3StmtPtrPtr>();
        String[] tail = new String[1];
        do {
            SQLite3StmtPtrPtr ppStmt = new SQLite3StmtPtrPtr();
            stmts.add(ppStmt);
            int ret = SQLite3.sqlite3_prepare(db, sql, -1, ppStmt, tail);
            if (ret == 0) continue;
            for (SQLite3StmtPtrPtr stmt : stmts) {
                stmt.delete();
            }
            throw new JdbcSQLException(ret, db);
        } while ((sql = tail[0].trim()).length() > 0);
        ArrayList<Statement> ret = new ArrayList<Statement>(stmts.size());
        for (SQLite3StmtPtrPtr stmt : stmts) {
            ret.add(new Statement(this, stmt));
        }
        return ret;
    }

    public void interrupt() {
        SWIGTYPE_p_sqlite3 db = this.getHandle();
        SQLite3.sqlite3_interrupt(db);
    }

    public int changes() {
        SWIGTYPE_p_sqlite3 db = this.getHandle();
        return SQLite3.sqlite3_changes(db);
    }

    public int totalChanges() {
        SWIGTYPE_p_sqlite3 db = this.getHandle();
        return SQLite3.sqlite3_total_changes(db);
    }

    public long lastInsertRowId() {
        SWIGTYPE_p_sqlite3 db = this.getHandle();
        return SQLite3.sqlite3_last_insert_rowid(db);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ColumnMetaData getColumnMetaData(String dbName, String tableName, String columnName) throws SQLException {
        SWIGTYPE_p_sqlite3 db = this.getHandle();
        SWIGTYPE_p_p_char dataType = null;
        SWIGTYPE_p_p_char collSeq = null;
        SWIGTYPE_p_int notNull = null;
        SWIGTYPE_p_int primaryKey = null;
        SWIGTYPE_p_int autoInc = null;
        try {
            dataType = SQLite3.new_p_p_char();
            collSeq = SQLite3.new_p_p_char();
            notNull = SQLite3.new_p_int();
            primaryKey = SQLite3.new_p_int();
            autoInc = SQLite3.new_p_int();
            int ret = SQLite3.sqlite3_table_column_metadata(db, dbName, tableName, columnName, dataType, collSeq, notNull, primaryKey, autoInc);
            if (ret != 0) {
                throw new JdbcSQLException(ret, db);
            }
            ColumnMetaData columnMetaData = new ColumnMetaData(SQLite3.get_p_char(dataType), SQLite3.get_p_char(collSeq), SQLite3.get_int(notNull), SQLite3.get_int(primaryKey), SQLite3.get_int(autoInc));
            return columnMetaData;
        }
        finally {
            if (dataType != null) {
                SQLite3.delete_p_p_char(dataType);
            }
            if (collSeq != null) {
                SQLite3.delete_p_p_char(collSeq);
            }
            if (notNull != null) {
                SQLite3.delete_p_int(notNull);
            }
            if (primaryKey != null) {
                SQLite3.delete_p_int(primaryKey);
            }
            if (autoInc != null) {
                SQLite3.delete_p_int(autoInc);
            }
        }
    }

    void addStatement(Statement stmt) throws SQLException {
        if (this.statements == null) {
            this.statements = new ArrayList<Statement>();
        }
        if (this.statements.contains(stmt)) {
            throw new SQLException("Duplicate sqlite3_stmt handle error.", "90J31");
        }
        this.statements.add(stmt);
    }

    void removeStatement(Statement stmt) throws SQLException {
        if (this.statements != null && !this.statements.remove(stmt)) {
            throw new SQLException("Unmanaged sqlite3_stmt handle error.", "90J32");
        }
    }

    private void closeStatements() {
        if (this.statements != null) {
            List<Statement> list = this.statements;
            this.statements = null;
            for (Statement stmt : list) {
                try {
                    stmt.close();
                }
                catch (SQLException ex) {
                    Logger.getLogger(Database.class.getName()).info(ex.toString());
                }
            }
        }
    }

    private void addFunction(Function func) {
        if (this.functions == null) {
            this.functions = new HashMap<String, Function>();
        }
        this.functions.put(func.getName().toUpperCase(), func);
    }

    private void removeFunction(Function func) {
        if (this.functions != null) {
            this.functions.remove(func.getName().toUpperCase());
        }
    }

    private void dropFunctions() {
        if (this.functions != null) {
            Collection<Function> list = this.functions.values();
            this.functions = null;
            for (Function func : list) {
                if (!func.isRegistered()) continue;
                try {
                    this.dropFunction(func);
                }
                catch (SQLException ex) {
                    Logger.getLogger(Database.class.getName()).info(ex.toString());
                }
            }
        }
    }

    public void createFunction(Function func) throws SQLException {
        SWIGTYPE_p_sqlite3 db;
        int ret;
        Function old;
        if (this.functions != null && (old = this.functions.get(func.getName().toUpperCase())) != null) {
            this.dropFunction(old);
        }
        if ((ret = SQLite3.sqlite3_create_function(db = this.getHandle(), func)) != 0) {
            throw new JdbcSQLException(ret, db);
        }
        this.addFunction(func);
    }

    public void dropFunction(Function func) throws SQLException {
        SWIGTYPE_p_sqlite3 db = this.getHandle();
        int ret = SQLite3.sqlite3_drop_function(db, func);
        if (ret != 0) {
            throw new JdbcSQLException(ret, db);
        }
        this.removeFunction(func);
    }

    public void dropFunction(String name) throws SQLException {
        Function func;
        if (this.functions != null && (func = this.functions.get(name.toUpperCase())) != null) {
            this.dropFunction(func);
        }
    }

    private void addCollator(Collator col) {
        if (this.collators == null) {
            this.collators = new HashMap<String, Collator>();
        }
        this.collators.put(col.getName().toUpperCase(), col);
    }

    private void removeCollator(Collator col) {
        if (this.collators != null) {
            this.collators.remove(col.getName().toUpperCase());
        }
    }

    private void dropCollators() {
        if (this.collators != null) {
            Collection<Collator> list = this.collators.values();
            this.collators = null;
            for (Collator col : list) {
                if (!col.isRegistered()) continue;
                try {
                    this.dropCollationSequence(col);
                }
                catch (SQLException ex) {
                    Logger.getLogger(Database.class.getName()).info(ex.toString());
                }
            }
        }
    }

    public void createCollationSequence(Collator col) throws SQLException {
        SWIGTYPE_p_sqlite3 db;
        int ret;
        Collator old;
        if (this.collators != null && (old = this.collators.get(col.getName().toUpperCase())) != null) {
            this.dropCollationSequence(old);
        }
        if ((ret = SQLite3.sqlite3_create_collation(db = this.getHandle(), col)) != 0) {
            throw new JdbcSQLException(ret, db);
        }
        this.addCollator(col);
    }

    public void dropCollationSequence(Collator col) throws SQLException {
        SWIGTYPE_p_sqlite3 db = this.getHandle();
        int ret = SQLite3.sqlite3_drop_collation(db, col);
        if (ret != 0) {
            throw new JdbcSQLException(ret, db);
        }
        this.removeCollator(col);
    }

    public void dropCollationSequence(String name) throws SQLException {
        Collator col;
        if (this.collators != null && (col = this.collators.get(name.toUpperCase())) != null) {
            this.dropCollationSequence(col);
        }
    }

    public void setAuthorizer(Authorizer auth) throws SQLException {
        this.clearAuthorizer();
        SWIGTYPE_p_sqlite3 db = this.getHandle();
        int ret = SQLite3.sqlite3_set_authorizer(db, auth);
        if (ret != 0) {
            throw new JdbcSQLException(ret, db);
        }
        this.authorizer = auth;
    }

    public void clearAuthorizer() throws SQLException {
        if (this.authorizer != null) {
            SWIGTYPE_p_sqlite3 db = this.getHandle();
            int ret = SQLite3.sqlite3_clear_authorizer(db, this.authorizer);
            if (ret != 0) {
                throw new JdbcSQLException(ret, db);
            }
            this.authorizer = null;
        }
    }

    private void internalClearAuthorizer() {
        try {
            this.clearAuthorizer();
        }
        catch (SQLException ex) {
            Logger.getLogger(Database.class.getName()).info(ex.toString());
        }
    }

    public void setBusyHandler(BusyHandler busy) throws SQLException {
        this.clearBusyHandler();
        SWIGTYPE_p_sqlite3 db = this.getHandle();
        int ret = SQLite3.sqlite3_busy_handler(db, busy);
        if (ret != 0) {
            throw new JdbcSQLException(ret, db);
        }
        this.busyHandler = busy;
        this.timeout = -1;
    }

    public void clearBusyHandler() throws SQLException {
        if (this.busyHandler != null) {
            SWIGTYPE_p_sqlite3 db = this.getHandle();
            int ret = SQLite3.sqlite3_clear_busy_handler(db, this.busyHandler);
            if (ret != 0) {
                throw new JdbcSQLException(ret, db);
            }
            this.busyHandler = null;
        }
    }

    private void internalClearBusyHandler() {
        try {
            this.clearBusyHandler();
        }
        catch (SQLException ex) {
            Logger.getLogger(Database.class.getName()).info(ex.toString());
        }
    }

    public void setCollationNeededHandler(CollationNeededHandler needed) throws SQLException {
        this.clearCollationNeededHandler();
        SWIGTYPE_p_sqlite3 db = this.getHandle();
        int ret = SQLite3.sqlite3_collation_needed(db, needed);
        if (ret != 0) {
            throw new JdbcSQLException(ret, db);
        }
        this.collNeeded = needed;
        this.collNeeded.setDatabase(this);
    }

    public void clearCollationNeededHandler() throws SQLException {
        if (this.collNeeded != null) {
            SWIGTYPE_p_sqlite3 db = this.getHandle();
            int ret = SQLite3.sqlite3_clear_collation_needed(db, this.collNeeded);
            if (ret != 0) {
                throw new JdbcSQLException(ret, db);
            }
            this.collNeeded.setDatabase(null);
            this.collNeeded = null;
        }
    }

    private void internalClearCollationNeededHandler() {
        try {
            this.clearCollationNeededHandler();
        }
        catch (SQLException ex) {
            Logger.getLogger(Database.class.getName()).info(ex.toString());
        }
    }

    public void setProgressHandler(ProgressHandler prog) {
        this.clearProgressHandler();
        SWIGTYPE_p_sqlite3 db = this.getHandle();
        SQLite3.sqlite3_progress_handler(db, prog);
        this.progressHandler = prog;
    }

    public void clearProgressHandler() {
        if (this.progressHandler != null) {
            SWIGTYPE_p_sqlite3 db = this.getHandle();
            SQLite3.sqlite3_clear_progress_handler(db, this.progressHandler);
            this.progressHandler = null;
        }
    }

    public void setCommitHook(CommitHook hook) {
        SWIGTYPE_p_sqlite3 db = this.getHandle();
        SQLite3.sqlite3_commit_hook(db, hook);
    }

    public void clearCommitHook() {
        SWIGTYPE_p_sqlite3 db = this.getHandle();
        SQLite3.sqlite3_clear_commit_hook(db);
    }

    public void setRollbackHook(RollbackHook hook) {
        SWIGTYPE_p_sqlite3 db = this.getHandle();
        SQLite3.sqlite3_rollback_hook(db, hook);
    }

    public void clearRollbackHook() {
        SWIGTYPE_p_sqlite3 db = this.getHandle();
        SQLite3.sqlite3_clear_rollback_hook(db);
    }

    public void setUpdateHook(UpdateHook hook) {
        SWIGTYPE_p_sqlite3 db = this.getHandle();
        SQLite3.sqlite3_update_hook(db, hook);
    }

    public void clearUpdateHook() {
        SWIGTYPE_p_sqlite3 db = this.getHandle();
        SQLite3.sqlite3_clear_update_hook(db);
    }

    public void setProfiler(Profiler profiler) {
        SWIGTYPE_p_sqlite3 db = this.getHandle();
        SQLite3.sqlite3_profile(db, profiler);
    }

    public void clearProfiler() {
        SWIGTYPE_p_sqlite3 db = this.getHandle();
        SQLite3.sqlite3_clear_profile(db);
    }

    public void setTracer(Tracer tracer) {
        SWIGTYPE_p_sqlite3 db = this.getHandle();
        SQLite3.sqlite3_trace(db, tracer);
    }

    public void clearTracer() {
        SWIGTYPE_p_sqlite3 db = this.getHandle();
        SQLite3.sqlite3_clear_trace(db);
    }

    public void enableSharedCache() throws SQLException {
        int ret = SQLite3.sqlite3_enable_shared_cache(1);
        if (ret != 0) {
            SWIGTYPE_p_sqlite3 db = this.getHandle();
            throw new JdbcSQLException(ret, db);
        }
    }

    public void disableSharedCache() throws SQLException {
        int ret = SQLite3.sqlite3_enable_shared_cache(0);
        if (ret != 0) {
            SWIGTYPE_p_sqlite3 db = this.getHandle();
            throw new JdbcSQLException(ret, db);
        }
    }

    public int getLastError() {
        SWIGTYPE_p_sqlite3 db = this.getHandle();
        return SQLite3.sqlite3_errcode(db);
    }

    public String getLastErrorMessage() {
        SWIGTYPE_p_sqlite3 db = this.getHandle();
        return SQLite3.sqlite3_errmsg(db);
    }

    public List<String[]> getTable(String sql, SWIGTYPE_p_p_char errmsg) throws SQLException {
        SWIGTYPE_p_sqlite3 db = this.getHandle();
        ArrayList<String[]> result = new ArrayList<String[]>();
        int ret = 0;
        if (this.timeout == 0) {
            while ((ret = SQLite3.sqlite3_get_table(db, sql, result, errmsg)) == 5) {
            }
        } else {
            ret = SQLite3.sqlite3_get_table(db, sql, result, errmsg);
        }
        if (ret != 0) {
            throw new JdbcSQLException(ret, db);
        }
        return result;
    }

    protected void finalize() throws Throwable {
        if (!this.isClosed()) {
            Logger.getLogger(Database.class.getName()).severe("Database connection has leaked!");
            this.close();
        }
        super.finalize();
    }

    private static class SQLite3PtrPtr
    extends SWIGTYPE_p_p_sqlite3 {
        private boolean isDeleted = false;
        private SWIGTYPE_p_sqlite3 handle;

        public SQLite3PtrPtr() {
            super(SQLite3PtrPtr.getCPtr(SQLite3.new_p_p_sqlite3()), false);
        }

        public boolean isDeleted() {
            return this.isDeleted;
        }

        public synchronized void delete() {
            if (!this.isDeleted) {
                SQLite3.delete_p_p_sqlite3(this);
                this.isDeleted = true;
                this.handle = null;
            }
        }

        public void allocateHandle() {
            if (this.isDeleted) {
                throw new IllegalStateException("SQLite3PtrPtr is already deleted.");
            }
            if (this.handle != null) {
                throw new IllegalStateException("sqlite3 handle is already allocated.");
            }
            this.handle = SQLite3.get_p_sqlite3(this);
        }

        public SWIGTYPE_p_sqlite3 getSQLite3Ptr() {
            if (this.isDeleted) {
                throw new IllegalStateException("SQLite3PtrPtr is already deleted.");
            }
            return this.handle;
        }

        protected void finalize() throws Throwable {
            this.delete();
            super.finalize();
        }
    }
}

