/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite.event;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.sqlite.Database;
import org.sqlite.callback.Callback;
import org.sqlite.jdbc.JdbcSQLException;
import org.sqlite.swig.SQLite3;
import org.sqlite.swig.SWIGTYPE_p_sqlite3;
import org.sqlite.text.Collator;

public class CollationNeededHandler
extends Callback {
    private Database database;
    private final Map<String, Collator> collators = new HashMap<String, Collator>();

    public void setDatabase(Database db) {
        this.database = db;
    }

    public Collator addCollator(Collator col) {
        return this.collators.put(col.getName().toUpperCase(), col);
    }

    public Collator removeCollator(String name) {
        return this.collators.remove(name.toUpperCase());
    }

    public Collator removeCollator(Collator col) {
        return this.removeCollator(col.getName());
    }

    protected final void xCollationNeeded(long pDb, int eTextRep, String name) throws SQLException {
        Collator col;
        if (eTextRep == 1 && (col = this.collators.get(name.toUpperCase())) != null) {
            if (this.database != null && !this.database.isClosed()) {
                this.database.createCollationSequence(col);
            } else {
                SWIGTYPE_p_sqlite3 db = SQLite3.new_p_sqlite3(pDb);
                int ret = SQLite3.sqlite3_create_collation(db, col);
                if (ret != 0) {
                    throw new JdbcSQLException(ret, db);
                }
            }
        }
    }
}

