/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite.jdbc;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.util.Map;
import org.sqlite.Database;
import org.sqlite.auth.Authorizer;
import org.sqlite.event.BusyHandler;
import org.sqlite.event.CollationNeededHandler;
import org.sqlite.event.CommitHook;
import org.sqlite.event.ProgressHandler;
import org.sqlite.event.RollbackHook;
import org.sqlite.event.UpdateHook;
import org.sqlite.jdbc.JdbcDatabaseMetaData;
import org.sqlite.jdbc.JdbcPreparedStatement;
import org.sqlite.jdbc.JdbcResultSet;
import org.sqlite.jdbc.JdbcStatement;
import org.sqlite.jdbc.TransactionType;
import org.sqlite.profiler.Profiler;
import org.sqlite.profiler.Tracer;
import org.sqlite.text.Collator;
import org.sqlite.udf.Function;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcConnection
implements Connection {
    private Database db;
    private TransactionType type;
    private final String url;

    public JdbcConnection(Database db, String url) throws SQLException {
        this.db = db;
        db.pragma(new String[]{"encoding = \"UTF-8\"", "count_changes = off", "case_sensitive_like = on", "short_column_names = on", "empty_result_callbacks = off"});
        this.url = url;
    }

    @Override
    public JdbcStatement createStatement() throws SQLException {
        this.validateConnectionOpen();
        return new JdbcStatement(this.db, this);
    }

    @Override
    public JdbcPreparedStatement prepareStatement(String sql) throws SQLException {
        this.validateConnectionOpen();
        return new JdbcPreparedStatement(this.db, this, sql);
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.validateConnectionOpen();
        if (!this.db.getAutoCommit()) {
            this.rollback();
        }
        if (!autoCommit && this.db.getAutoCommit()) {
            this.db.beginTransaction(this.type);
        }
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        this.validateConnectionOpen();
        return this.db.getAutoCommit();
    }

    @Override
    public void commit() throws SQLException {
        this.validateConnectionOpen();
        if (this.db.getAutoCommit()) {
            throw new SQLException("Connection is auto commit mode.", "90J10");
        }
        this.db.commitTransaction();
    }

    @Override
    public void rollback() throws SQLException {
        this.validateConnectionOpen();
        if (this.db.getAutoCommit()) {
            throw new SQLException("Connection is auto commit mode.", "90J10");
        }
        this.db.rollbackTransaction();
    }

    @Override
    public void close() throws SQLException {
        if (!this.isClosed()) {
            if (!this.db.getAutoCommit()) {
                this.rollback();
            }
            this.db.close();
            this.db = null;
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.db == null || this.db.isClosed();
    }

    @Override
    public JdbcDatabaseMetaData getMetaData() throws SQLException {
        return new JdbcDatabaseMetaData(this.db, this, this.url);
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.validateConnectionOpen();
        if (!this.db.getAutoCommit()) {
            throw new SQLException("Connection is transaction mode.", "90J11");
        }
        if (readOnly) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        this.validateConnectionOpen();
        return this.db.isReadOnly();
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.validateConnectionOpen();
    }

    @Override
    public String getCatalog() throws SQLException {
        this.validateConnectionOpen();
        return null;
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.validateConnectionOpen();
        if (level != 8) {
            throw new SQLException("Not supported isolation level.", "90J20");
        }
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        this.validateConnectionOpen();
        return 8;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.validateConnectionOpen();
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.validateConnectionOpen();
    }

    @Override
    public JdbcStatement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        JdbcResultSet.validateResultSetType(resultSetType);
        JdbcResultSet.validateResultSetConcurrency(resultSetConcurrency);
        this.validateConnectionOpen();
        if (resultSetType != 1003) {
            throw new SQLException("Not supported result set type.", "90J24");
        }
        if (resultSetConcurrency != 1007) {
            throw new SQLException("Not supported result set concurrency.", "90J25");
        }
        return new JdbcStatement(this.db, this);
    }

    @Override
    public JdbcPreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        JdbcResultSet.validateResultSetType(resultSetType);
        JdbcResultSet.validateResultSetConcurrency(resultSetConcurrency);
        this.validateConnectionOpen();
        if (resultSetType != 1003) {
            throw new SQLException("Not supported result set type.", "90J24");
        }
        if (resultSetConcurrency != 1007) {
            throw new SQLException("Not supported result set concurrency.", "90J25");
        }
        return new JdbcPreparedStatement(this.db, this, sql);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.validateConnectionOpen();
        if (holdability != 2) {
            throw new SQLException("Not supported result set holdability.", "90J21");
        }
    }

    @Override
    public int getHoldability() throws SQLException {
        this.validateConnectionOpen();
        return 2;
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public JdbcStatement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        JdbcResultSet.validateResultSetType(resultSetType);
        JdbcResultSet.validateResultSetConcurrency(resultSetConcurrency);
        JdbcResultSet.validateResultSetHoldability(resultSetHoldability);
        this.validateConnectionOpen();
        if (resultSetType != 1003) {
            throw new SQLException("Not supported result set type.", "90J24");
        }
        if (resultSetConcurrency != 1007) {
            throw new SQLException("Not supported result set concurrency.", "90J25");
        }
        if (resultSetHoldability != 2) {
            throw new SQLException("Not supported result set holdability.", "90J21");
        }
        return new JdbcStatement(this.db, this);
    }

    @Override
    public JdbcPreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        JdbcResultSet.validateResultSetType(resultSetType);
        JdbcResultSet.validateResultSetConcurrency(resultSetConcurrency);
        JdbcResultSet.validateResultSetHoldability(resultSetHoldability);
        this.validateConnectionOpen();
        if (resultSetType != 1003) {
            throw new SQLException("Not supported result set type.", "90J24");
        }
        if (resultSetConcurrency != 1007) {
            throw new SQLException("Not supported result set concurrency.", "90J25");
        }
        if (resultSetHoldability != 2) {
            throw new SQLException("Not supported result set holdability.", "90J21");
        }
        return new JdbcPreparedStatement(this.db, this, sql);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public JdbcPreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        JdbcStatement.validateAutoGeneretedKeys(autoGeneratedKeys);
        this.validateConnectionOpen();
        return new JdbcPreparedStatement(this.db, this, sql);
    }

    @Override
    public JdbcPreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public JdbcPreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    protected void validateConnectionOpen() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Connection is already closed.", "90007");
        }
    }

    public void setTransactionType(TransactionType type) throws SQLException {
        this.validateConnectionOpen();
        this.type = type;
    }

    public TransactionType getTransactionType() throws SQLException {
        this.validateConnectionOpen();
        return this.type;
    }

    public void createFunction(Function func) throws SQLException {
        this.validateConnectionOpen();
        this.db.createFunction(func);
    }

    public void dropFunction(Function func) throws SQLException {
        this.validateConnectionOpen();
        this.db.dropFunction(func);
    }

    public void dropFunction(String name) throws SQLException {
        this.validateConnectionOpen();
        this.db.dropFunction(name);
    }

    public void createCollationSequence(Collator col) throws SQLException {
        this.validateConnectionOpen();
        this.db.createCollationSequence(col);
    }

    public void dropCollationSequence(Collator col) throws SQLException {
        this.validateConnectionOpen();
        this.db.dropCollationSequence(col);
    }

    public void dropCollationSequence(String name) throws SQLException {
        this.validateConnectionOpen();
        this.db.dropCollationSequence(name);
    }

    public void setAuthorizer(Authorizer auth) throws SQLException {
        this.validateConnectionOpen();
        this.db.setAuthorizer(auth);
    }

    public void clearAuthorizer() throws SQLException {
        this.validateConnectionOpen();
        this.db.clearAuthorizer();
    }

    public void setBusyTimeout(int ms) throws SQLException {
        this.validateConnectionOpen();
        this.db.setBusyTimeout(ms);
    }

    public int getBusyTimeout() throws SQLException {
        this.validateConnectionOpen();
        return this.db.getBusyTimeout();
    }

    public void setBusyHandler(BusyHandler busy) throws SQLException {
        this.validateConnectionOpen();
        this.db.setBusyHandler(busy);
    }

    public void clearBusyHandler() throws SQLException {
        this.validateConnectionOpen();
        this.db.clearBusyHandler();
    }

    public void setCollationNeededHandler(CollationNeededHandler needed) throws SQLException {
        this.validateConnectionOpen();
        this.db.setCollationNeededHandler(needed);
    }

    public void clearCollationNeededHandler() throws SQLException {
        this.validateConnectionOpen();
        this.db.clearCollationNeededHandler();
    }

    public void setProgressHandler(ProgressHandler prog) throws SQLException {
        this.validateConnectionOpen();
        this.db.setProgressHandler(prog);
    }

    public void clearProgressHandler() throws SQLException {
        this.validateConnectionOpen();
        this.db.clearProgressHandler();
    }

    public void setCommitHook(CommitHook hook) throws SQLException {
        this.validateConnectionOpen();
        this.db.setCommitHook(hook);
    }

    public void clearCommitHook() throws SQLException {
        this.validateConnectionOpen();
        this.db.clearCommitHook();
    }

    public void setRollbackHook(RollbackHook hook) throws SQLException {
        this.validateConnectionOpen();
        this.db.setRollbackHook(hook);
    }

    public void clearRollbackHook() throws SQLException {
        this.validateConnectionOpen();
        this.db.clearRollbackHook();
    }

    public void setUpdateHook(UpdateHook hook) throws SQLException {
        this.validateConnectionOpen();
        this.db.setUpdateHook(hook);
    }

    public void clearUpdateHook() throws SQLException {
        this.validateConnectionOpen();
        this.db.clearUpdateHook();
    }

    public void setProfiler(Profiler profiler) throws SQLException {
        this.validateConnectionOpen();
        this.db.setProfiler(profiler);
    }

    public void clearProfiler() throws SQLException {
        this.validateConnectionOpen();
        this.db.clearProfiler();
    }

    public void setTracer(Tracer tracer) throws SQLException {
        this.validateConnectionOpen();
        this.db.setTracer(tracer);
    }

    public void clearTracer() throws SQLException {
        this.validateConnectionOpen();
        this.db.clearTracer();
    }
}

