/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.MathContext;
import java.net.URL;
import java.sql.Array;
import java.sql.BatchUpdateException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.sqlite.Database;
import org.sqlite.Statement;
import org.sqlite.jdbc.JdbcConnection;
import org.sqlite.jdbc.JdbcParameterMetaData;
import org.sqlite.jdbc.JdbcResultSet;
import org.sqlite.jdbc.JdbcResultSetMetaData;
import org.sqlite.jdbc.JdbcStatement;
import org.sqlite.swig.SQLite3;
import org.sqlite.types.SQLite3StmtPtrPtr;

public class JdbcPreparedStatement
extends JdbcStatement
implements PreparedStatement {
    private final String sql;
    private SQLite3StmtPtrPtr pStmt = new SQLite3StmtPtrPtr();
    private Statement stmt;
    private List<Statement> batch;

    public JdbcPreparedStatement(Database db, JdbcConnection conn, String sql) throws SQLException {
        super(db, conn);
        this.stmt = db.prepare(sql, this.pStmt);
        this.sql = sql;
    }

    public ResultSet executeQuery() throws SQLException {
        if (!this.execute()) {
            throw new SQLException("No ResultSet was produced.", "02000");
        }
        return this.rs;
    }

    public int executeUpdate() throws SQLException {
        if (this.execute()) {
            throw new SQLException("ResultSet was produced.", "02001");
        }
        return this.cntUpdate;
    }

    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.validateStatementOpen();
        this.stmt.bindNull(parameterIndex);
    }

    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.validateStatementOpen();
        this.stmt.bindInt(parameterIndex, x ? 1 : 0);
    }

    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.validateStatementOpen();
        this.stmt.bindInt(parameterIndex, x);
    }

    public void setShort(int parameterIndex, short x) throws SQLException {
        this.validateStatementOpen();
        this.stmt.bindInt(parameterIndex, x);
    }

    public void setInt(int parameterIndex, int x) throws SQLException {
        this.validateStatementOpen();
        this.stmt.bindInt(parameterIndex, x);
    }

    public void setLong(int parameterIndex, long x) throws SQLException {
        this.validateStatementOpen();
        this.stmt.bindLong(parameterIndex, x);
    }

    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.validateStatementOpen();
        this.stmt.bindDouble(parameterIndex, x);
    }

    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.validateStatementOpen();
        this.stmt.bindDouble(parameterIndex, x);
    }

    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.validateStatementOpen();
        this.stmt.bindText(parameterIndex, x.toString());
    }

    public void setString(int parameterIndex, String x) throws SQLException {
        this.validateStatementOpen();
        if (x != null) {
            this.stmt.bindText(parameterIndex, x);
        } else {
            this.stmt.bindNull(parameterIndex);
        }
    }

    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.validateStatementOpen();
        if (x != null) {
            this.stmt.bindBytes(parameterIndex, x);
        } else {
            this.stmt.bindNull(parameterIndex);
        }
    }

    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.validateStatementOpen();
        if (x != null) {
            this.stmt.bindText(parameterIndex, SQLite3.format(x));
        } else {
            this.stmt.bindNull(parameterIndex);
        }
    }

    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.validateStatementOpen();
        if (x != null) {
            this.stmt.bindText(parameterIndex, SQLite3.format(x));
        } else {
            this.stmt.bindNull(parameterIndex);
        }
    }

    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.validateStatementOpen();
        if (x != null) {
            this.stmt.bindText(parameterIndex, SQLite3.format(x));
        } else {
            this.stmt.bindNull(parameterIndex);
        }
    }

    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void clearParameters() throws SQLException {
        this.validateStatementOpen();
        this.stmt.clearBinding();
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        JdbcPreparedStatement.validateSqlType(targetSqlType);
        if (targetSqlType == 3 || targetSqlType == 2) {
            if (x instanceof Float) {
                x = Float.valueOf(new BigDecimal(((Number)x).floatValue(), MathContext.DECIMAL64).setScale(scaleOrLength).floatValue());
            } else if (x instanceof Double) {
                x = Float.valueOf(new BigDecimal(((Number)x).doubleValue(), MathContext.DECIMAL64).setScale(scaleOrLength).floatValue());
            } else if (x instanceof BigDecimal) {
                x = ((BigDecimal)x).setScale(scaleOrLength);
            }
        }
        this.setObject(parameterIndex, x);
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        JdbcPreparedStatement.validateSqlType(targetSqlType);
        this.setObject(parameterIndex, x, 0);
    }

    public void setObject(int parameterIndex, Object x) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex, 0);
        } else if (x instanceof Boolean) {
            this.setBoolean(parameterIndex, (boolean)((Boolean)x));
        } else if (x instanceof Byte) {
            this.setByte(parameterIndex, ((Number)x).byteValue());
        } else if (x instanceof Short) {
            this.setShort(parameterIndex, ((Number)x).shortValue());
        } else if (x instanceof Integer) {
            this.setInt(parameterIndex, ((Number)x).intValue());
        } else if (x instanceof Long) {
            this.setLong(parameterIndex, ((Number)x).longValue());
        } else if (x instanceof Float) {
            this.setFloat(parameterIndex, ((Number)x).floatValue());
        } else if (x instanceof Double) {
            this.setDouble(parameterIndex, ((Number)x).doubleValue());
        } else if (x instanceof BigDecimal) {
            this.setBigDecimal(parameterIndex, (BigDecimal)x);
        } else if (x instanceof Number) {
            this.setString(parameterIndex, String.valueOf(x));
        } else if (x instanceof Timestamp) {
            this.setTimestamp(parameterIndex, (Timestamp)x);
        } else if (x instanceof Time) {
            this.setTime(parameterIndex, (Time)x);
        } else if (x instanceof Date) {
            this.setDate(parameterIndex, (Date)x);
        } else if (x instanceof String) {
            this.setString(parameterIndex, (String)x);
        } else if (x instanceof byte[]) {
            this.setBytes(parameterIndex, (byte[])x);
        }
        throw new UnsupportedOperationException("Not supported object.");
    }

    public boolean execute() throws SQLException {
        this.validateStatementOpen();
        if (this.stmt.producedResultSet()) {
            this.rs = new JdbcResultSet(this, this.stmt);
            this.cntUpdate = -1;
        } else {
            this.stmt.execute();
            this.cntUpdate = this.db.changes();
            this.rs = null;
            this.stmt.reset();
        }
        return this.rs != null;
    }

    public void addBatch() throws SQLException {
        this.validateStatementOpen();
        if (this.stmt.getParameterCount() == 0) {
            super.addBatch(this.sql);
        } else {
            if (this.batch == null) {
                this.batch = new ArrayList<Statement>();
            }
            this.batch.add(this.stmt);
            this.stmt = this.db.prepare(this.sql, this.pStmt);
            this.stmt.reset();
            this.rs = null;
        }
    }

    public void clearBatch() throws SQLException {
        super.clearBatch();
        if (this.batch != null) {
            for (Statement s : this.batch) {
                s.close();
            }
            this.batch = null;
        }
    }

    public int[] executeBatch() throws SQLException {
        this.validateStatementOpen();
        if (this.stmt.getParameterCount() == 0) {
            return super.executeBatch();
        }
        if (this.batch == null) {
            return new int[0];
        }
        int size = this.batch.size();
        int[] ret = new int[size];
        BatchUpdateException ex = null;
        for (int i = 0; i < size; ++i) {
            try {
                ret[i] = JdbcPreparedStatement.executeUpdate(this.batch.get(i));
            }
            catch (SQLException ex2) {
                if (ex == null) {
                    ex = new BatchUpdateException(ex2.getMessage(), ex2.getSQLState(), ex2.getErrorCode(), ret);
                }
                ret[i] = -3;
            }
            this.cntUpdate = ret[i];
            this.rs = null;
        }
        if (ex != null) {
            throw ex;
        }
        return ret;
    }

    public void setCharacterStream(int parameterIndex, Reader x, int length) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setRef(int parameterIndex, Ref x) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setClob(int parameterIndex, Clob x) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setArray(int parameterIndex, Array x) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public JdbcResultSetMetaData getMetaData() throws SQLException {
        return new JdbcResultSetMetaData(this.stmt);
    }

    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        Calendar calendar = (Calendar)cal.clone();
        calendar.setTime(x);
        this.setDate(parameterIndex, new Date(calendar.getTime().getTime()));
    }

    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        Calendar calendar = (Calendar)cal.clone();
        calendar.setTime(x);
        this.setTime(parameterIndex, new Time(calendar.getTime().getTime()));
    }

    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        Calendar calendar = (Calendar)cal.clone();
        calendar.setTime(x);
        this.setTimestamp(parameterIndex, new Timestamp(calendar.getTime().getTime()));
    }

    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.setNull(parameterIndex, sqlType);
    }

    public void setURL(int parameterIndex, URL x) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public JdbcParameterMetaData getParameterMetaData() throws SQLException {
        return new JdbcParameterMetaData(this.stmt);
    }

    public boolean isClosed() throws SQLException {
        return this.pStmt == null || super.isClosed();
    }

    public void close() throws SQLException {
        if (this.pStmt != null) {
            if (this.stmt != null) {
                this.stmt.close();
                this.stmt = null;
            }
            this.pStmt.delete();
            this.pStmt = null;
        }
        super.close();
    }

    public void detach(ResultSet drs) throws SQLException {
        this.validateStatementOpen();
        if (this.rs != null && drs.getStatement() == this) {
            this.rs = null;
            this.stmt = this.db.prepare(this.sql, this.pStmt);
            this.stmt.reset();
        }
    }

    public void close(ResultSet drs) throws SQLException {
        this.validateStatementOpen();
        if (this.rs != null && drs.getStatement() == this) {
            this.rs = null;
            this.stmt = null;
            this.close();
        }
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    public int findParameter(String parameterName) throws SQLException {
        this.validateStatementOpen();
        int parameterIndex = this.stmt.getParameterIndex(parameterName);
        if (parameterIndex == 0) {
            throw new SQLException("Not found parameter '" + parameterName + "'.", "42S23");
        }
        return parameterIndex;
    }

    public void setNull(String parameterName, int sqlType) throws SQLException {
        this.setNull(this.findParameter(parameterName), sqlType);
    }

    public void setBoolean(String parameterName, boolean x) throws SQLException {
        this.setBoolean(this.findParameter(parameterName), x);
    }

    public void setByte(String parameterName, byte x) throws SQLException {
        this.setByte(this.findParameter(parameterName), x);
    }

    public void setShort(String parameterName, short x) throws SQLException {
        this.setShort(this.findParameter(parameterName), x);
    }

    public void setInt(String parameterName, int x) throws SQLException {
        this.setInt(this.findParameter(parameterName), x);
    }

    public void setLong(String parameterName, long x) throws SQLException {
        this.setLong(this.findParameter(parameterName), x);
    }

    public void setFloat(String parameterName, float x) throws SQLException {
        this.setFloat(this.findParameter(parameterName), x);
    }

    public void setDouble(String parameterName, double x) throws SQLException {
        this.setDouble(this.findParameter(parameterName), x);
    }

    public void setBigDecimal(String parameterName, BigDecimal x) throws SQLException {
        this.setBigDecimal(this.findParameter(parameterName), x);
    }

    public void setString(String parameterName, String x) throws SQLException {
        this.setString(this.findParameter(parameterName), x);
    }

    public void setBytes(String parameterName, byte[] x) throws SQLException {
        this.setBytes(this.findParameter(parameterName), x);
    }

    public void setDate(String parameterName, Date x) throws SQLException {
        this.setDate(this.findParameter(parameterName), x);
    }

    public void setTime(String parameterName, Time x) throws SQLException {
        this.setTime(this.findParameter(parameterName), x);
    }

    public void setTimestamp(String parameterName, Timestamp x) throws SQLException {
        this.setTimestamp(this.findParameter(parameterName), x);
    }

    public void setBlob(String parameterName, Blob x) throws SQLException {
        this.setBlob(this.findParameter(parameterName), x);
    }

    public void setDate(String parameterName, Date x, Calendar cal) throws SQLException {
        this.setDate(this.findParameter(parameterName), x, cal);
    }

    public void setTime(String parameterName, Time x, Calendar cal) throws SQLException {
        this.setTime(this.findParameter(parameterName), x, cal);
    }

    public void setTimestamp(String parameterName, Timestamp x, Calendar cal) throws SQLException {
        this.setTimestamp(this.findParameter(parameterName), x, cal);
    }

    public String findParameterName(int parameterIndex) throws SQLException {
        this.validateStatementOpen();
        return this.stmt.getParameterName(parameterIndex);
    }

    public static void validateSqlType(int sqlType) throws SQLException {
        if (sqlType != 2003 && sqlType != -5 && sqlType != -2 && sqlType != -7 && sqlType != 2004 && sqlType != 16 && sqlType != 1 && sqlType != 2005 && sqlType != 70 && sqlType != 91 && sqlType != 3 && sqlType != 2001 && sqlType != 8 && sqlType != 6 && sqlType != 4 && sqlType != 2000 && sqlType != -4 && sqlType != -1 && sqlType != 0 && sqlType != 2 && sqlType != 1111 && sqlType != 7 && sqlType != 2006 && sqlType != 5 && sqlType != 2002 && sqlType != 92 && sqlType != 93 && sqlType != -6 && sqlType != -3 && sqlType != 12) {
            throw new SQLException("Not supported sql types.", "90J22");
        }
    }

    protected static int executeUpdate(Statement stmt) throws SQLException {
        if (stmt.producedResultSet()) {
            throw new SQLException("ResultSet was produced.", "02001");
        }
        stmt.execute();
        Database db = stmt.getDatabase();
        int cntUpdate = db.changes();
        stmt.reset();
        return cntUpdate;
    }
}

