/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.sqlite.Blob;
import org.sqlite.Statement;
import org.sqlite.auth.Authorizer;
import org.sqlite.callback.Callback;
import org.sqlite.callback.ExecCallback;
import org.sqlite.event.BusyHandler;
import org.sqlite.event.CollationNeededHandler;
import org.sqlite.event.CommitHook;
import org.sqlite.event.ProgressHandler;
import org.sqlite.event.RollbackHook;
import org.sqlite.event.UpdateHook;
import org.sqlite.io.Closeable;
import org.sqlite.jdbc.JdbcSQLException;
import org.sqlite.jdbc.TransactionType;
import org.sqlite.profiler.Profiler;
import org.sqlite.profiler.Tracer;
import org.sqlite.schema.ColumnMetaData;
import org.sqlite.swig.SQLite3;
import org.sqlite.swig.SWIGTYPE_p_int;
import org.sqlite.swig.SWIGTYPE_p_p_char;
import org.sqlite.swig.SWIGTYPE_p_sqlite3;
import org.sqlite.swig.SWIGTYPE_p_sqlite3_vfs;
import org.sqlite.swig.SWIGTYPE_p_void;
import org.sqlite.text.Collator;
import org.sqlite.udf.Function;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Database
implements Closeable {
    protected final Map<String, String> info;
    private final boolean isInMemory;
    private final SQLite3.SQLite3PtrPtr ppDb;
    private final boolean isReadOnly;
    private List<Closeable> handles;
    private List<Function> functions;
    private Authorizer authorizer;
    private BusyHandler busyHandler;
    private CollationNeededHandler collNeeded;
    private ProgressHandler progressHandler;
    private int timeout;

    public Database(String filename, Map<String, String> info) throws SQLException {
        this.info = info;
        this.isInMemory = filename == null || SQLite3.getInMemoryFileName().equals(filename);
        this.ppDb = new SQLite3.SQLite3PtrPtr();
        if (info != null) {
            if (info.containsKey("TEMP_DIR")) {
                SQLite3.set_sqlite3_temp_directory(info.get("TEMP_DIR"));
            }
            this.isReadOnly = info.containsKey("READ_ONLY");
        } else {
            this.isReadOnly = false;
        }
        this.open(filename);
        if (info != null && !info.isEmpty()) {
            StringBuilder pragmas = new StringBuilder();
            for (String key : info.keySet()) {
                if (!key.startsWith("PRAGMA")) continue;
                pragmas.append(key);
                String value = info.get(key);
                if (value.length() != 0) {
                    pragmas.append("=").append(value);
                }
                pragmas.append(";");
            }
            if (pragmas.length() != 0) {
                this.execute(pragmas.toString());
            }
        }
    }

    public static String getProductName() {
        return "SQLite";
    }

    public boolean isInMemoryMode() {
        return this.isInMemory;
    }

    SWIGTYPE_p_sqlite3 getHandle() {
        return this.ppDb.getSQLite3Ptr();
    }

    protected void open(String filename) throws SQLException {
        int ret = 0;
        if (this.info == null) {
            ret = SQLite3.sqlite3_open(filename, this.ppDb);
        } else {
            int flag = this.isReadOnly ? 1 : (this.info.containsKey("OPEN_EXIST") ? 2 : 6);
            String vfs = this.info.get("VFS");
            ret = SQLite3.sqlite3_open_v2(filename, this.ppDb, flag, vfs);
        }
        this.ppDb.allocateHandle();
        if (ret != 0) {
            SWIGTYPE_p_sqlite3 db = this.getHandle();
            JdbcSQLException ex = new JdbcSQLException(ret, db);
            this.ppDb.delete();
            throw ex;
        }
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    @Override
    public boolean isClosed() {
        return this.ppDb.isDeleted();
    }

    @Override
    public void close() throws SQLException {
        if (!this.isClosed()) {
            this.closeHandles();
            this.clearCallbacks();
            SWIGTYPE_p_sqlite3 db = this.getHandle();
            int ret = SQLite3.sqlite3_close(db);
            if (ret != 0) {
                throw new JdbcSQLException(ret, db);
            }
            this.ppDb.delete();
            this.deleteCallbacks();
            if (this.info != null && this.info.containsKey("TEMP_DIR")) {
                SQLite3.set_sqlite3_temp_directory(null);
            }
        }
    }

    public boolean getAutoCommit() {
        return SQLite3.sqlite3_get_autocommit(this.getHandle()) != 0;
    }

    public void setBusyTimeout(int ms) throws SQLException {
        this.clearBusyHandler();
        SWIGTYPE_p_sqlite3 db = this.getHandle();
        int ret = SQLite3.sqlite3_busy_timeout(db, ms);
        if (ret != 0) {
            throw new JdbcSQLException(ret, db);
        }
        this.timeout = ms < 1 ? 0 : ms;
    }

    public int getBusyTimeout() {
        return this.timeout;
    }

    public void execute(String sql) throws SQLException {
        this.execute(sql, null, null);
    }

    public void execute(String sql, ExecCallback callback, SWIGTYPE_p_p_char errmsg) throws SQLException {
        SWIGTYPE_p_sqlite3 db = this.getHandle();
        int ret = 0;
        while ((ret = SQLite3.sqlite3_exec(db, sql, callback, errmsg)) == 5 && this.timeout == 0) {
        }
        if (ret != 0) {
            throw new JdbcSQLException(ret, db);
        }
    }

    public void pragma(String[] commands) throws SQLException {
        StringBuilder sql = new StringBuilder();
        for (String cmd : commands) {
            sql.append("PRAGMA ").append(cmd).append(";");
        }
        this.execute(sql.toString());
    }

    public void beginTransaction(TransactionType type) throws SQLException {
        this.closeHandles();
        if (type == null) {
            this.execute("BEGIN");
        } else {
            this.execute("BEGIN " + (Object)((Object)type));
        }
    }

    public void commitTransaction() throws SQLException {
        this.closeHandles();
        this.execute("COMMIT");
    }

    public void rollbackTransaction() throws SQLException {
        this.closeHandles();
        this.execute("ROLLBACK");
    }

    public Statement prepare(String sql, SQLite3.SQLite3StmtPtrPtr ppStmt) throws SQLException {
        if (sql == null) {
            throw new NullPointerException("sql is null.");
        }
        if (ppStmt == null) {
            throw new NullPointerException("ppStmt is null.");
        }
        SWIGTYPE_p_sqlite3 db = this.getHandle();
        int ret = SQLite3.sqlite3_prepare(db, sql, -1, ppStmt, null);
        if (ret != 0) {
            throw new JdbcSQLException(ret, db);
        }
        return new Statement(this, ppStmt.getSQLite3StmtPtr());
    }

    public Statement prepare(String sql) throws SQLException {
        SQLite3.SQLite3StmtPtrPtr ppStmt;
        if (sql == null) {
            throw new NullPointerException("sql is null.");
        }
        SWIGTYPE_p_sqlite3 db = this.getHandle();
        int ret = SQLite3.sqlite3_prepare(db, sql, -1, ppStmt = new SQLite3.SQLite3StmtPtrPtr(), null);
        if (ret != 0) {
            ppStmt.delete();
            throw new JdbcSQLException(ret, db);
        }
        return new Statement(this, ppStmt);
    }

    public List<Statement> prepareMultiple(String sql) throws SQLException {
        if (sql == null) {
            throw new NullPointerException("sql is null.");
        }
        SWIGTYPE_p_sqlite3 db = this.getHandle();
        ArrayList<SQLite3.SQLite3StmtPtrPtr> stmts = new ArrayList<SQLite3.SQLite3StmtPtrPtr>();
        String[] tail = new String[1];
        do {
            SQLite3.SQLite3StmtPtrPtr ppStmt = new SQLite3.SQLite3StmtPtrPtr();
            stmts.add(ppStmt);
            int ret = SQLite3.sqlite3_prepare(db, sql, -1, ppStmt, tail);
            if (ret == 0) continue;
            for (SQLite3.SQLite3StmtPtrPtr stmt : stmts) {
                stmt.delete();
            }
            throw new JdbcSQLException(ret, db);
        } while ((sql = tail[0].trim()).length() > 0);
        ArrayList<Statement> ret = new ArrayList<Statement>(stmts.size());
        for (SQLite3.SQLite3StmtPtrPtr stmt : stmts) {
            ret.add(new Statement(this, stmt));
        }
        return ret;
    }

    public void interrupt() {
        SQLite3.sqlite3_interrupt(this.getHandle());
    }

    public int changes() {
        return SQLite3.sqlite3_changes(this.getHandle());
    }

    public int totalChanges() {
        return SQLite3.sqlite3_total_changes(this.getHandle());
    }

    public long lastInsertRowId() {
        return SQLite3.sqlite3_last_insert_rowid(this.getHandle());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ColumnMetaData getColumnMetaData(String dbName, String tableName, String columnName) throws SQLException {
        SWIGTYPE_p_sqlite3 db = this.getHandle();
        SWIGTYPE_p_p_char dataType = null;
        SWIGTYPE_p_p_char collSeq = null;
        SWIGTYPE_p_int notNull = null;
        SWIGTYPE_p_int primaryKey = null;
        SWIGTYPE_p_int autoInc = null;
        try {
            dataType = SQLite3.new_p_p_char();
            collSeq = SQLite3.new_p_p_char();
            notNull = SQLite3.new_p_int();
            primaryKey = SQLite3.new_p_int();
            autoInc = SQLite3.new_p_int();
            int ret = SQLite3.sqlite3_table_column_metadata(db, dbName, tableName, columnName, dataType, collSeq, notNull, primaryKey, autoInc);
            if (ret != 0) {
                throw new JdbcSQLException(ret, db);
            }
            ColumnMetaData columnMetaData = new ColumnMetaData(SQLite3.get_p_char(dataType), SQLite3.get_p_char(collSeq), SQLite3.get_int(notNull), SQLite3.get_int(primaryKey), SQLite3.get_int(autoInc));
            return columnMetaData;
        }
        finally {
            if (dataType != null) {
                SQLite3.delete_p_p_char(dataType);
            }
            if (collSeq != null) {
                SQLite3.delete_p_p_char(collSeq);
            }
            if (notNull != null) {
                SQLite3.delete_p_int(notNull);
            }
            if (primaryKey != null) {
                SQLite3.delete_p_int(primaryKey);
            }
            if (autoInc != null) {
                SQLite3.delete_p_int(autoInc);
            }
        }
    }

    void add(Closeable handle) {
        if (this.handles == null) {
            this.handles = new ArrayList<Closeable>();
        }
        if (this.handles.contains(handle)) {
            throw new IllegalArgumentException("handle is already exist.");
        }
        this.handles.add(handle);
    }

    void remove(Closeable handle) {
        if (this.handles != null && !this.handles.remove(handle)) {
            throw new IllegalArgumentException("handle is not exist.");
        }
    }

    private void closeHandles() {
        if (this.handles != null) {
            List<Closeable> list = this.handles;
            this.handles = null;
            for (Closeable handle : list) {
                try {
                    handle.close();
                }
                catch (SQLException ex) {
                    Logger.getLogger(Database.class.getName()).info(ex.toString());
                }
            }
        }
    }

    private void clearCallbacks() {
        this.clearCommitHook();
        this.clearProfiler();
        this.clearRollbackHook();
        this.clearTracer();
        this.clearUpdateHook();
    }

    private void deleteCallbacks() {
        ArrayList<Callback> callbacks = new ArrayList<Callback>();
        if (this.functions != null) {
            callbacks.addAll(this.functions);
            this.functions = null;
        }
        if (this.authorizer != null) {
            callbacks.add(this.authorizer);
            this.authorizer = null;
        }
        if (this.busyHandler != null) {
            callbacks.add(this.busyHandler);
            this.busyHandler = null;
        }
        if (this.collNeeded != null) {
            callbacks.add(this.collNeeded);
            this.collNeeded = null;
        }
        if (this.progressHandler != null) {
            callbacks.add(this.progressHandler);
            this.progressHandler = null;
        }
        for (Callback callback : callbacks) {
            callback.delete();
        }
    }

    public void createFunction(Function func) throws SQLException {
        func.register(this.getHandle());
        if (this.functions == null) {
            this.functions = new ArrayList<Function>();
        }
        this.functions.add(func);
    }

    public void dropFunction(Function func) throws SQLException {
        func.unregister(this.getHandle());
        if (this.functions != null) {
            this.functions.remove(func);
        }
    }

    public void createCollationSequence(Collator col) throws SQLException {
        col.register(this.getHandle());
    }

    public void dropCollationSequence(Collator col) throws SQLException {
        col.unregister(this.getHandle());
    }

    public void setAuthorizer(Authorizer auth) throws SQLException {
        this.clearAuthorizer();
        auth.register(this.getHandle());
        this.authorizer = auth;
    }

    public void clearAuthorizer() throws SQLException {
        if (this.authorizer != null) {
            this.authorizer.unregister(this.getHandle());
            this.authorizer = null;
        }
    }

    public void setBusyHandler(BusyHandler busy) throws SQLException {
        this.clearBusyHandler();
        busy.register(this.getHandle());
        this.busyHandler = busy;
        this.timeout = -1;
    }

    public void clearBusyHandler() throws SQLException {
        if (this.busyHandler != null) {
            this.busyHandler.unregister(this.getHandle());
            this.busyHandler = null;
        }
    }

    public void setCollationNeededHandler(CollationNeededHandler needed) throws SQLException {
        this.clearCollationNeededHandler();
        needed.register(this.getHandle());
        this.collNeeded = needed;
        this.collNeeded.setDatabase(this);
    }

    public void clearCollationNeededHandler() throws SQLException {
        if (this.collNeeded != null) {
            this.collNeeded.unregister(this.getHandle());
            this.collNeeded = null;
        }
    }

    public void setProgressHandler(ProgressHandler prog) {
        this.clearProgressHandler();
        prog.register(this.getHandle());
        this.progressHandler = prog;
    }

    public void clearProgressHandler() {
        if (this.progressHandler != null) {
            this.progressHandler.unregister(this.getHandle());
            this.progressHandler = null;
        }
    }

    public void setCommitHook(CommitHook hook) {
        hook.register(this.getHandle());
    }

    public void clearCommitHook() {
        CommitHook.clear(this.getHandle());
    }

    public void setRollbackHook(RollbackHook hook) {
        hook.register(this.getHandle());
    }

    public void clearRollbackHook() {
        RollbackHook.clear(this.getHandle());
    }

    public void setUpdateHook(UpdateHook hook) {
        hook.register(this.getHandle());
    }

    public void clearUpdateHook() {
        UpdateHook.clear(this.getHandle());
    }

    public void setProfiler(Profiler profiler) {
        profiler.register(this.getHandle());
    }

    public void clearProfiler() {
        Profiler.clear(this.getHandle());
    }

    public void setTracer(Tracer tracer) {
        tracer.register(this.getHandle());
    }

    public void clearTracer() {
        Tracer.clear(this.getHandle());
    }

    public static void enableSharedCache() throws SQLException {
        int ret = SQLite3.sqlite3_enable_shared_cache(1);
        if (ret != 0) {
            throw new JdbcSQLException(ret);
        }
    }

    public static void disableSharedCache() throws SQLException {
        int ret = SQLite3.sqlite3_enable_shared_cache(0);
        if (ret != 0) {
            throw new JdbcSQLException(ret);
        }
    }

    public int getLastError() {
        return SQLite3.sqlite3_errcode(this.getHandle());
    }

    public String getLastErrorMessage() {
        return SQLite3.sqlite3_errmsg(this.getHandle());
    }

    public List<String[]> getTable(String sql, SWIGTYPE_p_p_char errmsg) throws SQLException {
        SWIGTYPE_p_sqlite3 db = this.getHandle();
        ArrayList<String[]> result = new ArrayList<String[]>();
        int ret = 0;
        while ((ret = SQLite3.sqlite3_get_table(db, sql, result, errmsg)) == 5 && this.timeout == 0) {
        }
        if (ret != 0) {
            throw new JdbcSQLException(ret, db);
        }
        return result;
    }

    public void enableExtendedResultCodes() throws SQLException {
        SWIGTYPE_p_sqlite3 db = this.getHandle();
        int ret = SQLite3.sqlite3_extended_result_codes(db, 1);
        if (ret != 0) {
            throw new JdbcSQLException(ret, db);
        }
    }

    public void disableExtendedResultCodes() throws SQLException {
        SWIGTYPE_p_sqlite3 db = this.getHandle();
        int ret = SQLite3.sqlite3_extended_result_codes(db, 0);
        if (ret != 0) {
            throw new JdbcSQLException(ret, db);
        }
    }

    public void enableLoadExtention() throws SQLException {
        SWIGTYPE_p_sqlite3 db = this.getHandle();
        int ret = SQLite3.sqlite3_enable_load_extension(db, 1);
        if (ret != 0) {
            throw new JdbcSQLException(ret, db);
        }
    }

    public void disableLoadExtention() throws SQLException {
        SWIGTYPE_p_sqlite3 db = this.getHandle();
        int ret = SQLite3.sqlite3_enable_load_extension(db, 0);
        if (ret != 0) {
            throw new JdbcSQLException(ret, db);
        }
    }

    public void loadExtention(String filename, String entryPoint, SWIGTYPE_p_p_char errmsg) throws SQLException {
        SWIGTYPE_p_sqlite3 db = this.getHandle();
        int ret = SQLite3.sqlite3_load_extension(db, filename, entryPoint, errmsg);
        if (ret != 0) {
            throw new JdbcSQLException(ret, db);
        }
    }

    public static void resetAutoExtention() {
        SQLite3.sqlite3_reset_auto_extension();
    }

    public static boolean isThreadSafe() {
        return SQLite3.sqlite3_threadsafe() != 0;
    }

    public static long highwaterMemory(boolean reset) {
        return SQLite3.sqlite3_memory_highwater(reset ? 1 : 0);
    }

    public static long usedMemory() {
        return SQLite3.sqlite3_memory_used();
    }

    public static SWIGTYPE_p_sqlite3_vfs findVFS(String vfsName) {
        return SQLite3.sqlite3_vfs_find(vfsName);
    }

    public static void registerVFS(SWIGTYPE_p_sqlite3_vfs vfs, boolean makeDefault) throws SQLException {
        int ret = SQLite3.sqlite3_vfs_register(vfs, makeDefault ? 1 : 0);
        if (ret != 0) {
            throw new JdbcSQLException(ret);
        }
    }

    public static void unregisterVFS(SWIGTYPE_p_sqlite3_vfs vfs) throws SQLException {
        int ret = SQLite3.sqlite3_vfs_unregister(vfs);
        if (ret != 0) {
            throw new JdbcSQLException(ret);
        }
    }

    public void fileControl(String dbName, int op, SWIGTYPE_p_void arg) throws SQLException {
        SWIGTYPE_p_sqlite3 db = this.getHandle();
        int ret = SQLite3.sqlite3_file_control(db, dbName, op, arg);
        if (ret != 0) {
            throw new JdbcSQLException(ret, db);
        }
    }

    public Blob openBlob(String dbName, String tableName, String columnName, long rowId, int flag) throws SQLException {
        SQLite3.SQLite3BlobPtrPtr ppBlob;
        SWIGTYPE_p_sqlite3 db = this.getHandle();
        int ret = SQLite3.sqlite3_blob_open(db, dbName, tableName, columnName, rowId, flag, ppBlob = new SQLite3.SQLite3BlobPtrPtr());
        if (ret != 0) {
            ppBlob.delete();
            throw new JdbcSQLException(ret, db);
        }
        return new Blob(this, ppBlob);
    }

    protected void finalize() throws Throwable {
        if (!this.isClosed()) {
            Logger.getLogger(Database.class.getName()).severe("Database connection has leaked!");
            this.close();
        }
        super.finalize();
    }
}

