/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite.io;

import java.io.IOException;
import java.sql.SQLException;
import org.sqlite.Blob;
import org.sqlite.io.Closeable;
import org.sqlite.io.InputStreamAdapter;
import org.sqlite.io.WrappedIOException;

public class BlobInputStream
extends InputStreamAdapter {
    private final Blob blob;

    public BlobInputStream(Closeable owner, Blob blob) throws SQLException {
        super(owner, blob.length());
        this.blob = blob;
    }

    protected void read(long pos, byte[] b, int off, int len) throws IOException {
        try {
            if (off == 0) {
                this.blob.read(b, len, (int)pos);
            } else {
                byte[] buff = new byte[len];
                this.blob.read(buff, len, (int)pos);
                System.arraycopy(buff, 0, b, off, len);
            }
        }
        catch (SQLException ex) {
            throw new WrappedIOException(ex);
        }
    }
}

