package clib.cmd;

import java.io.*;

import clib.com.*;
import clib.bean.*;
import clib.cmd.base.*;

/**
 * ExecF
 *
 * @since     JDK1.1
 * @author    dynaworks
 */
public class ExecF extends CommandBase
{
    /**
     * R}hs
     */
    public boolean execute(ExecuteCtx ctx)
    {
        InputStream is = null;
        try
        {
            String  fname = "";
            String  command = "";
            command = getCommandString();
            if( command.startsWith("@") )
                fname = command.substring(1);
            else if( command.startsWith("@@") )
                fname = command.substring(2);

            is = new FileInputStream(new File(fname));
            ctx.createComm(this,ctx.getCommName() + "/" + fname,is,ctx.comm().getOutputStream());
            ctx.comm().setEcho(true);
            CommandSession cmnd = new CommandSession();
            cmnd.execute(ctx);
        }
        catch( Exception e )
        {
            System.err.println(e);
        }
        finally
        {
            ctx.deleteComm(this);
            try {if( is != null ) is.close();} catch(IOException e){}
        }
        return true;
    }
}
