/*
 * Decompiled with CFR 0.152.
 */
package clib.bean;

import clib.bean.CommBean;
import clib.bean.CommBeanMan;
import clib.bean.ConnBean;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class ConnBeanMan {
    static int conn_index;
    private Hashtable ctxs = new Hashtable();
    private Vector ctxs_list = new Vector();
    private String current_id = null;
    private static ConnBeanMan obj;
    static final String DEFAULT_CONNECTION_STRING = "jdbc:odbc:LocalServer";

    private ConnBeanMan() {
    }

    public static synchronized ConnBeanMan getInstance() {
        return obj;
    }

    public void openCtx(String name, String conn_info) throws SQLException {
        ConnBean conn = new ConnBean(name, conn_info);
        conn.startup(CommBeanMan.getInstance().getCurrent());
        this.setCurrentId(conn.getName());
        this.addCtx(conn);
    }

    public void openCtx(String name, String connection_string, String user_name, String pass_word) throws SQLException {
        ConnBean conn = new ConnBean(name, connection_string, user_name, pass_word);
        conn.startup(CommBeanMan.getInstance().getCurrent());
        this.setCurrentId(conn.getName());
        this.addCtx(conn);
    }

    public void setCurrentId(String current_id) {
        this.current_id = current_id;
    }

    public String getCurrentId() {
        return this.current_id;
    }

    public void closeCtx(String name) {
        this.removeCtx(name);
    }

    public void addCtx(ConnBean ctx) {
        this.ctxs.put(ctx.getName(), ctx);
        this.ctxs_list.addElement(ctx.getName());
    }

    public ConnBean getCtx(String name) {
        return (ConnBean)this.ctxs.get(name);
    }

    public ConnBean removeCtx(String name) {
        return (ConnBean)this.ctxs.remove(name);
    }

    public void shutdown() {
        try {
            Enumeration e = this.ctxs.elements();
            while (e.hasMoreElements()) {
                ((ConnBean)e.nextElement()).shutdown();
            }
        }
        catch (Exception e) {
            System.err.println(e);
            e.printStackTrace();
        }
    }

    public void clearCtx() {
        this.ctxs.clear();
    }

    public Vector getList() {
        return this.ctxs_list;
    }

    public void inputNewConn(CommBean comm, String url, String user_name, String pass_word) throws IOException, SQLException {
        if (url == null || url.length() <= 0) {
            comm.print("ConnectionString [jdbc:odbc:LocalServer]: ");
            comm.flush();
            url = comm.readLine();
            if (url.length() <= 0) {
                url = DEFAULT_CONNECTION_STRING;
            }
        }
        if (user_name == null || user_name.length() <= 0) {
            comm.print("UserName: ");
            comm.flush();
            user_name = comm.readLine();
        }
        if (pass_word == null || pass_word.length() <= 0) {
            comm.print("PassWord: ");
            comm.flush();
            pass_word = comm.readLine();
        }
        this.openCtx(String.valueOf(user_name) + "@" + url, url, user_name, pass_word);
    }

    static {
        obj = new ConnBeanMan();
    }
}

