package clib.bean;

import java.io.*;

/**
 * bZbV
 *
 * @since     JDK1.1
 * @author    dynaworks
 */
public class CommBean
{
    /** ZbV */
    protected  String       name = null;
    /** ͏ */
    protected  InputStream  cin  = null;
    /** o͏ */
    protected  OutputStream cout = null;
    /** G[o͏ */
    protected  OutputStream cerr = null;
    /** GR[ */
    protected  boolean      echo = false;

    /** BufferedReader */
    protected  BufferedReader cbr = null;
    /** PrintWriter */
    protected  PrintWriter    cpw = null;

    /** ͕GR[h */
    protected  String       in_enc = null;
    /** o͕GR[h */
    protected  String       out_enc = null;

    /*******************************************************************
     * \z
     ******************************************************************/
    public CommBean()
    {
    }

    /*******************************************************************
     * \z
     * @param name      ZbV
     ******************************************************************/
    public CommBean(String name)
    {
        this();
        setName(name);
    }

    /*******************************************************************
     * \z
     * @param name      ZbV
     * @param cin       ͏
     * @param cout      o͏
     * @param cerr      G[o͏
     ******************************************************************/
    public CommBean(String name,InputStream cin, OutputStream cout, OutputStream cerr)
    {
        this(name);
        setInputStream(cin);
        setOutputStream(cout);
        setErrorOutputStream(cerr);
    }

    /*******************************************************************
     * \z
     * @param name      ZbV
     * @param cin       ͏
     * @param cout      o͏
     ******************************************************************/
    public CommBean(String name,InputStream cin, OutputStream cout)
    {
        this(name,cin,cout,null);
    }

    /*******************************************************************
     * ͕GR[hݒ
     * @param name      ͕GR[h
     ******************************************************************/
    public void setInputEncode(String in_enc)
    {
        this.in_enc = in_enc;
    }
    /*******************************************************************
     * ͕GR[h擾
     * @return ͕GR[h
     ******************************************************************/
    public String getInputEncode()
    {
        return in_enc;
    }

    /*******************************************************************
     * o͕GR[hݒ
     * @param name      o͕GR[h
     ******************************************************************/
    public void setOutputEncode(String out_enc)
    {
        this.out_enc = out_enc;
    }
    /*******************************************************************
     * o͕GR[h擾
     * @return o͕GR[h
     ******************************************************************/
    public String getOutputEncode()
    {
        return out_enc;
    }


    /*******************************************************************
     * ZbVݒ
     * @param name      ZbV
     ******************************************************************/
    protected void setName(String name)
    {
        this.name = name;
    }
    /*******************************************************************
     * ZbV擾
     * @return ZbV
     ******************************************************************/
    public String getName()
    {
        return name;
    }

    /*******************************************************************
     * ͏ݒ
     * @param in      ͏
     ******************************************************************/
    public void setInputStream(InputStream cin)
    {
        this.cin = cin;
    }
    /*******************************************************************
     * ͏擾
     * @return ͏
     ******************************************************************/
    public InputStream getInputStream()
    {
        return cin;
    }

    /*******************************************************************
     * o͏ݒ
     * @param in      o͏
     ******************************************************************/
    public void setOutputStream(OutputStream cout)
    {
        this.cout = cout;
    }
    /*******************************************************************
     * o͏擾
     * @return o͏
     ******************************************************************/
    public OutputStream getOutputStream()
    {
        return cout;
    }

    /*******************************************************************
     * o͏ݒ
     * @param in      o͏
     ******************************************************************/
    public void setErrorOutputStream(OutputStream cerr)
    {
        this.cerr = cerr;
    }
    /*******************************************************************
     * o͏擾
     * @return o͏
     ******************************************************************/
    public OutputStream getErrorOutputStream()
    {
        return cerr;
    }

    /*******************************************************************
     * ͏擾
     * @return ͏
     ******************************************************************/
    public BufferedReader in()
    {
        return cbr;
    }

    /*******************************************************************
     * o͏擾
     * @return o͏
     ******************************************************************/
    public PrintWriter out()
    {
        return cpw;
    }

    /*******************************************************************
     * GR[ݒ
     * @param in      GR[
     ******************************************************************/
    public void setEcho(boolean echo)
    {
        this.echo = echo;
    }
    /*******************************************************************
     * GR[擾
     * @return GR[
     ******************************************************************/
    public boolean getEcho()
    {
        return echo;
    }

    /*******************************************************************
     * ̓
     * @return ͕
     * @exceptio IOException O
     ******************************************************************/
    public String readLine() throws IOException
    {
        String retp = in().readLine();
        if( echo && retp != null ) println(retp);
        return retp;
    }

    /*******************************************************************
     * ̏o
     ******************************************************************/
    public void println()
    {
        out().println();
    }

    /*******************************************************************
     * ̏o
     * @param value o͕
     ******************************************************************/
    public void println(String value)
    {
        out().println(value);
    }

    /*******************************************************************
     * ̏o
     * @param value o͕
     ******************************************************************/
    public void print(String value)
    {
        out().print(value);
    }

    /*******************************************************************
     * ̏o
     * @param value o͕
     ******************************************************************/
    public void info(String value)
    {
        out().println("INF: " + value);
    }

    /*******************************************************************
     * ̏o
     * @param value o͕
     ******************************************************************/
    public void error(String value)
    {
        out().println("ERR: " + value);
    }

    /*******************************************************************
     * obt@o
     ******************************************************************/
    public void flush()
    {
        out().flush();
    }

    /*******************************************************************
     * bZbVJn
     ******************************************************************/
    public void startup()
    {
        try
        {
            if( cpw == null )
            {
                if( out_enc == null || out_enc.length() <= 0 )
                    cpw = new PrintWriter( new BufferedWriter( new OutputStreamWriter(cout) ), true );
                else
                    cpw = new PrintWriter( new BufferedWriter( new OutputStreamWriter(cout,out_enc) ), true );
            }
            if( cbr == null )
            {
                if( in_enc == null || in_enc.length() <= 0 )
                    cbr = new BufferedReader( new InputStreamReader(cin) );
                else
                    cbr = new BufferedReader( new InputStreamReader(cin, in_enc) );
            }
        }
        catch(Exception e)
        {
            e.printStackTrace();
        }
        return;
    }

    /*******************************************************************
     * bZbVI
     ******************************************************************/
    public void shutdown()
    {
//        try{ if( cin != System.in ) cin.close(); }    catch( Exception e) {}
//        try{ if( cout != System.out ) cout.close(); } catch( Exception e) {}
    }
}
