/*
 * ********************************************************************
 * SQL-J
 * ====================================================================
 * RELEASE  DATE
 * --------------------------------------------------------------------
 * 0.1.0    2003/09/20
 * ********************************************************************
 */

import java.io.*;
import java.sql.*;

/**
 * sqlj
 */
public class sqlj
{
    final static String logo = "SQL-J Release 0.1.0";

    final static String default_driver_name  = "sun.jdbc.odbc.JdbcOdbcDriver";
    final static String default_connect_name = "jdbc:odbc:LocalServer";

    static public void  main(String[] argv)
    {
        Connection   conn    = null;
        Statement    stmt    = null;
        ResultSet    rs      = null;

        BufferedReader br = null;
        PrintWriter    pw = null;

        try
        {
            String driver_name  = null;
            String connect_name = null;

            String user_name    = null;
            String pass_word    = null;

            br = new BufferedReader( new InputStreamReader(System.in) );
            pw = new PrintWriter( new BufferedWriter( new OutputStreamWriter(System.out) ), true );
            pw.println( logo );

            pw.print("JDBCDriver [" + default_driver_name + "]: "); pw.flush(); driver_name = br.readLine();
            if( driver_name.length() <= 0 ) driver_name = default_driver_name;
            Class.forName(driver_name);
            pw.println( "Load JDBCDriver \"" + driver_name + "\"" );

            pw.print("ConnectionString [" + default_connect_name + "]: "); pw.flush(); connect_name = br.readLine();
            if( connect_name.length() <= 0 ) connect_name = default_connect_name;
            pw.print("UserName: "); pw.flush(); user_name = br.readLine();
            pw.print("PassWord: "); pw.flush(); pass_word = br.readLine();
            conn = DriverManager.getConnection( connect_name , user_name, pass_word );
            stmt = conn.createStatement();
            pw.println( "Connect Database \"" + connect_name  + "\"" );

            String sql = null;
            String command_line = null;
            while( true )
            {
                try
                {
                    String   text;
                    int      cols;
                    int      res;

                    pw.print("SQLJ> "); pw.flush();
                    command_line = br.readLine();
                    if( command_line == null ) return;
                    command_line = command_line.trim();
                    if( command_line.length() <= 0 ) continue;
                    if( command_line.toUpperCase().equals("QUIT") || command_line.toUpperCase().equals("EXIT") ) return;

                    if( command_line.toUpperCase().equals("HELP") )
                    {
                        showHelp();
                        continue;
                    }

                    sql = command_line;
                    if( sql.indexOf(";") < 0 )
                    {
                        while( (command_line = br.readLine()).indexOf(";") < 0 )
                        {
                            sql = sql + " " + command_line;
                        }
                        sql = sql + " " + command_line;
                    }
                    sql = sql.substring(0,sql.indexOf(";"));

                    stmt.clearWarnings();
                    if( sql.toUpperCase().startsWith("SELECT") )
                    {
                        ResultSetMetaData rsmd = null;

                        rs = stmt.executeQuery(sql);
                        rsmd = rs.getMetaData();
                        cols = rsmd.getColumnCount();
                        for(int i=1;i<=cols;i++)
                        {
                            text = rsmd.getColumnName(i);
                            if( i != 1 ) pw.print(",");
                            pw.print(text);
                        }
                        pw.println();

                        res = 0;
                        while( rs.next() )
                        {
                            res = res + 1;
                            for(int i=1;i<=cols;i++)
                            {
                                text = rs.getString(i);
                                if( i != 1 ) pw.print(",");
                                pw.print(text);
                            }
                            pw.println();
                        }
                        pw.println( "select " + res + " rows." );
                    }
                    else
                    {
                        res = stmt.executeUpdate( sql );
                        pw.println( "update " + res + " rows." );
                    }
                }
                catch( SQLException e )
                {
                    System.err.println(e);
                }
                finally
                {
                    try
                    {
                        if( rs != null ) rs.close();  rs = null;
                    }
                    catch( Exception e )
                    {
                        System.out.println(e);
                        e.printStackTrace();
                    }
                }
            }
        }
        catch( Exception e )
        {
            System.out.println(e);
            e.printStackTrace();
        }
        finally
        {
            try
            {
                if( stmt != null ) stmt.close();  stmt = null;
                if( conn != null ) conn.close();  conn = null;
            }
            catch( Exception e )
            {
                System.out.println(e);
                e.printStackTrace();
            }
            pw.println( "Good Bye!!" );
        }
        return;
    }

    static public void showHelp()
    {
        System.out.println(logo);
    }
}
