/*
 * Decompiled with CFR 0.152.
 */
package clib.com;

import clib.com.CommCtx;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;

public class ConnectionCtx {
    static final String DEFAULT_CONNECT_NAME = "jdbc:odbc:LocalServer";
    protected String connection_string;
    protected String user_name;
    protected String pass_word;
    protected Connection conn;
    protected Statement stmt;

    public ConnectionCtx() {
    }

    public ConnectionCtx(ConnectionCtx bean) {
    }

    public ConnectionCtx(String connection_string, String user_name, String pass_word) {
        this.connection_string = connection_string;
        this.user_name = user_name;
        this.pass_word = pass_word;
    }

    public void setConnectionString(String connection_string) {
        this.connection_string = connection_string;
    }

    public void setUserName(String user_name) {
        this.user_name = user_name;
    }

    public void setPassWord(String pass_word) {
        this.pass_word = pass_word;
    }

    public Connection getConnection() {
        return this.conn;
    }

    public Statement getStatement() throws SQLException {
        if (this.stmt == null) {
            this.stmt = this.getConnection().createStatement();
        }
        return this.stmt;
    }

    public void setConnectionInfo(String connection_info) {
        String user_name = "";
        String pass_word = "";
        String connection_string = connection_info;
        int idx = connection_string.indexOf(47);
        if (idx >= 0) {
            user_name = connection_string.substring(0, idx);
            if ((idx = (connection_string = connection_string.substring(idx + 1)).indexOf(64)) >= 0) {
                pass_word = connection_string.substring(0, idx);
                connection_string = connection_string.substring(idx + 1);
            }
        }
        this.setUserName(user_name);
        this.setPassWord(pass_word);
        this.setConnectionString(connection_string);
    }

    public void startup(CommCtx comm) throws SQLException {
        try {
            this.conn = DriverManager.getConnection(this.connection_string, this.user_name, this.pass_word);
            comm.out().println("Connect Database \"" + this.connection_string + "\"");
        }
        catch (SQLException e) {
            comm.out().println("Connect Database \"" + this.connection_string + "\" Error");
            throw e;
        }
    }

    public void shutdown() {
        try {
            if (this.stmt != null) {
                this.stmt.close();
            }
            this.stmt = null;
            if (this.conn != null) {
                this.conn.close();
            }
            this.conn = null;
        }
        catch (Exception e) {
            System.err.println(e);
            e.printStackTrace();
        }
    }

    public void cinput(CommCtx comm) throws IOException {
        comm.out().print("ConnectionString [jdbc:odbc:LocalServer]: ");
        comm.out().flush();
        String connect_info = comm.in().readLine();
        if (connect_info.length() <= 0) {
            connect_info = DEFAULT_CONNECT_NAME;
        }
        comm.out().print("UserName: ");
        comm.out().flush();
        String user_name = comm.in().readLine();
        comm.out().print("PassWord: ");
        comm.out().flush();
        String pass_word = comm.in().readLine();
        this.setConnectionString(connect_info);
        this.setUserName(user_name);
        this.setPassWord(pass_word);
    }
}

