/*
 * ********************************************************************
 * SQLC Release 0.2.1
 * ********************************************************************
 */
package clib.cmd;

import java.io.*;
import java.util.*;
import java.sql.*;
import java.text.*;

import clib.com.*;

/**
 * CmdSQLExec
 *
 * @version   1.0
 * @since     JDK1.1
 * @author    dynaworks
 */
public class CmdSQLExec extends CommandBase
{
    static DecimalFormat sqlprompt = new DecimalFormat("##0> ");

    /**
     * R}hs
     */
    public boolean execute(ExecuteCtx ctx)
    {
        ResultSet    rs      = null;
        String       command_line;
        ConnectionCtx conn = ctx.getConnectionCtx();
        CommCtx comm = ctx.getCommCtx();
        String sql = null;
        try
        {
            String   text;
            int      cols;
            int      res;
            sql = getCommandString();
            if( sql.indexOf(";") < 0 )
            {
                int i = 1,j;
                while( true )
                {
                    i++;
                    StringBuffer buf = new StringBuffer(sqlprompt.format(i));
                    j = buf.length();
                    for(;j<6;j++) buf = buf.insert(0, ' ');
                    command_line = CommandRequest.readLine(comm,buf.toString());
                    if( command_line == null ) break;
                    sql = sql + " " + command_line;
                    if(command_line.indexOf(";") >= 0) break;
                }
                sql = sql + " " + command_line;
            }
            if( sql.indexOf(";") >= 0 )
                sql = sql.substring(0,sql.indexOf(";"));

            conn.getStatement().clearWarnings();
            if( sql.toUpperCase().startsWith("SELECT") )
            {
                ResultSetMetaData rsmd = null;

                rs = conn.getStatement().executeQuery(sql);
                rsmd = rs.getMetaData();
                cols = rsmd.getColumnCount();
                for(int i=1;i<=cols;i++)
                {
                    text = rsmd.getColumnName(i);
                    if( i != 1 ) comm.out().print(",");
                    if( text != null ) comm.out().print(text);
                }
                comm.out().println();

                res = 0;
                while( rs.next() )
                {
                    res = res + 1;
                    for(int i=1;i<=cols;i++)
                    {
                        text = rs.getString(i);
                        if( i != 1 ) comm.out().print(",");
                        if( text != null ) comm.out().print(text);
                    }
                    comm.out().println();
                }
                comm.out().println( "select " + res + " rows." );
            }
            else
            {
                res = conn.getStatement().executeUpdate( sql );
                comm.out().println( "update " + res + " rows." );
            }
        }
        catch( SQLException e )
        {
            System.err.println(e);
        }
        finally
        {
            try
            {
                if( rs != null ) rs.close();  rs = null;
            }
            catch( Exception e )
            {
                System.out.println(e);
                e.printStackTrace();
            }
        }
        return true;
    }
}
