/*
 * ********************************************************************
 * SQLC Release 0.4.0
 * ********************************************************************
 */
package clib.com;

import java.io.*;
import java.util.*;
import java.sql.*;
import java.text.*;
import java.net.*;
import java.lang.reflect.*;

import clib.bean.*;

/**
 * DriverLoader
 *
 * @version   1.0
 * @since     JDK1.1
 * @author    dynaworks
 */
public class DriverLoader
{
    Vector drivers;
    Vector loaded_drivers;
    final static String DEFAULT_DRIVER_NAME  = "sun.jdbc.odbc.JdbcOdbcDriver";

    /**
     * \z
     */
    public DriverLoader()
    {
        drivers = new Vector();
        loaded_drivers = new Vector();
    }

    /**
     * 
     */
    public void addDriver(String driver_name)
    {
        String driver;
        StringTokenizer st = new StringTokenizer(driver_name,",");
        while(st.hasMoreTokens())
        {
            driver = st.nextToken();
            if( driver != null && !(driver.length() <= 0) && !drivers.contains(driver) )
                drivers.addElement(driver);
        }
    }

    /**
     * hCo̐ݒ
     */
    public String cinput(CommBean comm) throws IOException
    {
        String   driver_name;
        comm.print("JDBCDriver [" + DEFAULT_DRIVER_NAME + "]: "); comm.flush(); driver_name = comm.readLine();
        if( driver_name.length() <= 0 ) driver_name = DEFAULT_DRIVER_NAME;
        return driver_name;
    }

    /**
     * hCo̓Ǎ
     */
    public void cload(CommBean comm) throws ClassNotFoundException
    {
        String driver_name;
        String err_driver = "";
        int load_cnt = 0;
        for(Enumeration i=drivers.elements();i.hasMoreElements();)
        {
            driver_name = (String)i.nextElement();
            if( !loaded_drivers.contains(driver_name) )
            {
                try
                {
                    Class.forName(driver_name);
                    comm.out().println( "Load JDBCDriver \"" + driver_name + "\"" );
                    loaded_drivers.addElement(driver_name);
                    load_cnt++;
                }
                catch(ClassNotFoundException e)
                {
                    comm.out().println( "JDBCDriver \"" + driver_name + "\" NotFound" );
                    err_driver = err_driver + driver_name + ",";
                }
            }
        }
        if( load_cnt == 0 && err_driver.length() > 0 )
        {
            throw new ClassNotFoundException(err_driver);
        }
    }
}
