/*
 * ********************************************************************
 * SQLC Release 0.4.0
 * ====================================================================
 * RELEASE,DATE,REMARK
 * --------------------------------------------------------------------
 * 0.1.0,2003/09/20
 * 0.2.0,2003/09/27
 * 0.2.1,2003/10/04
 * 0.3.0,2003/10/11
 * ********************************************************************
 */

import java.io.*;
import java.util.*;
import java.sql.*;
import java.text.*;

import clib.com.*;
import clib.cmd.*;
import clib.bean.*;

/**
 * sqlc
 *
 * @version   Release 0.4.0
 * @since     JDK1.1
 * @author    dynaworks
 */
public class sqlc
{
    final static String LOGO = "SQLC Release Release 0.4.0";

    // *********************************
    // R}hCIvV
    // *********************************
    final static String OPTION_CONNECT_STR       = "CONN";
    final static String OPTION_DRIVER_STR        = "DRV";

    static String comm_name     = "";
    static String conn_name     = "";
    static ConnBeanMan conn_man = ConnBeanMan.getInstance();
    static CommBeanMan comm_man = CommBeanMan.getInstance();

    // hCo
    static DriverLoader drvman = new DriverLoader();

    static public void  main(String[] argv)
    {
        CommBean        comm = null;

        try
        {
            // ********************************************************
            // 
            // ********************************************************
            // ftHgbZbV\z
            comm = new CommBean( comm_name,System.in,System.out );
            comm.startup();
            comm_man.putCtx(comm);
            comm.println( LOGO );

            // **********************************
            // R}hC
            // **********************************
            CommandLineOptions opts = new CommandLineOptions(argv,'-',':');

            // **********************************
            // caڑ𓾂
            // **********************************
            // hCoݒ
            initializeDriver(opts,comm);
            // caڑݒ
            conn_name = initializeConnection(opts,comm);

            // ********************************************************
            // R}h̎s
            // ********************************************************
            ExecuteCtx ctx = new ExecuteCtx(comm_name,conn_name);
            CommandSession cmnd = new CommandSession();
            cmnd.execute(ctx);
        }
        catch( Exception e )
        {
            System.out.println(e);
            e.printStackTrace();
        }
        // ************************************************************
        // ㏈
        // ************************************************************
        finally
        {
            conn_man.shutdown();
            comm.println( "Good Bye!!" );
        }
        return;
    }

    static void initializeDriver(CommandLineOptions opts,CommBean comm) throws IOException, ClassNotFoundException
    {
        // hCo
        String driver_name = opts.getOptionString(OPTION_DRIVER_STR);
        if( driver_name == null || driver_name.length() <= 0 )
            drvman.cinput(comm);
        else
            drvman.addDriver(driver_name);
        // hCõ[h
        drvman.cload(comm);
    }

    static String  initializeConnection(CommandLineOptions opts,CommBean comm) throws IOException, SQLException
    {
        ConnBean  conn = new ConnBean();
        // ڑ
        String connect_info = opts.getOptionString(OPTION_CONNECT_STR);
        if( connect_info == null )
            conn.cinput(comm);
        else
            conn.setConnectionInfo(connect_info);

        // DBڑJn
        conn.startup(comm);
        conn_man.putCtx(conn);
        return conn.getName();
    }

}
