/*
 * Decompiled with CFR 0.152.
 */
package clib.com;

import clib.bean.CommBean;
import java.io.IOException;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class DriverLoader {
    Vector drivers = new Vector();
    Vector loaded_drivers = new Vector();
    static final String DEFAULT_DRIVER_NAME = "sun.jdbc.odbc.JdbcOdbcDriver";

    public void addDriver(String driver_name) {
        StringTokenizer st = new StringTokenizer(driver_name, ",");
        while (st.hasMoreTokens()) {
            String driver = st.nextToken();
            if (driver == null || driver.length() <= 0 || this.drivers.contains(driver)) continue;
            this.drivers.addElement(driver);
        }
    }

    public String cinput(CommBean comm) throws IOException {
        comm.print("JDBCDriver [sun.jdbc.odbc.JdbcOdbcDriver]: ");
        comm.flush();
        String driver_name = comm.readLine();
        if (driver_name.length() <= 0) {
            driver_name = DEFAULT_DRIVER_NAME;
        }
        return driver_name;
    }

    public void cload(CommBean comm) throws ClassNotFoundException {
        String err_driver = "";
        int load_cnt = 0;
        Enumeration i = this.drivers.elements();
        while (i.hasMoreElements()) {
            String driver_name = (String)i.nextElement();
            if (this.loaded_drivers.contains(driver_name)) continue;
            try {
                Class.forName(driver_name);
                comm.out().println("Load JDBCDriver \"" + driver_name + "\"");
                this.loaded_drivers.addElement(driver_name);
                ++load_cnt;
            }
            catch (ClassNotFoundException classNotFoundException) {
                comm.out().println("JDBCDriver \"" + driver_name + "\" NotFound");
                err_driver = String.valueOf(err_driver) + driver_name + ",";
            }
        }
        if (load_cnt == 0 && err_driver.length() > 0) {
            throw new ClassNotFoundException(err_driver);
        }
    }
}

