/*
 * ********************************************************************
 * SQLC Release 1.0.0
 * ********************************************************************
 */
package clib.com;

import java.util.*;

/**
 * CommandLineOptions
 *
 * @since     JDK1.1
 * @author    dynaworks
 */
public class CommandLineOptions
{
    /** R}hC */
    String[] argv;
    /** IvV */
    Hashtable argvs;
    /** XCb` */
    char switch_char;
    /** l */
    char value_char;

    /**
     * \z
     */
    public CommandLineOptions(String[] argv,char switch_char,char value_char)
    {
        this.argv = argv;
        this.switch_char = switch_char;
        this.value_char = value_char;
        argvs = new Hashtable();
        parsCommandLineOptions();
    }

    private void parsCommandLineOptions()
    {
        argvs = new Hashtable();
        String option_name;
        String option_value;
        for(int i=0;i<argv.length;i++)
        {
            option_name = argv[i];
            option_value = "";
            if( option_name.charAt(0) == switch_char )
            {
                option_name = option_name.substring(1);
                int idx = option_name.indexOf(value_char);
                if( idx >= 0 )
                {
                    option_value = option_name.substring(idx+1);
                    option_name = option_name.substring(0,idx);
                }
            }
            argvs.put(option_name,option_value);
        }
    }

    public String getOptionString(String name)
    {
        return (String)argvs.get(name);
    }
}
