#ifndef DATA_H
#define DATA_H
/* 使用するデータ型を定義する */

#include <stdio.h>
#include "list.h"

#define VALUE_LENGTH 1048575
#define MODE_LENGTH 10
#define DEFAULT_LENGTH 1024
#define NUM_LENGTH 20
#define DATE_LENGTH 20
#define MAX_FILE_SIZE 512
#define LIST_COUNT_PER_LIST_PAGE 15
#define LIST_COUNT_PER_SEARCH_PAGE 30

typedef enum _bool {
    false = 0,
    true
} bool;

typedef struct {
    int id;
    char name[DEFAULT_LENGTH];
    int sort;
    int deleted;
} ProjectInfo;
ProjectInfo* project_info_new();
void project_info_free(ProjectInfo*);

typedef struct {
  char name[DEFAULT_LENGTH];
  char home_description[DEFAULT_LENGTH];
  char home_url[DEFAULT_LENGTH];
} Project;
Project* project_new();
void project_free(Project*);

typedef struct {
  int element_type_id;
  char* str_val;
  int is_file;
} Element;

typedef struct {
    char name[DEFAULT_LENGTH];
    char file_name[DEFAULT_LENGTH];
    int size;
    char mime_type[DEFAULT_LENGTH];
    char* content;
} SettingFile;
SettingFile* setting_file_new();
void setting_file_free(SettingFile*);

typedef struct {
  int id;
  List* elements;
} Message;
Message* message_new();
void message_free(Message*);

typedef struct {
  int id;
  int element_type_id;
  char name[256];
  int close;
  int sort;
} ListItem;
ListItem* list_item_new();
void list_item_free(ListItem*);

typedef struct {
  int id;
  int type;
  int ticket_property;
  int reply_property;
  int required;
  char name[DEFAULT_LENGTH];
  char description[DEFAULT_LENGTH];
  int auto_add_item;
  char default_value[DEFAULT_LENGTH];
  int display_in_list;
  int sort;
} ElementType;

typedef struct {
    int id;
    int element_type_id;
    char name[DEFAULT_LENGTH];
    int size;
    char mime_type[DEFAULT_LENGTH];
    char* content;
} ElementFile;
ElementFile* element_file_new();
void element_file_free(ElementFile*);

enum ELEM_TYPE {
  ELEM_TYPE_TEXT,
  ELEM_TYPE_TEXTAREA,
  ELEM_TYPE_CHECKBOX,
  ELEM_TYPE_LIST_SINGLE,
  ELEM_TYPE_LIST_MULTI,
  ELEM_TYPE_UPLOADFILE,
  ELEM_TYPE_DATE
};
enum ELEM_ID {
    ELEM_ID_ID = -1,
    ELEM_ID_TITLE = 1,
    ELEM_ID_SENDER = 2,
    ELEM_ID_STATUS = 3,
    ELEM_ID_REGISTERDATE = -2,
    ELEM_ID_LASTREGISTERDATE = -3,
    ELEM_ID_ORG_SENDER = -4,
    ELEM_ID_LASTREGISTERDATE_PASSED = -5
};
#define BASIC_ELEMENT_MAX 3

typedef struct {
  int element_type_id;
  int condition_type;
  char value[DEFAULT_LENGTH];
  char cookie_value[DEFAULT_LENGTH];
} Condition;
enum CONDITION_TYPE {
    CONDITION_TYPE_NORMAL,
    CONDITION_TYPE_DATE_FROM,
    CONDITION_TYPE_DATE_TO
};
Condition* condition_new();
void condition_free(Condition*);
void set_condition_values(Condition*, int, int, char*, char*, bool);
char* get_condition_value(List*, int, int);
int valid_condition_size(List*);
bool valid_condition(Condition*);
char* get_condition_valid_value(Condition*);

typedef struct {
  int id;
  char name[DEFAULT_LENGTH];
  int count;
} State;

typedef struct {
  int hit_count;
  int page;
  List* messages;
  List* states;
} SearchResult;
SearchResult* search_result_new();
void search_result_free(SearchResult*);

typedef struct {
  int id;
  char name[DEFAULT_LENGTH];
  char* content;
} Wiki;
Wiki* wiki_new();
void wiki_free(Wiki*);

char* get_element_value_by_id(List*, const int);
char* get_element_value(List*, ElementType*);
// int get_element_lid_by_id(List*, int);
void set_element_value(Element*, const char*);
void free_element_list(List*);



#endif
/* vim: set ts=4 sw=4 sts=4 expandtab fenc=utf-8: */
