/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stew;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.argius.logging.Logger;
import net.argius.logging.LoggerFactory;
import net.argius.stew.DynamicLoader;
import net.argius.stew.DynamicLoadingException;
import net.argius.stew.Iteration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ConnectorDriverManager {
    private static final Logger log = LoggerFactory.getLogger(ConnectorDriverManager.class);
    static final Set<File> driverFiles = Collections.synchronizedSet(new LinkedHashSet());
    static final Set<Driver> drivers = Collections.synchronizedSet(new LinkedHashSet());

    private ConnectorDriverManager() {
    }

    /*
     * WARNING - void declaration
     */
    static Driver getDriver(String string, String string2, String string3) throws SQLException {
        Driver driver;
        void var5_8;
        boolean bl;
        Object object;
        ArrayList<URL> arrayList;
        boolean bl2;
        assert (!ConnectorDriverManager.isBlank(string));
        boolean bl3 = bl2 = !ConnectorDriverManager.isBlank(string3);
        if (!bl2) {
            for (Driver object22 : new ArrayList<Driver>(drivers)) {
                if (!object22.acceptsURL(string)) continue;
                return object22;
            }
        }
        ArrayList arrayList2 = new ArrayList();
        if (bl2) {
            arrayList = new ArrayList<URL>();
            for (String iOException : string3.split(File.pathSeparator)) {
                File file = new File(iOException);
                if (ConnectorDriverManager.isJarFile(file)) {
                    arrayList2.add(file);
                }
                try {
                    arrayList.add(file.toURL());
                }
                catch (MalformedURLException malformedURLException) {
                    log.warn(malformedURLException);
                }
            }
            URLClassLoader uRLClassLoader = new URLClassLoader(arrayList.toArray(new URL[arrayList.size()]));
        } else {
            arrayList2.addAll(ConnectorDriverManager.getJarFiles("."));
            arrayList2.addAll(driverFiles);
            arrayList = new ArrayList();
            object = arrayList2.iterator();
            while (object.hasNext()) {
                File file = (File)object.next();
                try {
                    arrayList.add(file.toURL());
                }
                catch (MalformedURLException malformedURLException) {
                    log.warn(malformedURLException);
                }
            }
            URLClassLoader uRLClassLoader = new URLClassLoader(arrayList.toArray(new URL[arrayList.size()]), ClassLoader.getSystemClassLoader());
        }
        driverFiles.addAll(arrayList2);
        boolean bl4 = bl = !ConnectorDriverManager.isBlank(string2);
        if (bl) {
            object = (Driver)DynamicLoader.newInstance(string2, (ClassLoader)var5_8);
            assert (object != null);
            return object;
        }
        object = System.getProperty("jdbc.drivers");
        if (!ConnectorDriverManager.isBlank((String)object)) {
            for (String string4 : ((String)object).split(":")) {
                try {
                    driver = (Driver)DynamicLoader.newInstance(string4, (ClassLoader)var5_8);
                    if (driver != null) {
                        if (!bl2) {
                            drivers.add(driver);
                        }
                        return driver;
                    }
                }
                catch (DynamicLoadingException dynamicLoadingException) {
                    log.warn(dynamicLoadingException);
                }
            }
        }
        String[] stringArray = arrayList2.iterator();
        while (stringArray.hasNext()) {
            File file = (File)stringArray.next();
            try {
                Driver driver2 = ConnectorDriverManager.getDriver(file, string, (ClassLoader)var5_8);
                if (driver2 == null) continue;
                if (!bl2) {
                    drivers.add(driver2);
                }
                return driver2;
            }
            catch (IOException iOException) {
                log.warn(iOException);
            }
        }
        for (String string5 : System.getProperty("java.class.path", "").split(File.pathSeparator)) {
            if (!ConnectorDriverManager.isJarFile(string5)) continue;
            try {
                driver = ConnectorDriverManager.getDriver(new File(string5), string, (ClassLoader)var5_8);
                if (driver == null) continue;
                drivers.add(driver);
                return driver;
            }
            catch (IOException iOException) {
                log.warn(iOException);
            }
        }
        throw new SQLException("driver not found");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Driver getDriver(File file, String string, ClassLoader classLoader) throws IOException {
        ZipFile zipFile = new ZipFile(file);
        try {
            for (ZipEntry zipEntry : Iteration.asIterable(zipFile.entries())) {
                String string2 = zipEntry.getName();
                if (!string2.endsWith(".class")) continue;
                String string3 = string2.replaceFirst("\\.class", "").replace('/', '.');
                try {
                    Driver driver;
                    Class clazz = DynamicLoader.loadClass(string3, classLoader);
                    if (!Driver.class.isAssignableFrom(clazz) || !(driver = (Driver)clazz.newInstance()).acceptsURL(string)) continue;
                    Driver driver2 = driver;
                    return driver2;
                }
                catch (Exception exception) {
                    if (!log.isTraceEnabled()) continue;
                    log.trace(exception);
                }
            }
        }
        finally {
            zipFile.close();
        }
        return null;
    }

    private static List<File> getJarFiles(String string) {
        File file = new File(string);
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return Collections.emptyList();
        }
        ArrayList<File> arrayList = new ArrayList<File>();
        for (File file2 : fileArray) {
            if (!ConnectorDriverManager.isJarFile(file2)) continue;
            arrayList.add(file2);
        }
        return arrayList;
    }

    private static boolean isJarFile(File file) {
        return ConnectorDriverManager.isJarFile(file.getPath());
    }

    private static boolean isJarFile(String string) {
        return string.matches("(?i).+\\.(jar|zip)");
    }

    private static boolean isBlank(String string) {
        return string == null || string.trim().length() == 0;
    }
}

