/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stew.command;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import net.argius.logging.Logger;
import net.argius.logging.LoggerFactory;
import net.argius.stew.ColumnOrder;
import net.argius.stew.Command;
import net.argius.stew.CommandException;
import net.argius.stew.Parameter;
import net.argius.stew.ResultSetReference;
import net.argius.stew.UsageException;

public final class Report
extends Command {
    private static final Logger log = LoggerFactory.getLogger(Report.class);

    public void execute(Connection connection, Parameter parameter) throws CommandException {
        if (parameter.isEmpty(2)) {
            throw new UsageException(this.getUsage());
        }
        try {
            String string = parameter.get(2);
            if (string.equals("-")) {
                this.reportDBInfo(connection);
            } else {
                DatabaseMetaData databaseMetaData = connection.getMetaData();
                String string2 = string;
                String string3 = parameter.asString();
                String string4 = parameter.get(3);
                if (string4.equalsIgnoreCase("PK")) {
                    this.reportPrimaryKeyInfo(databaseMetaData, string2, string3);
                } else if (string4.equalsIgnoreCase("INDEX")) {
                    this.reportIndexInfo(databaseMetaData, string2, string3);
                } else {
                    this.reportTableDescription(databaseMetaData, string2, string3);
                }
            }
        }
        catch (SQLException sQLException) {
            throw new CommandException(sQLException);
        }
    }

    public boolean isReadOnly() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reportTableDescription(DatabaseMetaData databaseMetaData, String string, String string2) throws SQLException {
        if (log.isDebugEnabled()) {
            log.debug("report table-description of : " + string);
        }
        ResultSet resultSet = databaseMetaData.getColumns(null, null, this.convertPattern(string), null);
        try {
            ResultSetReference resultSetReference = new ResultSetReference(resultSet, string2);
            ColumnOrder columnOrder = resultSetReference.getOrder();
            columnOrder.addOrder(17, this.getColumnName("sequence"));
            columnOrder.addOrder(4, this.getColumnName("columnname"));
            columnOrder.addOrder(18, this.getColumnName("nullable"));
            columnOrder.addOrder(6, this.getColumnName("type"));
            columnOrder.addOrder(7, this.getColumnName("size"));
            columnOrder.addOrder(2, this.getColumnName("schema"));
            this.output(resultSetReference);
            this.outputMessage("i.selected", resultSetReference.getRecordCount());
        }
        finally {
            resultSet.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reportPrimaryKeyInfo(DatabaseMetaData databaseMetaData, String string, String string2) throws SQLException {
        if (log.isDebugEnabled()) {
            log.debug("report primary-key of : " + string);
        }
        ResultSet resultSet = databaseMetaData.getPrimaryKeys(null, null, this.convertPattern(string));
        try {
            ResultSetReference resultSetReference = new ResultSetReference(resultSet, string2);
            ColumnOrder columnOrder = resultSetReference.getOrder();
            columnOrder.addOrder(1, this.getColumnName("catalog"));
            columnOrder.addOrder(2, this.getColumnName("schema"));
            columnOrder.addOrder(3, this.getColumnName("tablename"));
            columnOrder.addOrder(5, this.getColumnName("sequence"));
            columnOrder.addOrder(4, this.getColumnName("columnname"));
            columnOrder.addOrder(6, this.getColumnName("keyname"));
            this.output(resultSetReference);
            this.outputMessage("i.selected", resultSetReference.getRecordCount());
        }
        finally {
            resultSet.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reportIndexInfo(DatabaseMetaData databaseMetaData, String string, String string2) throws SQLException {
        if (log.isDebugEnabled()) {
            log.debug("report index of : " + string);
        }
        ResultSet resultSet = databaseMetaData.getIndexInfo(null, null, this.convertPattern(string), false, false);
        try {
            ResultSetReference resultSetReference = new ResultSetReference(resultSet, string2);
            ColumnOrder columnOrder = resultSetReference.getOrder();
            columnOrder.addOrder(1, this.getColumnName("catalog"));
            columnOrder.addOrder(2, this.getColumnName("schema"));
            columnOrder.addOrder(3, this.getColumnName("tablename"));
            columnOrder.addOrder(8, this.getColumnName("sequence"));
            columnOrder.addOrder(9, this.getColumnName("columnname"));
            columnOrder.addOrder(6, this.getColumnName("keyname"));
            this.output(resultSetReference);
            this.outputMessage("i.selected", resultSetReference.getRecordCount());
        }
        finally {
            resultSet.close();
        }
    }

    private void reportDBInfo(Connection connection) throws SQLException {
        if (log.isDebugEnabled()) {
            log.debug("report dbinfo");
        }
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        this.outputMessage("Report.dbinfo", databaseMetaData.getDatabaseProductName(), databaseMetaData.getDatabaseProductVersion(), databaseMetaData.getDriverName(), databaseMetaData.getDriverVersion(), databaseMetaData.getUserName(), databaseMetaData.getURL());
    }

    private String getColumnName(String string) {
        return this.getMessage("Report.label." + string, new Object[0]);
    }
}

