/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stew.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigDecimal;
import java.util.Date;

public final class StringBasedSerializer {
    private StringBasedSerializer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Element serialize(Object object) throws IOException {
        String string;
        String string2;
        if (object == null) {
            string2 = "null";
            string = null;
        } else if (object instanceof String) {
            string2 = "string";
            string = (String)object;
        } else if (object instanceof Boolean) {
            string2 = "boolean";
            string = object.toString();
        } else if (object instanceof Byte) {
            string2 = "byte";
            string = object.toString();
        } else if (object instanceof Short) {
            string2 = "short";
            string = object.toString();
        } else if (object instanceof Integer) {
            string2 = "int";
            string = object.toString();
        } else if (object instanceof Long) {
            string2 = "long";
            string = object.toString();
        } else if (object instanceof Float) {
            string2 = "float";
            string = object.toString();
        } else if (object instanceof Double) {
            string2 = "double";
            string = object.toString();
        } else if (object instanceof BigDecimal) {
            string2 = "decimal";
            string = object.toString();
        } else if (object instanceof Date) {
            string2 = "time";
            Date date = (Date)object;
            string = Long.toString(date.getTime());
        } else {
            string2 = "object";
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            try {
                objectOutputStream.writeObject(object);
                string = StringBasedSerializer.toHexString(byteArrayOutputStream.toByteArray());
            }
            finally {
                objectOutputStream.close();
            }
        }
        return new Element(string2, string);
    }

    public static Object deserialize(Element element) throws IOException {
        return StringBasedSerializer.deserialize(element.getType(), element.getValue());
    }

    public static Object deserialize(String string, String string2) throws IOException {
        Object object;
        if (string.equals("null")) {
            object = null;
        } else if (string.equals("string")) {
            object = string2;
        } else if (string.equals("boolean")) {
            object = Boolean.valueOf(string2);
        } else if (string.equals("byte")) {
            object = Byte.valueOf(string2);
        } else if (string.equals("short")) {
            object = Short.valueOf(string2);
        } else if (string.equals("int")) {
            object = Integer.valueOf(string2);
        } else if (string.equals("long")) {
            object = Long.valueOf(string2);
        } else if (string.equals("float")) {
            object = Float.valueOf(string2);
        } else if (string.equals("double")) {
            object = Double.valueOf(string2);
        } else if (string.equals("decimal")) {
            object = new BigDecimal(string2);
        } else if (string.equals("time")) {
            object = new Date(Long.parseLong(string2));
        } else if (string.equals("object")) {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(StringBasedSerializer.toBytes(string2));
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            try {
                object = objectInputStream.readObject();
            }
            catch (ClassNotFoundException classNotFoundException) {
                IOException iOException = new IOException(classNotFoundException.getMessage());
                iOException.initCause(classNotFoundException);
                throw iOException;
            }
            finally {
                objectInputStream.close();
            }
        } else {
            throw new IOException("unknown element : " + string);
        }
        return object;
    }

    private static String toHexString(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder(byArray.length * 2);
        for (byte by : byArray) {
            stringBuilder.append(String.format("%02X", by & 0xFF));
        }
        return stringBuilder.toString();
    }

    private static byte[] toBytes(String string) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        for (int i = 0; i < string.length(); i += 2) {
            String string2 = string.substring(i, i + 2);
            byteArrayOutputStream.write(Integer.parseInt(string2, 16));
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static final class Element {
        public static final String NULL = "null";
        public static final String STRING = "string";
        public static final String BOOLEAN = "boolean";
        public static final String BYTE = "byte";
        public static final String SHORT = "short";
        public static final String INT = "int";
        public static final String LONG = "long";
        public static final String FLOAT = "float";
        public static final String DOUBLE = "double";
        public static final String DECIMAL = "decimal";
        public static final String TIME = "time";
        public static final String OBJECT = "object";
        private final String type;
        private final String value;

        Element(String string, String string2) {
            this.type = string == null ? NULL : string;
            this.value = string2;
        }

        public String getType() {
            return this.type;
        }

        public String getValue() {
            return this.value;
        }

        public boolean isNull() {
            return this.type == NULL || this.value == null;
        }

        public String toString() {
            return this.type + ":" + this.value;
        }
    }
}

