/*
 *  Copyright 2010 argius
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 */
package net.argius.logging;

import java.lang.reflect.*;

/**
 * Logger̃t@NgB
 */
public final class LoggerFactory {

    private static final NullLogger NULL_LOGGER = new NullLogger();
    private static final boolean enable = Boolean.getBoolean("net.argius.logging");
    private static final String fqcn = System.getProperty("net.argius.logging.class");
    private static final String level = System.getProperty("net.argius.logging.level", "INFO");

    private LoggerFactory() {
        // empty
    }

    /**
     * Logger̎擾B
     * @return Logger
     */
    public static Logger getLogger() {
        return createLogger("");
    }

    /**
     * Logger̎擾B
     * @param targetName Ώۖ
     * @return Logger
     */
    public static Logger getLogger(String targetName) {
        return createLogger(targetName);
    }

    /**
     * Logger̎擾B
     * @param targetClass ΏۃNX
     * @return Logger
     */
    public static Logger getLogger(Class<?> targetClass) {
        return createLogger(targetClass.getName());
    }

    /**
     * Logger̐B
     * @param targetName Ώۖ
     * @return Logger
     */
    private static Logger createLogger(String targetName) {
        if (enable) {
            Logger log;
            try {
                Class<?> loggerClass = Class.forName(fqcn);
                Constructor<?> ctor = loggerClass.getConstructor(new Class[]{String.class});
                log = (Logger)ctor.newInstance(new Object[]{targetName});
            } catch (Throwable th) {
                log = new StandardErrorOutputLogger(targetName);
            }
            log.setLevel(level);
            return log;
        }
        return NULL_LOGGER;
    }

}