/*
 *  Copyright 2010 argius
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 */
package net.argius.stew;

/**
 * p[^B
 */
public final class Parameter {

    private final char[] chars;
    private final boolean hasSpace;

    /**
     * w肳ꂽɂp[^\zB
     * @param string p[^
     */
    public Parameter(String string) {
        char[] chars = string.toCharArray();
        boolean hasSpace = false;
        for (char c : chars) {
            if (isSpaceChar(c)) {
                hasSpace = true;
                break;
            }
        }
        this.chars = chars;
        this.hasSpace = hasSpace;
    }

    /**
     * w肵Ԃ̃p[^擾B
     * @param number 
     * @return p[^
     */
    public String get(int number) {
        if (!hasSpace) {
            return (number == 1) ? getAll() : "";
        }
        return get(number - 1, number);
    }

    /**
     * w肵ԊԂ̃p[^擾B
     * @param number1 1
     * @param number2 2
     * @return p[^
     */
    private String get(int number1, int number2) {
        if (number1 < 0) {
            throw new IllegalArgumentException("'number' starts from 1");
        }
        int begin = seek(number1);
        int end = seek(number2);
        for (; begin < end; begin++) {
            if (!isSpaceChar(chars[begin])) {
                break;
            }
        }
        return String.valueOf(chars, begin, end - begin);
    }

    /**
     * Xy[X̐؂ڂTB
     * @param number 
     * @return ʒu
     */
    private int seek(int number) {
        if (number == 0 || chars.length < 2) {
            return 0;
        }
        int count = 0;
        for (int i = 1; i < chars.length; i++) {
            if (!isSpaceChar(chars[i - 1]) && isSpaceChar(chars[i])) {
                ++count;
            }
            if (count == number) {
                return i;
            }
        }
        return chars.length;
    }

    private static boolean isSpaceChar(char c) {
        switch (c) {
            case '\t':
            case '\n':
            case '\f':
            case '\r':
            case ' ':
                return true;
            default:
        }
        return false;
    }

    /**
     * p[^SĎ擾B
     * @return p[^
     */
    public String getAll() {
        return String.valueOf(chars);
    }

    /**
     * w肵Ԉȍ~̃p[^SĎ擾B
     * @param number 
     * @return p[^
     */
    public String getAll(int number) {
        if (!hasSpace) {
            return (number == 1) ? getAll() : "";
        }
        return get(number - 1, chars.length);
    }

    /**
     * w肵Ԃ̃p[^󂩂ǂ𒲂ׂB
     * @param number 
     * @return w肵Ԃ̃p[^󂩂ǂ
     */
    public boolean isEmpty(int number) {
        return get(number).length() == 0;
    }

    /**
     * p[^zƂĎ擾B
     * @return p[^̔z
     */
    public String[] asArray() {
        return String.valueOf(chars).split("\\s");
    }

    /**
     * p[^𕶎ƂĎ擾B
     * <code>toString</code>Ƃ͈قȂB
     * @return p[^
     */
    public String asString() {
        return String.valueOf(chars);
    }

    @Override
    public String toString() {
        return "Parameter[" + getAll() + "]";
    }

}