/*
 *  Copyright 2010 argius
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 */
package net.argius.stew;

import static net.argius.stew.Resource.EMPTY_STRING;

/**
 * pX[hB
 * uϊꂽpX[hvɕƂȂB
 */
public final class PlainTextPassword implements Password {

    private String rowString;

    /* @see net.argius.stew.Password#getTransformedString() */
    public String getTransformedString() {
        return getRowString();
    }

    /* @see net.argius.stew.Password#setTransformedString(java.lang.String) */
    public void setTransformedString(String transformedString) {
        setRowString(transformedString);
    }

    /* @see net.argius.stew.Password#getRowString() */
    public String getRowString() {
        return (hasPassword()) ? rowString : EMPTY_STRING;
    }

    /* @see net.argius.stew.Password#setRowString(java.lang.String) */
    public void setRowString(String rowString) {
        if (rowString != null) {
            this.rowString = rowString;
        }
    }

    /* @see net.argius.stew.Password#hasPassword() */
    public boolean hasPassword() {
        return rowString != null;
    }

}
