/*
 *  Copyright 2010 argius
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 */
package net.argius.stew.io;

import java.io.*;

/**
 * HTML`̃GNX|[gB
 */
public final class HtmlExporter extends Exporter {

    private PrintWriter out;

    /**
     * RXgN^B
     * @param os OutputStream
     * @param title HTML̃^Cg
     */
    public HtmlExporter(OutputStream os, String title) {
        super(os);
        this.out = new PrintWriter(os);
        out.println("<html>");
        out.println("<head>");
        out.printf("<title>%s</title>%n", title);
        out.println("</head>");
        out.println("<body>");
        out.printf("<h1>%s</h1>%n", title);
        out.println("<table>");
        out.flush();
    }

    @Override
    protected void writeHeader(Object[] header) throws IOException {
        ensureOpen();
        out.println("<tr>");
        for (Object o : header) {
            out.printf("<th>%s</th>%n", o);
        }
        out.println("</tr>");
        out.flush();
    }

    @Override
    public void addRow(Object[] values) throws IOException {
        ensureOpen();
        out.println("<tr>");
        for (Object o : values) {
            out.printf("<td>%s</td>%n", o);
        }
        out.println("</tr>");
        out.flush();
    }

    @Override
    public void close() throws IOException {
        ensureOpen();
        try {
            if (out != null) {
                out.println("</table>");
                out.println("</body>");
                out.println("</html>");
                out.flush();
                out.close();
            }
        } finally {
            out = null;
            super.close();
        }
    }

}
