/*
 *  Copyright 2010 argius
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 */
package net.argius.stew.io;

import java.io.*;
import java.net.*;

/**
 * pXB
 */
public final class Path extends File {

    private static final long serialVersionUID = 6787315355616650978L;

    private static final String PATTERN_EXTENSION = "^.*\\.([^\\.]+)$";

    /**
     * RXgN^B
     * @param file t@C
     */
    public Path(File file) {
        super(file.getPath());
    }

    /**
     * RXgN^B
     * @param parent epX
     * @param child qpX
     */
    public Path(File parent, String child) {
        super(parent, child);
    }

    /**
     * RXgN^B
     * @param pathname pX
     */
    public Path(String pathname) {
        super(pathname);
    }

    /**
     * RXgN^B
     * @param parent epX
     * @param child qpX
     */
    public Path(String parent, String child) {
        super(new File(parent), child);
    }

    /**
     * RXgN^B
     * @param uri URI
     */
    public Path(URI uri) {
        super(uri);
    }

    /**
     * pXB
     * @param parent epX
     * @param child qpX
     * @return pX
     */
    public static Path resolve(File parent, File child) {
        if (child.isAbsolute()) {
            return new Path(child.getAbsolutePath());
        }
        return new Path(parent, child.getPath());
    }

    /**
     * pXB
     * @param parent epX
     * @param child qpX
     * @return pX
     */
    public static Path resolve(File parent, String child) {
        return resolve(parent, new File(child));
    }

    /**
     * pXB
     * @param parent epX
     * @param child qpX
     * @return pX
     */
    public static Path resolve(String parent, String child) {
        return resolve(new File(parent), child);
    }

    /**
     * gq̎擾B
     * @return gq
     * @see #getExtension(String)
     */
    public String getExtension() {
        return getExtension(getPath());
    }

    /**
     * gq̎擾B
     * @param file t@C
     * @return gq
     * @see #getExtension(String)
     */
    public static String getExtension(File file) {
        return getExtension(file.getName());
    }

    /**
     * gq̎擾B
     * pX񒆂<code>"."</code>isIhj݂ꍇA
     * ł<code>"."</code>̎̕Ō܂łgqƂB
     * <code>"."</code>݂ȂꍇA󕶎ԂB
     * @param path pX
     * @return gq
     */
    public static String getExtension(String path) {
        if (path.matches(PATTERN_EXTENSION)) {
            return path.replaceFirst(PATTERN_EXTENSION, "$1");
        }
        return "";
    }

    /**
     * fBNg쐬B
     * @throws IOException fBNg̍쐬Ɏsꍇ
     */
    public void makeDirectory() throws IOException {
        makeDirectory(this);
    }

    /**
     * fBNg쐬B
     * @param file File
     * @throws IOException fBNg̍쐬Ɏsꍇ
     */
    public static void makeDirectory(File file) throws IOException {
        if (!file.isDirectory()) {
            if (!file.mkdirs() || !file.isDirectory()) {
                throw new IOException("can't make directory: " + file);
            }
        }
    }

}
