/*
 *  Copyright 2010 argius
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 */
package net.argius.stew;

import java.util.*;

/**
 * RlN^B
 */
final class AnonymousConnector {

    private static final String PREFIX_JDBC = "jdbc:";

    private AnonymousConnector() {
        // empty
    }

    /**
     * RlN^̎擾B
     * @param uri URI
     * @return RlN^B
     */
    public static Connector getConnector(String uri) {
        int index1 = uri.indexOf('@');
        if (index1 < 0) {
            throw new IllegalArgumentException(uri);
        }
        String userInfo = uri.substring(0, index1);
        String url = uri.substring(index1 + 1);
        String user;
        String password;
        int index2 = userInfo.indexOf('/');
        if (index2 >= 0) {
            user = userInfo.substring(0, index2);
            password = userInfo.substring(index2 + 1);
        } else {
            user = userInfo;
            password = "";
        }
        return getConnector(url, user, password);
    }

    /**
     * RlN^̎擾B
     * @param url URL
     * @param user [U
     * @param password pX[h
     * @return RlN^B
     */
    public static Connector getConnector(String url, String user, String password) {
        Properties props = new Properties();
        props.setProperty("name", getName(url, user));
        props.setProperty("driver", "");
        props.setProperty("classpath", "");
        props.setProperty("url", url);
        props.setProperty("user", user);
        props.setProperty("readonly", Boolean.FALSE.toString());
        props.setProperty("rollback", Boolean.FALSE.toString());
        Connector connector = new Connector("ANONYMOUS", props);
        connector.getPassword().setRowString(password);
        return connector;
    }

    /**
     * RlN^̎擾B
     * @param url URL
     * @param user [U
     * @return RlN^
     */
    private static String getName(String url, String user) {
        return String.format("%s@%s", user, url.startsWith(PREFIX_JDBC)
                ? url.substring(PREFIX_JDBC.length())
                : url);
    }

}
