/*
 *  Copyright 2010 argius
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 */
package net.argius.stew.ui.window;

import java.io.*;
import java.util.*;
import java.util.zip.*;

/**
 * NXB
 */
class ClassFinder {

    private String rootPath;
    private ClassLoader classLoader;
    private boolean failMode;

    /**
     * RXgN^B
     * @param rootPath pX
     */
    ClassFinder(String rootPath) {
        this.rootPath = normalizePath(rootPath);
        this.classLoader = ClassLoader.getSystemClassLoader();
    }

    /**
     * NX[_̐ݒB
     * @param classLoader NX[_
     */
    void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    /**
     * "FailMode"̐ݒB
     * FailModeLɂꍇAOX[ <code>fail(Object)</code> ĂяoB
     * @param failMode FailModeLɂꍇ <code>true</code>
     */
    void setFailMode(boolean failMode) {
        this.failMode = failMode;
    }

    /**
     * NXB
     * @param file Jnt@C܂̓fBNg
     */
    final void find(File file) {
        try {
            final File f = file.getCanonicalFile();
            if (f.isDirectory()) {
                File[] files = f.listFiles();
                if (files != null) {
                    for (File child : files) {
                        find(child);
                    }
                }
            } else {
                final String name = f.getName();
                if (name.matches("(?i).+\\.class")) {
                    try {
                        filter(resolveClass(f.getPath()));
                    } catch (Throwable ex) {
                        if (failMode) {
                            fail(f, ex);
                        } else {
                            throw new RuntimeException(ex);
                        }
                    }
                } else if (name.matches("(?i).+\\.(jar|zip)")) {
                    find(new ZipFile(f));
                }
            }
        } catch (IOException ex) {
            if (failMode) {
                fail(file, ex);
            } else {
                throw new RuntimeException(ex);
            }
        }
    }

    /**
     * NXB
     * @param zipFile ZIP`t@C(Jart@C܂)
     */
    final void find(ZipFile zipFile) {
        Enumeration<?> en = zipFile.entries();
        while (en.hasMoreElements()) {
            ZipEntry entry = (ZipEntry)en.nextElement();
            String name = entry.getName();
            if (name.matches("(?i).+\\.class")) {
                try {
                    filter(resolveClass(name));
                } catch (Throwable ex) {
                    if (failMode) {
                        fail(name, ex);
                    } else {
                        throw new RuntimeException(ex);
                    }
                }
            }
        }
    }

    /**
     * I[o[ChāANXtB^B
     * @param c NX
     */
    void filter(Class<?> c) {
        // do nothing
    }

    /**
     * I[o[ChāAFailModȅsB
     * @param object FailModeŏIuWFNg
     * @param cause š
     */
    void fail(Object object, Throwable cause) {
        // do nothing
    }

    /**
     * NXB
     * t@CVXeŌNX
     * NX[_擾B
     * @param path t@CVXe(ZIPGg܂)̃NXt@C
     * @return Class
     * @throws Throwable NX̉Ɏsꍇ
     */
    protected final Class<?> resolveClass(String path) throws Throwable {
        String s = normalizePath(path);
        if (s.startsWith(rootPath)) {
            s = s.substring(rootPath.length() + 1);
        }
        s = s.replaceFirst("\\.class$", "").replace('/', '.');
        return Class.forName(s, false, classLoader);
    }

    /**
     * pX𐳋KB
     * @param path pX
     * @return KꂽpX
     */
    private static String normalizePath(String path) {
        return path.replaceAll("\\\\", "/");
    }

}
