/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stew;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Properties;
import net.argius.stew.Connector;
import net.argius.stew.Password;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConnectorMap
extends LinkedHashMap<String, Connector> {
    public ConnectorMap() {
    }

    public ConnectorMap(List<String> list, Properties properties) {
        for (String string : list) {
            Properties properties2 = new Properties();
            this.copyPropertyById(string, "name", properties, properties2);
            this.copyPropertyById(string, "driver", properties, properties2);
            this.copyPropertyById(string, "classpath", properties, properties2);
            this.copyPropertyById(string, "url", properties, properties2);
            this.copyPropertyById(string, "user", properties, properties2);
            this.copyPropertyById(string, "password", properties, properties2);
            this.copyPropertyById(string, "password.class", properties, properties2);
            this.copyPropertyById(string, "readonly", properties, properties2);
            this.copyPropertyById(string, "rollback", properties, properties2);
            Connector connector = new Connector(string, properties2);
            this.put(string, connector);
        }
    }

    public ConnectorMap(ConnectorMap connectorMap) {
        this.putAll(connectorMap);
    }

    private void copyPropertyById(String string, String string2, Properties properties, Properties properties2) {
        String string3 = string + '.' + string2;
        String string4 = properties.getProperty(string3, "");
        properties2.setProperty(string2, string4);
    }

    public Connector getConnector(String string) {
        return (Connector)this.get(string);
    }

    public void setConnector(String string, Connector connector) {
        this.put(string, connector);
    }

    public Properties toProperties() {
        Properties properties = new Properties();
        for (String string : this.keySet()) {
            Connector connector = this.getConnector(string);
            Password password = connector.getPassword();
            properties.setProperty(string + ".name", connector.getName());
            properties.setProperty(string + ".driver", connector.getDriver());
            properties.setProperty(string + ".classpath", connector.getClasspath());
            properties.setProperty(string + ".url", connector.getUrl());
            properties.setProperty(string + ".user", connector.getUser());
            properties.setProperty(string + ".password", password.getTransformedString());
            properties.setProperty(string + ".password.class", password.getClass().getName());
            properties.setProperty(string + ".readonly", Boolean.toString(connector.isReadOnly()));
            properties.setProperty(string + ".rollback", Boolean.toString(connector.usesAutoRollback()));
        }
        return properties;
    }
}

