/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stew;

import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import net.argius.stew.DynamicLoadingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DynamicLoader {
    private DynamicLoader() {
    }

    public static <T> Class<T> loadClass(String string) throws DynamicLoadingException {
        return DynamicLoader.loadClass(string, ClassLoader.getSystemClassLoader());
    }

    public static <T> Class<T> loadClass(String string, ClassLoader classLoader) throws DynamicLoadingException {
        try {
            Class<?> clazz = classLoader.loadClass(string);
            return clazz;
        }
        catch (Throwable throwable) {
            throw new DynamicLoadingException("class loading error", throwable);
        }
    }

    public static <T> T newInstance(String string) throws DynamicLoadingException {
        T t = DynamicLoader.newInstance(string, DynamicLoader.class.getClassLoader());
        return t;
    }

    public static <T> T newInstance(String string, URL ... uRLArray) throws DynamicLoadingException {
        T t = DynamicLoader.newInstance(string, DynamicLoader.getURLClassLoader(uRLArray));
        return t;
    }

    public static <T> T newInstance(String string, ClassLoader classLoader) throws DynamicLoadingException {
        try {
            Class<T> clazz = DynamicLoader.loadClass(string, classLoader);
            return clazz.newInstance();
        }
        catch (DynamicLoadingException dynamicLoadingException) {
            throw dynamicLoadingException;
        }
        catch (Throwable throwable) {
            throw new DynamicLoadingException("load error: " + string, throwable);
        }
    }

    public static <T> T newInstance(Class<T> clazz) throws DynamicLoadingException {
        try {
            return clazz.newInstance();
        }
        catch (Throwable throwable) {
            throw new DynamicLoadingException("load error: " + clazz, throwable);
        }
    }

    private static URLClassLoader getURLClassLoader(final URL ... uRLArray) {
        return (URLClassLoader)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return new URLClassLoader(uRLArray, ClassLoader.getSystemClassLoader());
            }
        });
    }
}

