/*
 *  Copyright 2010 argius
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 */
package net.argius.stew.ui.window;

import java.util.*;

import net.argius.stew.*;

/**
 * RlN^̃GgB
 */
final class ConnectorEntry {

    private final String id;
    private final Connector connector;

    /**
     * RXgN^B
     * @param id
     * @param connector
     */
    ConnectorEntry(String id, Connector connector) {
        this.id = id;
        this.connector = connector;
    }

    /**
     * RlN^XgGgXg𐶐B
     * @param iterable RlN^Xg
     * @return GgXg
     */
    static List<ConnectorEntry> toList(Iterable<Connector> iterable) {
        return Iteration.map(iterable, new Iteration.Correspondence<Connector, ConnectorEntry>() {

            public ConnectorEntry f(Connector c) {
                return new ConnectorEntry(c.getId(), c);
            }

        });
    }

    /**
     * id̎擾B
     * @return id
     */
    public String getId() {
        return id;
    }

    /**
     * connector̎擾B
     * @return connector
     */
    public Connector getConnector() {
        return connector;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((id == null) ? 0 : id.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectorEntry)) {
            return false;
        }
        ConnectorEntry other = (ConnectorEntry)obj;
        if (id == null) {
            if (other.id != null) {
                return false;
            }
        } else if (!id.equals(other.id)) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        final String name = connector.getName();
        if (name == null || name.length() == 0) {
            return id;
        }
        return String.format("%s (%s)", id, name);
    }

}
